//환율API - 수시로 출력되지 않을 수 있음
var exchangeDataUrl = 'https://quotation-api-cdn.dunamu.com/v1/forex/recent?codes=FRX.KRWUSD';
var exchange = 1;

//코인베이스
var coinbaseData;
var coinbaseDataUrl = 'https://api.pro.coinbase.com/products/'+currancy.toUpperCase()+'-USD/ticker';
var coinbaseStats;
var coinbaseStatsUrl = 'https://api.pro.coinbase.com/products/'+currancy.toUpperCase()+'-USD/stats';

//업비트(한국프리미엄 적용하기 위함)
var upbitData;
var upbitDataUrl = 'https://api.upbit.com/v1/ticker?markets=KRW-'+currancy.toUpperCase();

//거래소 링크 변경
jQuery('#coinbase_link_light').attr('href','https://pro.coinbase.com/trade/'+currancy.toUpperCase()+'-USD');


jQuery.when(
  jQuery.getJSON(exchangeDataUrl, function(data) {
    exchangeData = data;
  }),
  jQuery.getJSON(coinbaseDataUrl, function(data) {
    coinbaseData = data;
  }),
  jQuery.getJSON(coinbaseStatsUrl, function(data) {
    coinbaseStats = data;
  }),
  jQuery.getJSON(upbitDataUrl, function(data) {
    upbitData = data;
  })
).then(function() {
  if(exchangeData){
    exchange = exchangeData[0]['basePrice'];
    jQuery('#exchange_coinbase').number(exchange,2);
  }
  if (coinbaseData) {
    var coin_company = 'coinbase_light';
    var closing_price = coinbaseData['price']*exchange;
    var closing_price_usd = coinbaseData['price'];
    var prev_closing_price = coinbaseStats['open']*exchange;
    var variation_price = closing_price - prev_closing_price;
    var variation_rate = parseFloat((closing_price-prev_closing_price)/prev_closing_price*100);
    if (upbitData) {
      var upbit_closing_price = upbitData[0]['trade_price'];
      var korean_premium = upbit_closing_price - closing_price;
    } else {
      var korean_premium = 0;
    }
    var min_price = coinbaseData['low']*exchange;
    var max_price = coinbaseData['high']*exchange;
    var traded_volume = coinbaseData['volume'];
    var price_unit = '';
    <?php include('coin_marketprice_js_ajax_common.php'); ?>
  }
});
