<?php
  if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

  //플러그인 기본값 설정
  if(!$refresh_interval) $refresh_interval = 3000;

  //플러그인 경로 설정
  $xns_plugin_url = G5_BBS_URL.'/xns_plugins/xns_gnuboard_plugin_coin_marketprice_coinbase';

  //jQuery Number Format JS 설정
  add_javascript('<script src="'.$xns_plugin_url.'/js/jquery-number/jquery.number.min.js"></script>', 0);

  //플러그인 CSS 인클루드
  add_stylesheet('<link rel="stylesheet" href="'.$xns_plugin_url.'/css/plugin.css?'.time().'" />', 11);
  if(G5_IS_MOBILE) {
    add_stylesheet('<link rel="stylesheet" href="'.$xns_plugin_url.'/css/plugin_mobile.css?'.time().'" media="all and (max-width: 768px)" />', 12);
  }
?>


<div class="xns_gnuboard_plugin_coin_marketprice_coinbase" id="xns_gnuboard_plugin_coin_marketprice_coinbase">
  <div class="title_area">
    ▶코인베이스
    <select onchange="refreshCoinMarketpriceCoinbase(this.value,'Y');">
      <option value="btc">
        BTC-USD
      </option>
      <option value="eth">
        ETH-USD
      </option>
    </select>
    <a class="chart_link" id="coinbase_link_light" href="https://pro.coinbase.com/trade/BTC-USD" target="_blank">
      차트보기
    </a>
  </div>

  <div class="marketprice_area">
    <div class="marketprice">
      <table border="0" cellspacing="0">
        <thead>
          <tr>
            <th>
              현재가<br />(KRW)
            </th>
            <th>
              현재가<br />(USD)
            </th>
            <th>
              증감<br />(KRW)
            </th>
            <th>
              증감률<br />(%)
            </th>
            <th>
              K프리미엄<br />(KRW)
            </th>
            <!--th>
              최저가<br />(KRW)
            </th>
            <th>
              최고가<br />(KRW)
            </th-->
            <th>
              거래량<br />(24H)
            </th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <?php
              $coin_company = 'coinbase_light';
              $closing_price = $coinbaseData['price']*$exchange;
              $closing_price_usd = $coinbaseData['price'];
              $prev_closing_price = $coinbaseStats['open']*$exchange;
              $variation_price = $closing_price - $prev_closing_price;
              $variation_rate = floor(($closing_price-$prev_closing_price)/$prev_closing_price*100*100)/100;
              $korean_premium = 0;
              $min_price = $coinbaseStats['low']*$exchange;
              $max_price = $coinbaseStats['high']*$exchange;
              $traded_volume = $coinbaseData['volume'];
              $price_unit = 'USD';
            ?>
            <?php include('coin_marketprice_price.php'); ?>
          </tr>
        </tbody>
      </table>
    </div>
  </div>

  <div class="exchange_area">
    <span class="exchange_wrap">
      ※ 환율:
      <span id="exchange_coinbase"><?php echo number_format($exchangeData['rates']['KRW'],2) ?></span>
      KRW/USD
    </span>
    <span class="notice">
      ※ 해당정보는 실제시세와 다를 수 있으며 법적인 효력이 없습니다.
    </span>
  </div>

  <?php if($investing_widget_output=='Y'){ ?>
  <div class="investing_widget">
    <iframe src="https://kr.widgets.investing.com/top-cryptocurrencies?theme=darkTheme" frameborder="0" allowtransparency="true" marginwidth="0" marginheight="0"></iframe><div class="poweredBy" style="font-family: Arial, Helvetica, sans-serif;">제공자 <a href="https://kr.investing.com?utm_source=WMT&amp;utm_medium=referral&amp;utm_campaign=TOP_CRYPTOCURRENCIES&amp;utm_content=Footer%20Link" target="_blank" rel="nofollow">Investing.com</a></div>
  </div>
  <?php } ?>
</div>


<?php include('coin_marketprice_js.php'); ?>
