<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 01월 27일 월요일 오전 10시 04분, 날씨 겨울치고 맑고 포근하다

	업데이트 작업날짜 : 2015년 01월 10일 토요일 오후 16시 20분 - 날씨 오후되니 쌀쌀하다

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 피리 레벨 도우미 PLUS G5 > 처음
===========================================================


*/


	#########################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	#########################################################

	//=======================================================
	// 메뉴_번호__지정____레벨_도우미
	$sub_menu = "770002";


	//=======================================================
	// 기본처리_화일__첨부
	include_once ('./_common.php');


	//=======================================================
	// 시작 => 회원_아니면
	IF (!$is_member)
	{
		// 경고창
		alert('회원만 이용하실 수 있습니다.', G5_URL);
	}
	// 끝 => 회원_아니면
	//=======================================================


	//=======================================================
	// 관리자_확인
	auth_check($auth[$sub_menu], "r");

	#########################################################
	# 끝 => 선_처리
	#########################################################



	#########################################################
	# 시작 => 레벨__설정_정보_화일__첨부
	#########################################################

	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$is_get__piree_config = 1;


	//=======================================================
	// 레벨_도우미__설정_정보__가져오기
	$is_get__level_helper = 1;


	//=======================================================
	// 설정_화면__여부
	$is_piree_program_config = 1;


	//=======================================================
	// 레벨__설정_정보_화일__경로
	$piree_dir_path = PIREE_CONFIG_PATH ."/p__".$sub_menu."/pi__config.php";


	//=======================================================
	// 레벨__설정_정보_화일__경로
	include_once ($piree_dir_path);

	#########################################################
	# 끝 => 레벨__설정_정보_화일__첨부
	#########################################################



	#########################################################
	# 시작 => 회원_최고_레벨__알아내기
	#########################################################

	//=======================================================
	// 회원__최고_레벨__알아내기
	$sql				 = "SELECT MAX(mb_level) FROM `".$g5['member_table']."`";
	$level_max_n = sql_efv($sql);


	//=======================================================
	// 시작 => 최고_레벨__없으면
	IF (!$level_max_n || $level_max_n < 1)
	{

		$level_max_n = 10;

	}
	// 끝 => 최고_레벨__없으면
	//=======================================================

	#########################################################
	# 끝 => 회원_최고_레벨__알아내기
	#########################################################



	#########################################################
	# 시작 => 상수__변수__기타
	#########################################################

	//=======================================================
	// 레벨당_기준_포인트__지금_적용하기
	$reload__point_plus__checked = "";


	//=======================================================
	// 레벨당_차감_포인트__지금_적용하기
	$reload__point_pay__checked = "";


	//=======================================================
	// 레벨당_가입후_일수__지금_적용하기
	$reload__join_days__checked = "";


	//=======================================================
	// 시작 => 프로그램_코드__없으면
	IF (!$level_helper["prog_c"] || $level_helper["prog_c"] == "")
	{

		//=====================================================
		// 레벨당_기준_포인트__지금_적용하기
		$reload__point_plus__checked = " checked";


		//=====================================================
		// 레벨당_차감_포인트__지금_적용하기
		$reload__point_pay__checked = " checked";


		//=====================================================
		// 레벨당_가입후_일수__지금_적용하기
		$reload__join_days__checked = " checked";

	}
	// 끝 => 프로그램_코드__없으면
	//=======================================================


	//=======================================================
	// 스킨_PC
	$skin_pc_c = $level_helper['skin_pc_c'];


	//=======================================================
	// 스킨_모바일
	$skin_mobile_c = $level_helper['skin_mobile_c'];


	//=======================================================
	// 시작 => 최고_회원_레벨__있으면
	IF ($level_helper["level_max_n"] > 0)
	{
		$level_max_n = $level_helper["level_max_n"];
	}
	// 끝 => 최고_회원_레벨__있으면
	//=======================================================


	//=======================================================
	// 레벨당_기준_포인트
	$point_plus_n = $level_helper["point_plus_n"];


	//=======================================================
	// 레벨당_차감_포인트
	$point_pay_n = $level_helper["point_pay_n"];


	//=======================================================
	// 레벨당_가입후_날짜수
	$join_days_n = $level_helper["join_days_n"];


	//=======================================================
	// 회원_레벨_조정_신청_간격_날짜수__이면
	$level_gap_day_n = $level_helper['level_gap_day_n'];


	//=======================================================
	// 회원_레벨_변경_확인_간격
	$level_check_hour_n = $level_helper['level_check_hour_n'];


	//=======================================================
	// 신청할수_있는_레벨_단계
	$reqest_page_level_t = $level_helper["reqest_page_level_t"];

	#########################################################
	# 끝 => 상수__변수__기타
	#########################################################



	#########################################################
	# 시작 => 마무리__페이지_ECHO_관련
	#########################################################

	//=======================================================
	// 타이틀
	$g5["title"] = "피리 레벨 도우미 PLUS G5";


	//=======================================================
	// HEAD_첨부
	include_once ("../admin.head.php");

	#########################################################
	# 끝 => 마무리__페이지_ECHO_관련
	#########################################################


?>

<section>
		<h2>레벨 도우미 정보 수정하기</h2>

		<form name="level_list" id="level_list" action="./pi__config.update.php" onsubmit="return submit__level_helper(this);" method="post">

		<div class="tbl_frm01 tbl_wrap">
				<table>
				<col class="td_left_150" />
				<col>
				<tbody>

				<tr>
						<th scope="row">PC 스킨</th>
						<td>
								<select id="skin_pc_label" name="skin_pc_c">
<?php

								//=========================================
								// PC__스킨_목록__가져오기
								$skins = get_skin_dir(PIREE_SKIN_PC_DIR, $level_helper["prog_p"]);


								//=========================================
								// 시작 => 반복문__돌리기
								for ($i=0; $i<count($skins); $i++)
								{
										// 선택_여부
										$selected = $skin_pc_c == $skins[$i] ? " selected" : "";
?>
										<option value="<?php echo $skins[$i]; ?>"<?=$selected ?>><?php echo $skins[$i]; ?></option>
<?php
								}
								// 끝 => 반복문__돌리기
								//=========================================

?>
								</select>
						</td>
				</tr>

				<tr>
						<th scope="row">모바일 스킨</th>
						<td>
								<select id="skin_mobile_label" name="skin_mobile_c">
<?php

								//=========================================
								// 모바일__스킨_목록__가져오기
								$skins = get_skin_dir(PIREE_SKIN_MOBILE_DIR, $level_helper["prog_p"]);


								//=========================================
								// 시작 => 반복문__돌리기
								for ($i=0; $i<count($skins); $i++)
								{
										// 선택_여부
										$selected = $skin_mobile_c == $skins[$i] ? " selected" : "";
?>
										<option value="<?php echo $skins[$i]; ?>"<?=$selected ?>><?php echo $skins[$i]; ?></option>
<?php
								}
								// 끝 => 반복문__돌리기
								//=========================================

?>
								</select>
						</td>
				</tr>

				<tr>
						<th scope="row">최고 레벨</th>
						<td>
								<label for="level_max_n_label" class="sound_only">회원 최고 레벨</label>
								<input type="text" name="level_max_n" value="<?php echo $level_max_n; ?>" id="level_max_n_label" class="frm_input" size="10">
						</td>
				</tr>

				<tr>
						<th scope="row">레벨당 기준 포인트</th>
						<td>
								<label for="point_plus_n_label" class="sound_only">레벨 1단계당 기준 포인트 차이</label>
								<input type="text" name="point_plus_n" value="<?php echo $point_plus_n; ?>" id="point_plus_n_label" class="frm_input" size="10"> 점
								&nbsp; 
								<input type="checkbox" name="reload__point_plus" value="1" id="reload__point_plus_label"<?php echo $reload__point_plus__checked; ?>> 지금 적용
						</td>
				</tr>

				<tr>
						<th scope="row">레벨당 차감 포인트</th>
						<td>
								<label for="point_pay_n_label" class="sound_only">레벨 1단계당 차감하는 포인트 차이</label>
								<input type="text" name="point_pay_n" value="<?php echo $point_pay_n; ?>" id="point_pay_n_label" class="frm_input" size="10"> 점
								&nbsp; 
								<input type="checkbox" name="reload__point_pay" value="1" id="reload__point_pay_label"<?php echo $reload__point_pay__checked; ?>> 지금 적용
						</td>
				</tr>

				<tr>
						<th scope="row">레벨당 가입후 일수</th>
						<td>
								<label for="join_days_n_label" class="sound_only">레벨 1단계당 가입후 경과 일수</label>
								<input type="text" name="join_days_n" value="<?php echo $join_days_n; ?>" id="join_days_n_label" class="frm_input" size="10"> 점
								&nbsp; 
								<input type="checkbox" name="reload__join_days" value="1" id="reload__join_days_label"<?php echo $reload__join_days__checked; ?>> 지금 적용
						</td>
				</tr>

				<tr>
						<th scope="row">레벨 신청일 간격</th>
						<td>
								<label for="level_gap_day_n_label" class="sound_only">신청일 간격 - 몇일에 1회 변경 신청 할수 있는가?</label>
								<input type="text" name="level_gap_day_n" value="<?php echo $level_gap_day_n ?>" id="level_gap_day_n_label" class="frm_input" size="10"> 일에 1회 신청
						</td>
				</tr>

				<tr>
						<th scope="row">레벨 변경 확인 간격</th>
						<td>
								<div style="line-height:2.4em;">
										<label for="level_check_hour_n" class="sound_only">레벨 변경 확인 간격</label>
										<input type="text" name="level_check_hour_n" value="<?php echo $level_check_hour_n; ?>" id="level_check_hour_n" class="frm_input" size="10"> 시간마다 확인<br />
										레벨 자동변경 사용시 몇시간 간격으로 확인할지 입력해 주세요. 숫자로만 입력해 주세요.<br />
										기본값은 1 (1시간) 입니다.<br />
										1을 선택하면 1시간마다 레벨변경 할수 있는지 확인합니다.<br />
										시간 간격을 짧게 입력하면 서버에 부담을 줄수 있고 너무 길게 입력하면 레벨 자동변경이 오랫동안 안될수 있습니다.
								</div>
						</td>
				</tr>

				<tr>
						<th scope="row">신청할수 있는 레벨 단계</th>
						<td>
								<div class="line_h_2_4">
										<input type="radio" name="reqest_page_level_t" id="reqest_page_level_t_1" value="1"<?php  IF ($reqest_page_level_t != 101) echo " checked"; ?>> <label for="reqest_page_level_t_101">다음 레벨로만 변경 신청가기</label><br />
										<input type="radio" name="reqest_page_level_t" id="reqest_page_level_t_101" value="101"<?php  IF ($reqest_page_level_t == 101) echo " checked"; ?>> <label for="reqest_page_level_t_1">단계 제한 없이 레벨 변경 신청하기</label>
								</div>
						</td>
				</tr>

				</tbody>
				</table>
		</div>


		<br />


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 수 정 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 레벨별 정보 수정하기 " onClick="PageUrl('./pi__level.form.php')">
		</div>

		</form>


			<br />
			<br />


			<div class="btn_confirm" style="line-height:2em; padding:10px 0 10px 15px; background:#fff; border:2px solid #c3c6ca;">

					회원 레벨 기능을 사용하시려면 아래와 같이 해 주세요.
					<br />
					. 위 메뉴중에 <span style="color:#4466ff">"피리 PWP"</span> => <span style="color:#4466ff">"피리 테이블 생성"</span> 에서 테이블을 생성해 주세요.
					<br />
					. <span style="color:#4466ff">"PC"</span>와 <span style="color:#4466ff">"모바일"</span>의 스킨을 선택합니다.
					<br />
					. <span style="color:#4466ff">"최고 레벨"</span>은 최고관리자의 레벨을 입력합니다. 보통은 10으로 하며 최대 100으로 하는 사이트도 있습니다.
					<br />
					. <span style="color:#4466ff">"최고 레벨"</span>을 현재 최고관리자의 레벨보다 작게 입력하면 즉시으로 현재 최고관리자의 레벨이 입력됩니다.
					<br />
					. 처음 입력하는 경우에는 <span style="color:#4466ff">"레벨 1단계당 포인트"</span>을 입력해 주세요.
					<br />
					. 예를 들어 <span style="color:#4466ff">"레벨 1단계당 포인트"</span>를 1000으로 하면 레벨1은 1000점, 레벨2은 2000점, 레벨3은 3000점이 됩니다.
					<br />
					. <span style="color:#4466ff">"회원 최고 레벨"</span>을 10 이상으로 하는 경우 그누보드 소스를 수정해야 합니다. 기본 10으로 되어 있기 때문입니다.
					<br />
					. <span style="color:#4466ff">"지금 적용"</span>을 체크하시면 기존에 저장된 정보가 새 입력값으로 바뀌니 신중히 결정후 선택해 주세요.

			</div>

</section>


<script>

function submit__level_helper(gform)
{

		// 

		return true;

}
</script>


<?php

	//=======================================================
	// ADMIN_TAIL__첨부
	include_once ('../admin.tail.php');

?>