<?php

/**
 * ASK Image Box library
 */
if (!defined('_GNUBOARD_')) {
    exit;
}

//상수 선언
define('IB_PATH', G5_PLUGIN_PATH . '/ask-imagebox');
define('IB_URL', G5_PLUGIN_URL . '/ask-imagebox');
define("IB_SAVE_PATH", G5_DATA_PATH . "/editor/{$member['mb_id']}");
define("IB_SAVE_URL", G5_DATA_URL . "/editor/{$member['mb_id']}");


####################
### DB 상수
####################
//이미지 목록 저장
define('IB_TABLE', 'ask_imagebox');


##########################
### 설정
##########################
define('IB_EXT', array('gif', 'jpg', 'webm', 'png', 'jpeg'));
define('IB_THUMB_FORMAT', 'jpg');

//업로드 제한 용량 25MB
define('IB_FILESIZE', 26214400);

//1인당 업로드 전체 용량 500MB (524288000), 설정값 이상 업로드 금지
define('IB_QUOTA', 524288000);

//한번에 올릴 수 있는 파일 개수 
define('IB_FILECOUNT', 20);

//목록에 한번에 보여줄 개수
define('IB_LISTROW', 32);

//EXIF GPS 정보로 지도 출력 - 그누보드 기본환경설정에서 SNS -> kakao api를 설정해야 합니다.
define('IB_GPS', true);

//스크립트용 설정, 참 거짓 값은 ''로 감싸야 합니다.
//debug console 출력 여부, 'true', 'false'
define('IB_DEBUG', 'true');
//업로더 목록에서 삭제
define('IB_DELETE', 'true');
//대용량 업로드
define('IB_BIGFILE', 'true');
//연결해서 업로드
define('IB_RESUME', 'true');
//재시도버튼
define('IB_RETRY', 'true');

//이미지 라이브러리 gd or imagick
define('IB_IMAGE_DRIVER', 'gd');

//썸네일 크기
define('IB_THUMB_W', 640);
define('IB_THUMB_H', 360);
//Map용 썸네일
define('IB_THUMB_MW', 80);
define('IB_THUMB_MH', 60);

//이미지 용량 최적화 - EXIF 정보는 삭제됩니다. true , false
define('IB_OPTIMIZE', true);
//업로드시 이미지 크기 조정 width 값 숫자만 입력 또는 false
define('IB_RESIZE', 1280);












































################################
################################
## imagebox functions 
################################
################################

if (!function_exists('ib_get_ext')) {
    /**
     * 확장자 가져오기
     * @param type $name
     * @return type
     */
    function ib_get_ext($name)
    {
        $pathinfo = pathinfo($name);
        $ext      = isset($pathinfo['extension']) ? $pathinfo['extension'] : '';
        return $ext;
    }
}

if (!function_exists('check_request_method')) {
    /**
     * Request method check
     *
     * @return void
     */
    function check_request_method()
    {
        global $HTTP_RAW_POST_DATA;

        if (isset($HTTP_RAW_POST_DATA)) {
            parse_str($HTTP_RAW_POST_DATA, $_POST);
        }

        if (isset($_POST["_method"]) && $_POST["_method"] != null) {
            return $_POST["_method"];
        }

        return $_SERVER["REQUEST_METHOD"];
    }
}


if (!function_exists('kakao_map_request')) {
    /**
     * 카카오 API
     * @param $path
     * @param $query
     * @param $content_type
     * @return mixed
     * curl -v -X GET "https://dapi.kakao.com/v2/local/geo/coord2address.json?x=127.423084873712&y=37.0789561558879&input_coord=WGS84" -H "Authorization: KakaoAK kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk"
     */
    function kakao_map_request($path, $query, $img_name, $content_type = 'json')
    {
        global $g5, $config, $bo_table, $wr_id;
        if (!$config['cf_kakao_rest_key'] || !$config['cf_kakao_js_apikey']) {
            return false;
        }
        $api_server = 'https://dapi.kakao.com';
        $headers    = array("Authorization: KakaoAK " . $config['cf_kakao_rest_key']);
        $opts       = array(
            CURLOPT_URL            => $api_server . $path . '.' . $content_type . '?' . $query,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSLVERSION     => 1,
            CURLOPT_HEADER         => false,
            CURLOPT_POST           => false,
            CURLOPT_HTTPHEADER     => $headers,
        );

        $curl_session = curl_init();
        curl_setopt_array($curl_session, $opts);
        $return_data = curl_exec($curl_session);

        if (curl_errno($curl_session)) {
            throw new Exception(curl_error($curl_session));
        } else {

            curl_close($curl_session);
            $addr    = json_decode($return_data, true);
            $address = $addr['documents']['0']['address']['address_name'];
            return $address;
        }
    }
}

if (!function_exists('kakao_gps_request')) {
    /**
     * 카카오 API
     * @param $path
     * @param $query
     * @param $content_type
     * @return mixed
     * curl -v -X GET "https://dapi.kakao.com/v2/local/geo/coord2address.json?x=127.423084873712&y=37.0789561558879&input_coord=WGS84" -H "Authorization: KakaoAK kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk"
     */
    function kakao_gps_request($path, $query, $content_type = 'json')
    {
        global $g5, $config, $bo_table, $wr_id;
        if (!$config['cf_kakao_rest_key'] || !$config['cf_kakao_js_apikey']) {
            return false;
        }
        $api_server = 'https://dapi.kakao.com';
        $headers    = array("Authorization: KakaoAK " . $config['cf_kakao_rest_key']);
        $opts       = array(
            CURLOPT_URL            => $api_server . $path . '.' . $content_type . '?' . $query,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSLVERSION     => 1,
            CURLOPT_HEADER         => false,
            CURLOPT_POST           => false,
            CURLOPT_HTTPHEADER     => $headers,
        );

        $curl_session = curl_init();
        curl_setopt_array($curl_session, $opts);
        $return_data = curl_exec($curl_session);

        if (curl_errno($curl_session)) {
            throw new Exception(curl_error($curl_session));
        } else {

            curl_close($curl_session);
            $addr    = json_decode($return_data, true);
            return $addr;
        }
    }
}
if (!function_exists('ib_get_address')) {
    /**
     * 파일 테이블에서 저장된 주소 가져오기
     *
     * @param [type] $filename
     * @return void
     */
    function ib_get_address($filename)
    {
        global $g5, $bo_table, $wr_id;
        $sql = " SELECT bf_address from {$g5['board_file_table']} where bo_table = '{$bo_table}' and wr_id = '{$wr_id}' and bf_file = '{$filename}' ";
        $result = sql_fetch($sql);
        return $result['bf_address'];
    }
}


if (!function_exists('ib_get_exif')) {
    /**
     * @param $image
     * @return mixed
     */
    function ib_get_exif($image)
    {
        global $member;
        if (!function_exists('exif_read_data')) {
            return "exif_read_data Function Not Declared";
        }

        if (!file_exists($image)) {
            return "Image file Not Found";
        }
        $exif = exif_read_data($image, 'IFD0');
        return $exif;
    }
}

if (!function_exists('ib_get_image_location')) {

    /**
     * Exif GPS 
     *
     * @param [type] $exif_info
     * @return void
     */
    function ib_get_image_location($exif_info)
    {
        $info = $exif_info;

        $direction = array('N', 'S', 'E', 'W');
        if (
            isset($info['GPSLatitude'], $info['GPSLongitude'], $info['GPSLatitudeRef'], $info['GPSLongitudeRef']) &&
            in_array($info['GPSLatitudeRef'], $direction) && in_array($info['GPSLongitudeRef'], $direction)
        ) {

            $lat_degrees_a = explode('/', $info['GPSLatitude'][0]);
            $lat_minutes_a = explode('/', $info['GPSLatitude'][1]);
            $lat_seconds_a = explode('/', $info['GPSLatitude'][2]);
            $lng_degrees_a = explode('/', $info['GPSLongitude'][0]);
            $lng_minutes_a = explode('/', $info['GPSLongitude'][1]);
            $lng_seconds_a = explode('/', $info['GPSLongitude'][2]);

            $lat_degrees = $lat_degrees_a[0] / $lat_degrees_a[1];
            $lat_minutes = $lat_minutes_a[0] / $lat_minutes_a[1];
            $lat_seconds = $lat_seconds_a[0] / $lat_seconds_a[1];
            $lng_degrees = $lng_degrees_a[0] / $lng_degrees_a[1];
            $lng_minutes = $lng_minutes_a[0] / $lng_minutes_a[1];
            $lng_seconds = $lng_seconds_a[0] / $lng_seconds_a[1];

            $lat = (float) $lat_degrees + ((($lat_minutes * 60) + ($lat_seconds)) / 3600);
            $lng = (float) $lng_degrees + ((($lng_minutes * 60) + ($lng_seconds)) / 3600);
            $lat = number_format($lat, 7);
            $lng = number_format($lng, 7);

            //If the latitude is South, make it negative.
            //If the longitude is west, make it negative
            $lat = $info['GPSLatitudeRef'] == 'S' ? $lat * -1 : $lat;
            $lng = $info['GPSLongitudeRef'] == 'W' ? $lng * -1 : $lng;

            return array(
                'Latitude'  => $lat,
                'Longitude' => $lng,
            );
        }

        return false;
    }
}

/**
 * 이미지 방향수정
 */
class IB_ImageOrientationFix
{
    private $image;
    private $filePathOutput;
    private $resourceImage;
    private $resourceImageFixed;

    public function __construct($filePathInput, $filePathOutput = false)
    {
        if (!function_exists('imageflip')) {
            //only php < 5.5
            if (!defined('IMG_FLIP_HORIZONTAL')) {
                define('IMG_FLIP_HORIZONTAL', 1);
            }
            if (!defined('IMG_FLIP_VERTICAL')) {
                define('IMG_FLIP_VERTICAL', 2);
            }
            if (!defined('IMG_FLIP_BOTH')) {
                define('IMG_FLIP_BOTH', 3);
            }
        }

        try {
            $this->image = new Image($filePathInput);
            $this->setFilePathOutput($filePathOutput);
        } catch (Exception $e) {
            exit;
        }
    }

    /**
     * Function manager to fix orientation image
     * @return bool
     * @throws Exception
     */
    public function fix()
    {
        try {

            // If we don't get any exif data at all, then we may as well stop now
            if (!$this->image->getExifData()) {
                return false;
            }

            // do nothing if orientation cannot be determined
            if (null === $this->image->getOrientation()) {
                return false;
            }

            // correct orientation
            if (1 === $this->image->getOrientation()) {
                return true;
            }

            // Set the GD image resource for loaded image
            $this->setResourceImage();
            // If it failed to load a resource, give up
            if (null === $this->getResourceImage()) {
                throw new Exception('Unable load resource image');
            }

            // Set the GD image resource fixed
            $this->setResourceImageFixed();
            if (null === $this->getResourceImageFixed()) {
                throw new Exception('Unable fix image');
            }

            // Save the image fixed
            return $this->saveFix();
        } catch (Exception $e) {
            throw $e;
        }
    }

    /**
     * Set the GD image resource for loaded image
     */
    private function setResourceImage()
    {
        $this->resourceImage = null;
        switch ($this->image->getExtension()) {
            case 'png':
                $this->resourceImage = imagecreatefrompng($this->image->getFilePathInput());
                break;
            case 'jpg':
            case 'jpeg':
                $this->resourceImage = imagecreatefromjpeg($this->image->getFilePathInput());
                break;
            case 'gif':
                $this->resourceImage = imagecreatefromgif($this->image->getFilePathInput());
                break;
        }
    }

    /**
     * @return mixed
     */
    public function getResourceImage()
    {
        return $this->resourceImage;
    }

    /**
     * Set the resource image fixed
     */
    private function setResourceImageFixed()
    {
        $this->resourceImageFixed = null;
        switch ($this->image->getOrientation()) {
                // horizontal flip
            case 2:
                $this->resourceImageFixed = $this->executeImageFlip($this->getResourceImage(), IMG_FLIP_HORIZONTAL);
                break;

                // 180 rotate left
            case 3:
                $this->resourceImageFixed = imagerotate($this->getResourceImage(), 180, 0);
                break;

                // vertical flip
            case 4:
                $this->resourceImageFixed = $this->executeImageFlip($this->getResourceImage(), IMG_FLIP_VERTICAL);
                break;

                // vertical flip + 90 rotate right
            case 5:
                $this->resourceImageFixed = $this->executeImageFlip($this->getResourceImage(), IMG_FLIP_VERTICAL);
                $this->resourceImageFixed = imagerotate($this->resourceImageFixed, -90, 0);
                break;

                // 90 rotate right
            case 6:
                $this->resourceImageFixed = imagerotate($this->getResourceImage(), -90, 0);
                break;

                // horizontal flip + 90 rotate right
            case 7:
                $this->resourceImageFixed = $this->executeImageFlip($this->getResourceImage(), IMG_FLIP_HORIZONTAL);
                $this->resourceImageFixed = imagerotate($this->resourceImageFixed, -90, 0);
                break;

                // 90 rotate left
            case 8:
                $this->resourceImageFixed = imagerotate($this->getResourceImage(), 90, 0);
                break;
        }
    }

    /**
     * @return mixed
     */
    public function getResourceImageFixed()
    {
        return $this->resourceImageFixed;
    }

    /**
     * @param $resourceImage
     * @param int $mode - possible parameters: IMG_FLIP_HORIZONTAL || IMG_FLIP_VERTICAL || IMG_FLIP_BOTH
     * @return resource
     * @throws Exception
     */
    private function executeImageFlip($resourceImage, $mode)
    {
        if (function_exists('imageflip')) {
            //only php >= 5.5
            imageflip($resourceImage, $mode);
        } else {
            if ($mode == IMG_FLIP_VERTICAL || $mode == IMG_FLIP_BOTH) {
                $resourceImage = $this->flipVertical($resourceImage);
            }
            if ($mode == IMG_FLIP_HORIZONTAL || $mode == IMG_FLIP_BOTH) {
                $resourceImage = $this->flipHorizontal($resourceImage);
            }
        }

        return $resourceImage;
    }

    /**
     * Flip vertical
     * @param $resourceImage
     * @return resource
     * @throws Exception
     */
    private function flipVertical($resourceImage)
    {
        $size_x = imagesx($resourceImage);
        $size_y = imagesy($resourceImage);
        $temp = imagecreatetruecolor($size_x, $size_y);
        $x = imagecopyresampled($temp, $resourceImage, 0, 0, 0, ($size_y - 1), $size_x, $size_y, $size_x, 0 - $size_y);
        if (!$x) {
            throw new Exception('Unable to flip vertical image');
        }

        return $temp;
    }

    /**
     * Flip horizontal
     * @param $resourceImage
     * @return resource
     * @throws Exception
     */
    private function flipHorizontal($resourceImage)
    {
        $size_x = imagesx($resourceImage);
        $size_y = imagesy($resourceImage);
        $temp = imagecreatetruecolor($size_x, $size_y);
        $x = imagecopyresampled($temp, $resourceImage, 0, 0, ($size_x - 1), 0, $size_x, $size_y, 0 - $size_x, $size_y);
        if (!$x) {
            throw new Exception('Unable to flip horizontal image');
        }

        return $temp;
    }

    /**
     * Save the new image fixed
     * @return bool
     */
    private function saveFix()
    {
        //if isset file path output the location is file path output otherwise override exist file
        $location = $this->getFilePathOutput() ? $this->getFilePathOutput() : $this->image->getFilePathInput();

        $success = false;
        switch ($this->image->getExtension()) {
            case 'png':
                $success = imagepng($this->getResourceImageFixed(), $location);
                break;
            case 'jpg':
            case 'jpeg':
                $success = imagejpeg($this->getResourceImageFixed(), $location);
                break;
            case 'gif':
                $success = imagegif($this->getResourceImageFixed(), $location);
                break;
        }

        return $success;
    }

    /**
     * @param $filePathOutput
     * @throws Exception
     */
    public function setFilePathOutput($filePathOutput = false)
    {
        $this->filePathOutput = $filePathOutput;
    }

    /**
     * @return mixed
     */
    public function getFilePathOutput()
    {
        return $this->filePathOutput;
    }
}
if (!function_exists('ib_thumbnail')) {
    /**
     * 썸네일 생성
     *
     * @param [type] $filename
     * @param [type] $source_path
     * @param [type] $target_path
     * @param [type] $thumb_width
     * @param [type] $thumb_height
     * @param [type] $is_create
     * @param boolean $is_crop
     * @param string $crop_mode
     * @param boolean $is_sharpen
     * @param string $um_value
     * @return void
     */
    function ib_thumbnail($filename, $source_path, $target_path, $thumb_width, $thumb_height, $is_create, $is_crop = false, $crop_mode = 'center', $is_sharpen = false, $um_value = '80/0.5/3')
    {
        global $g5;

        if (!$thumb_width && !$thumb_height)
            return;

        $source_file = "$source_path/$filename";

        if (!is_file($source_file)) // 원본 파일이 없다면
            return;

        $size = @getimagesize($source_file);
        if ($size[2] < 1 || $size[2] > 3) // gif, jpg, png 에 대해서만 적용
            return;

        if (!is_dir($target_path)) {
            @mkdir($target_path, G5_DIR_PERMISSION);
            @chmod($target_path, G5_DIR_PERMISSION);
        }

        // 디렉토리가 존재하지 않거나 쓰기 권한이 없으면 썸네일 생성하지 않음
        if (!(is_dir($target_path) && is_writable($target_path)))
            return '';

        // Animated GIF는 썸네일 생성하지 않음
        if ($size[2] == 1) {
            if (is_animated_gif($source_file))
                return basename($source_file);
        }

        $ext = array(1 => 'gif', 2 => 'jpg', 3 => 'png');

        $thumb_filename = preg_replace("/\.[^\.]+$/i", "", $filename); // 확장자제거
        $thumb_file = "{$target_path}/thumb-{$thumb_filename}." . $ext[$size[2]];

        $thumb_time = @filemtime($thumb_file);
        $source_time = @filemtime($source_file);

        if (file_exists($thumb_file)) {
            if ($is_create == false && $source_time < $thumb_time) {
                return basename($thumb_file);
            }
        }

        // 원본파일의 GD 이미지 생성
        $src = null;
        $degree = 0;

        if ($size[2] == 1) {
            $src = @imagecreatefromgif($source_file);
            $src_transparency = @imagecolortransparent($src);
        } else if ($size[2] == 2) {
            $src = @imagecreatefromjpeg($source_file);

            if (function_exists('exif_read_data')) {
                // exif 정보를 기준으로 회전각도 구함
                $exif = @exif_read_data($source_file);
                if (!empty($exif['Orientation'])) {
                    switch ($exif['Orientation']) {
                        case 8:
                            $degree = 90;
                            break;
                        case 3:
                            $degree = 180;
                            break;
                        case 6:
                            $degree = -90;
                            break;
                    }

                    // 회전각도 있으면 이미지 회전
                    if ($degree) {
                        $src = imagerotate($src, $degree, 0);

                        // 세로사진의 경우 가로, 세로 값 바꿈
                        if ($degree == 90 || $degree == -90) {
                            $tmp = $size;
                            $size[0] = $tmp[1];
                            $size[1] = $tmp[0];
                        }
                    }
                }
            }
        } else if ($size[2] == 3) {
            $src = @imagecreatefrompng($source_file);
            @imagealphablending($src, true);
        } else {
            return;
        }

        if (!$src)
            return;

        $is_large = true;
        // width, height 설정

        if ($thumb_width) {
            if (!$thumb_height) {
                $thumb_height = round(($thumb_width * $size[1]) / $size[0]);
            } else {
                if ($crop_mode === 'center' && ($size[0] > $thumb_width || $size[1] > $thumb_height)) {
                    $is_large = true;
                } else if ($size[0] < $thumb_width || $size[1] < $thumb_height) {
                    $is_large = false;
                }
            }
        } else {
            if ($thumb_height) {
                $thumb_width = round(($thumb_height * $size[0]) / $size[1]);
            }
        }

        $dst_x = 0;
        $dst_y = 0;
        $src_x = 0;
        $src_y = 0;
        $dst_w = $thumb_width;
        $dst_h = $thumb_height;
        $src_w = $size[0];
        $src_h = $size[1];

        $ratio = $dst_h / $dst_w;

        if ($is_large) {
            // 크롭처리
            if ($is_crop) {
                switch ($crop_mode) {
                    case 'center':
                        if ($size[1] / $size[0] >= $ratio) {
                            $src_h = round($src_w * $ratio);
                            $src_y = round(($size[1] - $src_h) / 2);
                        } else {
                            $src_w = round($size[1] / $ratio);
                            $src_x = round(($size[0] - $src_w) / 2);
                        }
                        break;
                    default:
                        if ($size[1] / $size[0] >= $ratio) {
                            $src_h = round($src_w * $ratio);
                        } else {
                            $src_w = round($size[1] / $ratio);
                        }
                        break;
                }

                $dst = imagecreatetruecolor($dst_w, $dst_h);

                if ($size[2] == 3) {
                    imagealphablending($dst, false);
                    imagesavealpha($dst, true);
                } else if ($size[2] == 1) {
                    $palletsize = imagecolorstotal($src);
                    if ($src_transparency >= 0 && $src_transparency < $palletsize) {
                        $transparent_color   = imagecolorsforindex($src, $src_transparency);
                        $current_transparent = imagecolorallocate($dst, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
                        imagefill($dst, 0, 0, $current_transparent);
                        imagecolortransparent($dst, $current_transparent);
                    }
                }
            } else { // 비율에 맞게 생성
                $dst = imagecreatetruecolor($dst_w, $dst_h);
                $bgcolor = imagecolorallocate($dst, 255, 255, 255); // 배경색

                if (!((defined('G5_USE_THUMB_RATIO') && false === G5_USE_THUMB_RATIO) || (defined('G5_THEME_USE_THUMB_RATIO') && false === G5_THEME_USE_THUMB_RATIO))) {
                    if ($src_w > $src_h) {
                        $tmp_h = round(($dst_w * $src_h) / $src_w);
                        $dst_y = round(($dst_h - $tmp_h) / 2);
                        $dst_h = $tmp_h;
                    } else {
                        $tmp_w = round(($dst_h * $src_w) / $src_h);
                        $dst_x = round(($dst_w - $tmp_w) / 2);
                        $dst_w = $tmp_w;
                    }
                }

                if ($size[2] == 3) {
                    $bgcolor = imagecolorallocatealpha($dst, 0, 0, 0, 127);
                    imagefill($dst, 0, 0, $bgcolor);
                    imagealphablending($dst, false);
                    imagesavealpha($dst, true);
                } else if ($size[2] == 1) {
                    $palletsize = imagecolorstotal($src);
                    if ($src_transparency >= 0 && $src_transparency < $palletsize) {
                        $transparent_color   = imagecolorsforindex($src, $src_transparency);
                        $current_transparent = imagecolorallocate($dst, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
                        imagefill($dst, 0, 0, $current_transparent);
                        imagecolortransparent($dst, $current_transparent);
                    } else {
                        imagefill($dst, 0, 0, $bgcolor);
                    }
                } else {
                    imagefill($dst, 0, 0, $bgcolor);
                }
            }
        } else {
            $dst = imagecreatetruecolor($dst_w, $dst_h);
            $bgcolor = imagecolorallocate($dst, 255, 255, 255); // 배경색

            if (((defined('G5_USE_THUMB_RATIO') && false === G5_USE_THUMB_RATIO) || (defined('G5_THEME_USE_THUMB_RATIO') && false === G5_THEME_USE_THUMB_RATIO))) {
                //이미지 썸네일을 비율 유지하지 않습니다.  (5.2.6 버전 이하에서 처리된 부분과 같음)

                if ($src_w < $dst_w) {
                    if ($src_h >= $dst_h) {
                        $dst_x = round(($dst_w - $src_w) / 2);
                        $src_h = $dst_h;
                        if ($dst_w > $src_w) {
                            $dst_w = $src_w;
                        }
                    } else {
                        $dst_x = round(($dst_w - $src_w) / 2);
                        $dst_y = round(($dst_h - $src_h) / 2);
                        $dst_w = $src_w;
                        $dst_h = $src_h;
                    }
                } else {
                    if ($src_h < $dst_h) {
                        $dst_y = round(($dst_h - $src_h) / 2);
                        $dst_h = $src_h;
                        $src_w = $dst_w;
                    }
                }
            } else {
                //이미지 썸네일을 비율 유지하며 썸네일 생성합니다.
                if ($src_w < $dst_w) {
                    if ($src_h >= $dst_h) {
                        if ($src_h > $src_w) {
                            $tmp_w = round(($dst_h * $src_w) / $src_h);
                            $dst_x = round(($dst_w - $tmp_w) / 2);
                            $dst_w = $tmp_w;
                        } else {
                            $dst_x = round(($dst_w - $src_w) / 2);
                            $src_h = $dst_h;
                            if ($dst_w > $src_w) {
                                $dst_w = $src_w;
                            }
                        }
                    } else {
                        $dst_x = round(($dst_w - $src_w) / 2);
                        $dst_y = round(($dst_h - $src_h) / 2);
                        $dst_w = $src_w;
                        $dst_h = $src_h;
                    }
                } else {
                    if ($src_h < $dst_h) {
                        if ($src_w > $dst_w) {
                            $tmp_h = round(($dst_w * $src_h) / $src_w);
                            $dst_y = round(($dst_h - $tmp_h) / 2);
                            $dst_h = $tmp_h;
                        } else {
                            $dst_y = round(($dst_h - $src_h) / 2);
                            $dst_h = $src_h;
                            $src_w = $dst_w;
                        }
                    }
                }
            }

            if ($size[2] == 3) {
                $bgcolor = imagecolorallocatealpha($dst, 0, 0, 0, 127);
                imagefill($dst, 0, 0, $bgcolor);
                imagealphablending($dst, false);
                imagesavealpha($dst, true);
            } else if ($size[2] == 1) {
                $palletsize = imagecolorstotal($src);
                if ($src_transparency >= 0 && $src_transparency < $palletsize) {
                    $transparent_color   = imagecolorsforindex($src, $src_transparency);
                    $current_transparent = imagecolorallocate($dst, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
                    imagefill($dst, 0, 0, $current_transparent);
                    imagecolortransparent($dst, $current_transparent);
                } else {
                    imagefill($dst, 0, 0, $bgcolor);
                }
            } else {
                imagefill($dst, 0, 0, $bgcolor);
            }
        }

        imagecopyresampled($dst, $src, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h);

        // sharpen 적용
        if ($is_sharpen && $is_large) {
            $val = explode('/', $um_value);
            UnsharpMask($dst, $val[0], $val[1], $val[2]);
        }

        if ($size[2] == 1) {
            imagegif($dst, $thumb_file);
        } else if ($size[2] == 3) {
            if (!defined('G5_THUMB_PNG_COMPRESS'))
                $png_compress = 5;
            else
                $png_compress = G5_THUMB_PNG_COMPRESS;

            imagepng($dst, $thumb_file, $png_compress);
        } else {
            if (!defined('G5_THUMB_JPG_QUALITY'))
                $jpg_quality = 90;
            else
                $jpg_quality = G5_THUMB_JPG_QUALITY;

            imagejpeg($dst, $thumb_file, $jpg_quality);
        }

        chmod($thumb_file, G5_FILE_PERMISSION); // 추후 삭제를 위하여 파일모드 변경

        imagedestroy($src);
        imagedestroy($dst);

        return basename($thumb_file);
    }
}

if (!function_exists('ib_get_paging')) {
    /**
     * 페이징
     *
     * @param [type] $write_pages
     * @param [type] $cur_page
     * @param [type] $total_page
     * @param [type] $url
     * @param string $add
     * @return void
     */
    function ib_get_paging($write_pages, $cur_page, $total_page, $url, $add = "")
    {
        //$url = preg_replace('#&amp;page=[0-9]*(&amp;page=)$#', '$1', $url);
        $url = preg_replace('#(&amp;)?page=[0-9]*#', '', $url);
        $url .= substr($url, -1) === '?' ? 'page=' : '&amp;page=';

        $str = '';
        if ($cur_page > 1) {
            $str .= '<li class="page-item"><a href="' . $url . '1' . $add . '" class="pg_page pg_start page-link">처음</a></li>' . PHP_EOL;
        }

        $start_page = (((int)(($cur_page - 1) / $write_pages)) * $write_pages) + 1;
        $end_page = $start_page + $write_pages - 1;

        if ($end_page >= $total_page) $end_page = $total_page;

        if ($start_page > 1) $str .= '<li class="page-item"><a href="' . $url . ($start_page - 1) . $add . '" class="page-link pg_page pg_prev">이전</a></li>' . PHP_EOL;

        if ($total_page > 1) {
            for ($k = $start_page; $k <= $end_page; $k++) {
                if ($cur_page != $k)
                    $str .= '<li class="page-item"><a href="' . $url . $k . $add . '" class="pg_page page-link">' . $k . '<span class="sr-only">페이지</span></a></li>' . PHP_EOL;
                else
                    $str .= '<li class="page-item active"><span class="sr-only">열린</span><strong class="pg_current page-link">' . $k . '</strong><span class="sr-only">페이지</span></li>' . PHP_EOL;
            }
        }

        if ($total_page > $end_page) $str .= '<li class="page-item"><a href="' . $url . ($end_page + 1) . $add . '" class="pg_page pg_next page-link">다음</a></li>' . PHP_EOL;

        if ($cur_page < $total_page) {
            $str .= '<li class="page-item"><a href="' . $url . $total_page . $add . '" class="pg_page pg_end page-link">맨끝</a></li>' . PHP_EOL;
        }

        if ($str)
            return "<nav aria-label='Page navigation'><ul class='pagination justify-content-center'>{$str}</ul></nav>";
        else
            return "";
    }
}

if (!function_exists('ib_foldersize')) {
    /**
     * 폴더 사이즈 체크
     *
     * @param [type] $dir
     * @return void
     */
    function ib_foldersize($dir)
    {
        $size = 0;
        clearstatcache();
        foreach (glob(rtrim($dir, '/') . '/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : ib_foldersize($each);
        }

        return (float) $size;
    }
}
