<?php
include_once "./_common.php";
/**
 * Image Box 
 * 불법복제를 금지합니다.
 */
//권한 체크
if (!$is_member) {
    alert_close('회원만 이용가능합니다. 로그인 후 이용하세요.');
    exit;
}
//install 체크
$ib_table = sql_fetch("SHOW tables like '" . IB_TABLE . "'");
if (!$ib_table) {
    alert('설치 후 이용하세요.', './install.php');
}
include_once "./_head.php";


$sql_common = " from `" . IB_TABLE . "` ";

$sql_search = "";

if ($config['cf_kakao_rest_key'] && $config['cf_kakao_js_apikey']) {
    if ($stx) {
        $sql_search = " where `ib_address` like '%{$stx}%' or `ib_tag` like '%{$stx}%'";
    }
} else {
    if ($stx) {
        $sql_search = " where `ib_tag` like '%{$stx}%'";
    }
}
if ($is_admin != 'super')
    $sql_search .= " and mb_level <= '{$member['mb_level']}' ";

if (!$sst) {
    $sst = "exif_datetime";
    $sod = "desc";
}

$sql_order = " order by {$sst} {$sod} ";

$sql = " SELECT count(*) as cnt {$sql_common} {$sql_search} {$sql_order} ";
$row = sql_fetch($sql);
$total_count = $row['cnt'];

$rows = IB_LISTROW;
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
if ($page < 1) $page = 1; // 페이지가 없으면 첫 페이지 (1 페이지)
$from_record = ($page - 1) * $rows; // 시작 열을 구함

$sql = " SELECT * {$sql_common} {$sql_search} {$sql_order} limit {$from_record}, {$rows} ";
$result = sql_query($sql);
?>
<?php if ($config['cf_kakao_rest_key'] && $config['cf_kakao_js_apikey']) { ?>
    <script type="text/javascript" src="//dapi.kakao.com/v2/maps/sdk.js?appkey=<?php echo $config['cf_kakao_js_apikey'] ?>"></script>
<?php } ?>
<script>
    function map_maker(id, lat, long, thumb_url) {
        console.log(thumb_url);
        var mapContainer = document.getElementById(id), // 지도를 표시할 div 
            mapOption = {
                center: new kakao.maps.LatLng(lat, long), // 지도의 중심좌표
                level: 4 // 지도의 확대 레벨
            };

        var map = new kakao.maps.Map(mapContainer, mapOption); // 지도를 생성합니다

        var imageSrc = thumb_url, // 마커이미지의 주소입니다    
            imageSize = new kakao.maps.Size(40, 30), // 마커이미지의 크기입니다
            imageOption = {
                offset: new kakao.maps.Point(0, 0)
            }; // 마커이미지의 옵션입니다. 마커의 좌표와 일치시킬 이미지 안에서의 좌표를 설정합니다.

        // 마커의 이미지정보를 가지고 있는 마커이미지를 생성합니다
        var markerImage = new kakao.maps.MarkerImage(imageSrc, imageSize, imageOption),
            markerPosition = new kakao.maps.LatLng(lat, long); // 마커가 표시될 위치입니다

        // 마커를 생성합니다
        var marker = new kakao.maps.Marker({
            position: markerPosition,
            image: markerImage // 마커이미지 설정 
        });

        // 마커가 지도 위에 표시되도록 설정합니다
        marker.setMap(map);
    }
</script>
<div class='container'>
    <div class='row'>
        <div class='col'>
            <div class='alert alert-danger mt-2'>
                <i class="fa fa-info-circle" aria-hidden="true"></i> 주의) 게시물에 등록한 사진을 이미지박스에서 삭제시 게시물 사진은 출력이 되지 않고 x 표시 됩니다.
            </div>
            <div class='imagebox-wrap mt-1 mb-5'>
                <?php
                //폴더 권한 체크
                $chunk_path = G5_PLUGIN_PATH . '/ask-imagebox/uploader/server/chunks';
                if (!is_writable($chunk_path)) {
                    echo "<div class='alert alert-info'>{$chunk_path} 디렉토리 퍼미션을 777 또는 707로 변경후 사용 하세요.</div>";
                }
                ?>
                <form name="imagelist_form" id="imagelist_form" action="#" onsubmit="return imagelist_form_submit(this);" method="post">
                    <input type='hidden' name='backurl' value="<?php echo $_SERVER['QUERY_STRING'] ?>" />
                    <div class="btn-toolbar mb-2 me-auto d-flex" role="toolbar" aria-label="버튼 툴바">
                        <div class="btn-group btn-group-sm me-2" role="group" aria-label="First group">
                            <input type="checkbox" class="btn-check" id="allcheck" onclick="if (this.checked) all_checked(true); else all_checked(false);" class="selec_chk">
                            <label class="btn btn-primary" for="allcheck"><i class="fa fa-check" aria-hidden="true"></i> 전체선택</label>
                            <button type="submit" class="btn btn-danger" onclick="document.pressed=this.title" title='선택삭제'><i class="fa fa-trash" aria-hidden="true"></i> 선택삭제</button>
                            <?php if ($bo_table) { ?>
                                <button type="submit" class="btn btn-primary" onclick="document.pressed=this.title" title='선택삽입'><i class="fa fa-hand-o-up" aria-hidden="true"></i> 선택삽입</button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class='file-info d-flex justify-content-end'>
                        <?php echo $total_count ?>개, 총용량 <?php echo round((float) ib_foldersize(G5_DATA_PATH . "/editor/{$member['mb_id']}") / 1000 / 1000, 2); ?>MB
                    </div>
                    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-4 g-4">
                        <?php for ($i = 0; $img = sql_fetch_array($result); $i++) { ?>
                            <div class="col">
                                <div class="card h-100">
                                    <div class='overflow-hidden position-relative'>
                                        <div class='icon-list'>
                                            <?php if ($img['exif_longitude'] && $img['exif_latitude']) { ?>
                                                <i class="fa fa-map-marker fa-2x" aria-hidden="true"></i>
                                            <?php } ?>
                                        </div>
                                        <div data-bs-toggle="modal" data-bs-target="#view_modal<?php echo $i ?>" class='card-img-wrap ratio ratio-4x3' style="background-image: url(<?php echo G5_DATA_URL . "/editor/{$member['mb_id']}/thmb-" . $img['ib_filename'] ?>)"></div>
                                    </div>
                                    <!-- 상세보기 Modal -->
                                    <div class="modal fade" id="view_modal<?php echo $i ?>" tabindex="-1" aria-labelledby="modal_label" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modal_label">상세보기</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <!-- 원본이미지 -->
                                                    <div class='org-image-wrap'></div>
                                                    <?php if ((defined('IB_GPS') && IB_GPS == true) && ($img['exif_longitude'] && $img['exif_latitude'])) { ?>
                                                        <!-- GPS 정보 및 KAKAO API 설정시 지도 출력 -->
                                                        <div class='map-wrap mt-2' id='mapDisplay<?php echo $i ?>'></div>
                                                    <?php } ?>
                                                    <!-- EXIF 정보 출력 -->
                                                    <table class='table table-bordered mt-2'>
                                                        <caption>EXIF 정보</caption>
                                                        <tbody>
                                                            <tr>
                                                                <th>카메라</th>
                                                                <td><?php echo $img['exif_camera'] ?></td>
                                                                <th>크기</th>
                                                                <td><?php echo round($img['ib_size'] / 1000 / 1000, 2) ?>MB</td>
                                                            </tr>
                                                            <tr>
                                                                <th>날짜</th>
                                                                <td><?php echo $img['exif_datetime'] ?></td>
                                                                <th>해상도</th>
                                                                <td><?php echo $img['exif_width'] . ' * ' . $img['exif_height']; ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>조리개</th>
                                                                <td><?php echo $img['exif_aperturefnumber'] ?></td>
                                                                <th>플래시</th>
                                                                <td><?php echo $img['exif_flash'] ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>화이트밸런스</th>
                                                                <td><?php echo $img['exif_wihtebalance'] ?></td>
                                                                <th>ISO</th>
                                                                <td><?php echo $img['exif_iso'] ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>초점거리</th>
                                                                <td><?php echo $img['exif_focallength'] ?></td>
                                                                <th>노출시간</th>
                                                                <td><?php echo $img['exif_exposuretime'] ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>주소</th>
                                                                <td><?php echo $img['ib_address'] ?><?php echo $img['exif_latitude'] != '' ? " <a href='https://map.kakao.com/link/map/{$img['exif_latitude']},{$img['exif_longitude']}' target='_blank'><i class='fa fa-map-o' aria-hidden='true'></i></a>" : "없음"; ?></td>
                                                                <th>원본보기</th>
                                                                <td><?php echo "<a href='" . G5_DATA_URL . "/editor/{$member['mb_id']}/{$img['ib_filename']}' target='_blank'>{$img['ib_filename']}</a>" ?></td>
                                                            </tr>

                                                        </tbody>
                                                    </table>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">닫기</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <script>
                                        //map 출력
                                        var modal_req = document.getElementById('view_modal<?php echo $i ?>')
                                        modal_req.addEventListener('show.bs.modal', function(event) {
                                            $('#view_modal<?php echo $i ?> .modal-body .org-image-wrap').html("<img src='<?php echo G5_DATA_URL . "/editor/{$member['mb_id']}/" . $img['ib_filename'] ?>' class='org-image'>");
                                            <?php if (($img['exif_longitude'] && $img['exif_latitude']) && ($config['cf_kakao_rest_key'] && $config['cf_kakao_js_apikey'])) { ?>
                                                setTimeout(function() {
                                                    map_maker('mapDisplay<?php echo $i ?>', '<?php echo $img['exif_latitude'] ?>', '<?php echo $img['exif_longitude'] ?>', '<?php echo G5_DATA_URL . "/editor/{$member['mb_id']}/thmb-map-{$img['ib_filename']}"; ?>');
                                                }, 500);
                                            <?php } ?>
                                        });
                                    </script>
                                    <div class="card-body">
                                        <h5 class="card-title">
                                            <span data-activator="#edit-cp-short-name<?php echo $i ?>" data-input-class="form-control-inplace" data-attribute='tagname' data-url='./inplace.php?ib_idx=<?php echo $img['ib_idx'] ?>' class='cp-short-name editable'>
                                                <?php echo $img['ib_tag'] != '' ? $img['ib_tag'] : "Tag 없음" ?>
                                            </span>
                                            <span id="edit-cp-short-name<?php echo $i ?>" class="cursor-pointer"><i class="fa fa-pencil" aria-hidden="true"></i></span>
                                        </h5>
                                        <div class="card-text">
                                            <ul class='list-group'>
                                                <li class='list-group-item border-0 p-1'><?php echo $img['exif_datetime'] ?></li>
                                                <li class='list-group-item border-0 p-1'><?php echo $img['ib_address'] ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="card-footer d-flex">
                                        <div class="me-auto">
                                            <input type="checkbox" name='select_item[]' value="<?php echo $img['ib_idx'] ?>" data-image='<?php echo $img['ib_filename'] ?>' data-tag='<?php echo $img['ib_tag'] ?>' class="btn-check" id="btn_check_<?php echo $i ?>" autocomplete="off">
                                            <label class="btn btn-outline-primary btn-sm" for="btn_check_<?php echo $i ?>"><i class="fa fa-check" aria-hidden="true"></i> <span class='d-inline d-md-none d-lg-none d-xxl-inline'>선택</span></label>
                                        </div>
                                        <div class="ms-auto">
                                            <?php if ($bo_table) { ?>
                                                <button type="button" class="btn btn-outline-primary btn-sm insert-editor" data-image='<?php echo $img['ib_filename'] ?>' data-tag='<?php echo $img['ib_tag'] ?>'><i class="fa fa-hand-o-up" aria-hidden="true"></i> <span class='d-inline d-md-none d-lg-none d-xxl-inline'>삽입</span></button>
                                            <?php } ?>
                                            <button type='button' class="btn btn-outline-secondary btn-sm copy-btn" data-clipboard-text="<p><img src='<?php echo G5_DATA_URL . "/editor/{$member['mb_id']}/{$img['ib_filename']}"; ?>' alt='<?php echo $img['ib_tag'] ?>' /></p>"><i class="fa fa-clone" aria-hidden="true"></i> <span class='copy-text d-inline d-md-none d-lg-none d-xxl-inline'>Copy</span></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </form>

                <?php if ($total_count == 0) { ?>
                    <div class='alert alert-info mt-5 mb-5'>
                        <h4><i class="fa fa-info-circle" aria-hidden="true"></i> 등록된 사진이 없습니다.</h4>
                        <hr />
                        <a href='./imagebox_uploader.php?<?php echo $_SERVER['QUERY_STRING'] ?>'>사진을 등록</a> 후 이용하세요.
                    </div>
                <?php } ?>

            </div>
            <?php echo ib_get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, '?' . 'bo_table=' . $bo_table . '&amp;page='); ?>
        </div>
    </div>
</div>
<script>
    var clipboard = new ClipboardJS('.copy-btn');
    $('.copy-btn').click(function() {
        var thisItem = $(this);
        thisItem.find('.fa').removeClass('fa-clone');
        thisItem.find('.fa').addClass('fa-check');
        thisItem.find('.copy-text').text('Copied!');
        setTimeout(function() {
            thisItem.find('.fa').removeClass('fa-check');
            thisItem.find('.fa').addClass('fa-clone');
            thisItem.find('.copy-text').text('Copy');
        }, 2000);
    });
    clipboard.on('success', function(e) {
        //console.log(e);
    });

    clipboard.on('error', function(e) {
        //console.log(e);
    });
    //처리
    function imagelist_form_submit(f) {
        var chk_count = 0;

        for (var i = 0; i < f.length; i++) {
            if (f.elements[i].name == "select_item[]" && f.elements[i].checked) {
                chk_count++;
            }
        }

        if (!chk_count) {
            alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
            return false;
        }

        if (document.pressed == "선택삽입") {
            //게시판에 삽입 처리하기
            var item = $('input[name="select_item[]"]:checked');
            $.each(item, function(i, val) {
                var img = "\n<p><img src='<?php echo G5_DATA_URL . "/editor/{$member['mb_id']}/" ?>" + $(val).data('image') + "' class='img-imagebox' alt='" + $(val).data('tag') + "'/></p>\n";
                <?php if (
                    ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == 'cheditor5') ||
                    ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == '' && $config['cf_editor'] == 'cheditor5')
                ) { ?>
                    //Cheditor5
                    var org_content = opener.ed_wr_content.getContents();
                    opener.ed_wr_content.putContents(org_content + img + '\n');
                <?php } ?>

                <?php if (
                    ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == 'smarteditor2') ||
                    ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == '' && $config['cf_editor'] == 'smarteditor2')
                ) { ?>
                    //네이버 스마트 에디터
                    opener.oEditors.getById["wr_content"].exec("PASTE_HTML", [img]);
                <?php } ?>

                <?php if (
                    ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == 'tinymce') ||
                    ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == '' && $config['cf_editor'] == 'tinymce')
                ) { ?>
                    //Tinymce
                    opener.tinymce.get('wr_content').insertContent(img + '\n');
                <?php } ?>

                <?php if (!$board['bo_use_dhtml_editor']) { ?>
                    //textarea
                    var org_content = $('textarea[name=wr_content]', opener.document).val();
                    $('textarea[name=wr_content]', opener.document).val(org_content + img);
                <?php } ?>
            });
            alert('이미지가 삽입되었습니다.');
            return false;
        }
        if (document.pressed == "선택삭제") {
            if (!confirm("선택한 사진을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n 게시판에 삽입한 사진을 선택하신 경우\n 사진이 출력되지 않습니다."))
                return false;
            f.action = "./imagebox_list_update.php";
            return true;
        }
    }
    //전체선택
    function all_checked(sw) {
        var f = document.imagelist_form;

        for (var i = 0; i < f.length; i++) {
            if (f.elements[i].name == "select_item[]")
                f.elements[i].checked = sw;
        }
    }
    $(function() {
        $('.editable').jinplace();


        //삽입버튼
        $('.insert-editor').click(function() {
            var img = "\n<p><img src='<?php echo G5_DATA_URL . "/editor/{$member['mb_id']}/" ?>" + $(this).data('image') + "' class='img-imagebox' alt='" + $(this).data('alt') + "'/></p>\n";
            <?php if (
                ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == 'cheditor5') ||
                ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == '' && $config['cf_editor'] == 'cheditor5')
            ) { ?> //Cheditor5
                var org_content = opener.ed_wr_content.getContents();
                opener.ed_wr_content.putContents(org_content + img + '\n');
            <?php } ?>

            <?php if (
                ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == 'smarteditor2') ||
                ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == '' && $config['cf_editor'] == 'smarteditor2')
            ) { ?> //네이버 스마트 에디터
                opener.oEditors.getById["wr_content"].exec("PASTE_HTML", [img]);
            <?php } ?>
            <?php if (
                ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == 'tinymce') ||
                ($board['bo_use_dhtml_editor'] && $board['bo_select_editor'] == '' && $config['cf_editor'] == 'tinymce')
            ) { ?>
                //Tinymce
                opener.tinymce.get('wr_content').insertContent(img + '\n');
            <?php } ?>
            <?php if (!$board['bo_use_dhtml_editor']) { ?>
                //textarea
                var org_content = $('textarea[name=wr_content]', opener.document).val();
                $('textarea[name=wr_content]', opener.document).val(org_content + img);
            <?php } ?>

            alert('삽입되었습니다.');
        });
        //창닫기
        $('.close-window').click(function() {
            window.close();
        });
    });
</script>
<?php
include_once "./_tail.php";
