<?php
include_once "./_common.php";
/**
 * Image Box 
 * 불법복제를 금지합니다.
 */
//권한 체크
if (!$is_member) {
    alert_close('회원만 이용가능합니다. 로그인 후 이용하세요.');
    exit;
}

//install 체크
$ib_table = sql_fetch("SHOW tables like '" . IB_TABLE . "'");
if (!$ib_table) {
    alert('설치 후 이용하세요.', './install.php');
}

include_once "./_head.php";
?>

<div class='container'>
    <div class='row'>
        <div class='col'>
            <div class='imagebox-wrap mt-5 mb-5'>
                <?php
                //폴더 권한 체크
                $chunk_path = G5_PLUGIN_PATH . '/ask-imagebox/uploader/server/chunks';
                if (!is_writable($chunk_path)) {
                    echo "<div class='alert alert-info'>{$chunk_path} 디렉토리 퍼미션을 777 또는 707로 변경후 사용 하세요.</div>";
                }
                ?>

                <!-- Fine Uploader Thumbnails template w/ customization ====================================================================== -->
                <?php echo '<script type="text/template" id="qq-template-validation">'; ?>
                <div class="qq-uploader-selector qq-uploader" qq-drop-area-text="Drop files here">
                    <div class="qq-upload-drop-area-selector qq-upload-drop-area" qq-hide-dropzone>
                        <span class="qq-upload-drop-area-text-selector"></span>
                    </div>
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <div class="qq-upload-button-selector qq-upload-button btn btn-primary">
                            <div>파일선택</div>
                        </div>
                    </div>
                    <span class="qq-drop-processing-selector qq-drop-processing">
                        <span>Processing dropped files...</span>
                        <span class="qq-drop-processing-spinner-selector qq-drop-processing-spinner"></span>
                    </span>
                    <div class="qq-total-progress-bar-container-selector qq-total-progress-bar-container">
                        <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-total-progress-bar-selector qq-progress-bar qq-total-progress-bar"></div>
                    </div>
                    <ul class="qq-upload-list-selector qq-upload-list" aria-live="polite" aria-relevant="additions removals">
                        <li>
                            <div class="qq-progress-bar-container-selector">
                                <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-progress-bar-selector qq-progress-bar"></div>
                            </div>
                            <span class="qq-upload-spinner-selector qq-upload-spinner"></span>
                            <img class="qq-thumbnail-selector" qq-max-size="100" qq-server-scale>
                            <span class="qq-upload-file-selector qq-upload-file"></span>
                            <span class="qq-upload-size-selector qq-upload-size"></span>
                            <button type="button" class="qq-btn qq-upload-cancel-selector qq-upload-cancel btn btn-danger btn-sm">취소</button>
                            <button type="button" class="qq-btn qq-upload-retry-selector qq-upload-retry btn btn-secondary btn-sm">재시도</button>
                            <button type="button" class="qq-btn qq-upload-delete-selector qq-upload-delete btn btn-sm"><i class="fa fa-trash" aria-hidden="true"></i></button>
                            <span role="status" class="qq-upload-status-text-selector qq-upload-status-text"></span>
                        </li>
                    </ul>

                    <dialog class="qq-alert-dialog-selector">
                        <div class="qq-dialog-message-selector"></div>
                        <div class="qq-dialog-buttons">
                            <button type="button" class="qq-cancel-button-selector btn btn-secondary btn-sm">닫기</button>
                        </div>
                    </dialog>

                    <dialog class="qq-confirm-dialog-selector">
                        <div class="qq-dialog-message-selector"></div>
                        <div class="qq-dialog-buttons">
                            <button type="button" class="qq-cancel-button-selector btn btn-danger btn-sm">아니오</button>
                            <button type="button" class="qq-ok-button-selector btn btn-primary btn-sm">예</button>
                        </div>
                    </dialog>

                    <dialog class="qq-prompt-dialog-selector">
                        <div class="qq-dialog-message-selector"></div>
                        <input type="text">
                        <div class="qq-dialog-buttons">
                            <button type="button" class="qq-cancel-button-selector btn btn-secondary btn-sm">취소</button>
                            <button type="button" class="qq-ok-button-selector btn btn-primary btn-sm">확인</button>
                        </div>
                    </dialog>
                </div>
                <?php echo '</script>'; ?>

                <div class='alert alert-info'>
                    사진과 관련된 태그를 입력하세요. 여러 사진을 등록할 경우 입력한 태그가 동시에 등록한 사진에 적용됩니다. 예)경북궁
                    <div class="input-group mt-1">
                        <span class="input-group-text" id="tag">Tag</span>
                        <input type="text" name='ib_tag' class="form-control tags" placeholder="Tag 입력" aria-label="Username" aria-describedby="tag">
                    </div>
                </div>
                <!-- 업로드 정보 -->
                <div class="upload-info p-2">
                    <ul class="board-info">
                        <li><span class="ui-title">총용량</span> : <?php echo round((float) $total_size / 1000 / 1000, 2); ?>MB</li>
                        <li><span class="ui-title">남은용량</span> : <?php echo round((IB_QUOTA - (float) $total_size) / 1000 / 1000, 2); ?>MB</li>
                        <li><span class="ui-title">업로드 용량</span> : <?php echo number_format(IB_FILESIZE / 1024 / 1024) . 'M'; ?></li>
                        <li><span class="ui-title">업로드 개수</span> : <span id="au-total-count">0</span>/<?php echo IB_FILECOUNT; ?></li>
                        <li><span class="ui-title">업로드 가능 파일</span> : <?php echo implode(", ", IB_EXT) ?></li>

                    </ul>
                </div>
                <?php if ($total_size >= IB_QUOTA) { ?>
                    <div class='alert alert-info'>
                        <h4><i class="fa fa-info-circle" aria-hidden="true"></i> 업로드 용량 초과 </h4>
                        <hr />
                        업로드 가능한 용량을 초과하였습니다. 현재 업로드한 용량은 <?php echo round((float) $total_size / 1000 / 1000, 2); ?>MB이며 1인당 할당된 용량은 <?php echo IB_QUOTA / 1000 / 1000; ?>MB 입니다.MB<br />
                    </div>
                <?php } else { ?>
                    <div id="ask-uploader-drop"></div>
                    <script type="text/javascript">
                        $('#ask-uploader-drop').fineUploader({
                            template: 'qq-template-validation',
                            debug: <?php echo IB_DEBUG ?>,
                            request: {
                                endpoint: '<?php echo G5_PLUGIN_URL ?>/ask-imagebox/uploader/server/endpoint.php'
                            },
                            deleteFile: {
                                enabled: <?php echo IB_DELETE ?>,
                                endpoint: '<?php echo G5_PLUGIN_URL ?>/ask-imagebox/uploader/server/endpoint.php',
                                forceConfirm: true,
                                method: "POST"
                            },
                            thumbnails: {
                                placeholders: {
                                    waitingPath: '<?php echo G5_PLUGIN_URL ?>/ask-imagebox/uploader/placeholders/waiting-generic.png',
                                    notAvailablePath: '<?php echo G5_PLUGIN_URL ?>/ask-imagebox/uploader/placeholders/not_available-generic.png'
                                },

                                timeBetweenThumbs: 20 //썸네일 디스플레이 속도, 메모리 누수 위험 때문에 너무 빠르게 하면 안된다.
                            },
                            maxConnections: 5,
                            chunking: {
                                //대용량 파일에 대한 업로드
                                enabled: <?php echo IB_BIGFILE ?>,
                                concurrent: {
                                    enabled: true
                                },
                                success: {
                                    endpoint: '<?php echo G5_PLUGIN_URL ?>/ask-imagebox/uploader/server/endpoint.php?done'
                                }
                            },
                            /*
                            session: {
                                endpoint: '<?php echo G5_PLUGIN_URL ?>/ask-imagebox/uploader/server/list.php',
                                params: {
                                    mb_id: '<?php echo $member['mb_id'] ?>'
                                },
                                customHeaders: {},
                                refreshOnReset: true
                            },
                            */
                            resume: {
                                enabled: <?php echo IB_RESUME ?>
                            },
                            retry: {
                                enableAuto: false,
                                showButton: <?php echo IB_RETRY ?>
                            },
                            validation: {
                                allowedExtensions: <?php echo json_encode(IB_EXT) ?>, //첨부파일 확장자 지정. 보안을 위해서 php, js 파일 업로드 금지.
                                itemLimit: <?php echo IB_FILECOUNT ?>, //게시판 관리자에서 첨부 개수 제한 설정
                                sizeLimit: <?php echo IB_FILESIZE ?> //게시판 관리자에서 첨부 용량 제한 설정
                            },
                            callbacks: {
                                onAutoRetry: function(id) {
                                    //
                                },
                                onCancel: function(id) {
                                    //
                                },
                                onComplete: function(id, name, responseJSON) {
                                    console.log('############################# onCOMPLETE ################################');
                                    console.log(responseJSON);
                                    //업로드시 생성한 썸네일 이미지가 적용되도록 수정.
                                    $('.qq-file-id-' + id + ' img').attr('src', <?php echo "'" . G5_DATA_URL . "/editor/{$member['mb_id']}/thmb-'" ?> + responseJSON['uploadName']);
                                    $('.qq-file-id-' + id + ' .qq-upload-size-selector').text((responseJSON['filesize'] / 1000 / 1000).toFixed(1) + "MB");
                                    $('#au-total-count').text(id);
                                    //용량초과 메세지
                                    if (responseJSON.quota) {
                                        alert(responseJSON.quota);
                                    }
                                },
                                onAllComplete: function(succeeded, failed) {
                                    var uploadCount = this.getUploads({
                                        status: 'upload successful'
                                    }).length;
                                },
                                onSubmitDelete: function(id, xhr) {
                                    this.setDeleteFileParams({
                                        filename: this.getName(id), //원본파일명
                                        uuidfile: this.getUuid(id)
                                    }, id);
                                },
                                onDeleteComplete: function(id, xhr, isError) {
                                    var uploadCount = this.getUploads({
                                        status: 'upload successful'
                                    }).length;
                                    console.log(xhr);
                                },
                                onError: function(id, name, errorReason) {
                                    //
                                },
                                onManualRetry: function(id, name) {
                                    //
                                },
                                onPasteReceived: function() {
                                    //
                                },
                                onResume: function(id, name, chunkData, customResumeData) {
                                    //
                                },
                                onSessionRequestComplete: function(response, success, xhrOrXdr) {
                                    /*
                                    if (success) {
                                        setTimeout(function() {
                                            $.each(response, function(i, value) {
                                                //업로드시 생성한 썸네일 이미지가 적용되도록 수정.
                                                $('.qq-file-id-' + i + ' img').attr('src', value.thumbnailUrl);
                                                $('#au-total-count').text(i);
                                            });
                                        }, 1000);
                                        setTimeout(function() {
                                            $.each(response, function(i, value) {
                                                //업로드시 생성한 썸네일 이미지가 적용되도록 수정.
                                                $('.qq-file-id-' + i + ' img').attr('src', value.thumbnailUrl);
                                                $('#au-total-count').text(i);
                                            });
                                        }, 2000);
                                        setTimeout(function() {
                                            $.each(response, function(i, value) {
                                                //업로드시 생성한 썸네일 이미지가 적용되도록 수정.
                                                $('.qq-file-id-' + i + ' img').attr('src', value.thumbnailUrl);
                                                $('#au-total-count').text(i);
                                            });
                                        }, 3000);
                                        setTimeout(function() {
                                            $.each(response, function(i, value) {
                                                //업로드시 생성한 썸네일 이미지가 적용되도록 수정.
                                                $('.qq-file-id-' + i + ' img').attr('src', value.thumbnailUrl);
                                                $('#au-total-count').text(i);
                                            });
                                        }, 5000);

                                        setTimeout(function() {
                                            $.each(response, function(i, value) {
                                                //업로드시 생성한 썸네일 이미지가 적용되도록 수정.
                                                $('.qq-file-id-' + i + ' img').attr('src', value.thumbnailUrl);
                                                $('#au-total-count').text(i);
                                            });
                                        }, 10000);
                                    }*/
                                },
                                onStatusChange: function(id) {
                                    //
                                },
                                onSubmit: function(id, name) {
                                    this.setParams({
                                        id: id,
                                        name: name,
                                        tags: $('.tags').val()
                                    }, id);
                                }
                            }
                        });
                    </script>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php
include_once "./_tail.php";
