<?php
include_once "./_common.php";

/**
 * ASK Image Box 설치 
 */
if ($is_admin != 'super') {
    alert('최고관리자만 접근 가능합니다.');
}
include_once "./_head.php";
?>
<div class='container'>
    <nav class="navbar navbar-light bg-light mt-3">
        <a class="navbar-brand" href="#"> Install</a>
    </nav>
    <div class='row'>
        <div class='col-sm-12'>
            <div class="jumbotron p-4 mb-3 mt-3">
                <h1 class="display-5">이미지박스 설치</h1>
                <hr />
                아래 안내에 따라 이미지박스를 설치하세요. <br />
                <?php
                if (version_compare(PHP_VERSION, '7.0.0', '<')) {
                    echo '<strong class="alert alert-danger">최소 PHP Version 7.0 이상을 사용하세요, 현재 설치된 PHP Version: ' . PHP_VERSION . "</strong>";
                }
                ?>
            </div>
        </div>
        <div class='col-sm-12'>
            <h2 class="page-title mt-5">라이선스 안내</h2>
            <div class="form-group">
                <textarea name="license" id="" class="form-control" placeholder="" aria-describedby="helpId" rows="10">ASK ImageBox 라이선스
-------------------------------------------
ASK ImageBox 이용약관
이 소프트웨어는 오픈소스로 제공되며, 무료로 사용할 수 있습니다.
재배포는 엄격히 금지됩니다. 소스 코드 또는 이 소프트웨어의 일부를 재배포하거나 다른 프로젝트에서 사용할 수 없습니다.
이 소프트웨어를 사용함으로써 발생하는 모든 결과에 대한 책임은 사용자에게 있습니다. 개발자는 어떠한 경우에도 책임을 지지 않습니다.
이 소프트웨어는 "있는 그대로" 제공되며, 어떠한 형태의 보증도 제공되지 않습니다. 모든 사용은 사용자의 책임하에 이루어져야 합니다.
이용자는 이 소프트웨어를 사용함으로써 관련 법률, 규정, 저작권 및 지적재산권을 준수해야 합니다.
이용자는 이 소프트웨어를 수정, 변경, 파생물 작성 등의 목적으로 사용할 수 있습니다. 하지만, 이용자는 이러한 수정된 버전을 비공개로 유지해야 합니다.
이용자는 소스 코드의 저작권 및 라이선스 공지를 삭제, 변경하지 않아야 합니다.</textarea>
                <small id="helpId" class="text-muted">위 라이선스 내용을 읽고 동의해야 사용가능합니다.</small>
            </div>
            <form action="./install_update.php">
                <label><input type="checkbox" name='agree' value="1"> 위 라이선스에 동의하며 설치를 진행합니다.</label>
                <div class="form-action text-center">
                    <button type="submit" class='btn btn-primary btn-lg submit'>설치하기</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('.submit').on('click', function() {
            var agreeCheck = $('input[name=agree').is(":checked");
            if (agreeCheck == false) {
                alert('라이선스에 동의해야 설치가 진행됩니다.');
                return false;
            }
            return true;
        });
    });
</script>

<?php
include_once "./_tail.php";
