<?php

/**
 * ASK ImageBox Upload Endpoint
 */
include_once "./_common.php";
require_once "./handler.php";
include_once G5_PLUGIN_PATH . "/ask-imagebox/vendor/autoload.php";
//include_once G5_LIB_PATH . "/thumbnail.lib.php";
// import the Intervention Image Manager Class
use Intervention\Image\ImageManager;

// create an image manager instance with favored driver gd or imagick
$manager = new ImageManager(array('driver' => IB_IMAGE_DRIVER));
//error_reporting(E_ALL);
//ini_set("display_errors", 1);
if (!$is_member) {
    die('회원 전용입니다.');
}
if (!$member['mb_id']) {
    die('회원 전용입니다.');
}

$uploader = new UploadHandler();

// Specify the list of valid extensions, ex. array("jpeg", "xml", "bmp")
$uploader->allowedExtensions = IB_EXT; // all files types allowed by default
// Specify max file size in bytes.
$uploader->sizeLimit = IB_FILESIZE;

// Specify the input name set in the javascript.
$uploader->inputName = "qqfile"; // matches Fine Uploader's default inputName value by default
// If you want to use the chunking/resume feature, specify the folder to temporarily save parts.
$uploader->chunksFolder = "chunks";

$method = check_request_method();

//쿼터 용량 초과 처리
$total_size = ib_foldersize(G5_DATA_PATH . "/editor/{$member['mb_id']}");
if ($total_size >= IB_QUOTA) {
    $result = array('quota' => '쿼터 용량이 초과되었습니다.');
    echo json_encode($result);
    exit;
}

//파일 업로드
if ($method == "POST") {
    header("Content-Type: text/plain");
    //업로드 폴더
    $upload_dir = G5_DATA_PATH . DIRECTORY_SEPARATOR . 'editor' . DIRECTORY_SEPARATOR . $member['mb_id'];
    if (!file_exists($upload_dir)) {
        //없으면 생성
        mkdir($upload_dir, 0707, true);
    }
    //대용량 파일 분할 업로드
    if (isset($_GET["done"])) {
        //분할 업로드된 파일 합치기
        $result = $uploader->combineChunks($upload_dir);
    } else {
        //파일 업로드 OR 분할 업로드
        $result = $uploader->handleUpload($upload_dir);
    }

    //업로드 정보 입력용

    $result['name'] = isset($_POST['name']) && $_POST['name'] != '' ? $_POST['name'] : '';
    $result['uploadName'] = $uploader->getUploadName();

    #############################
    ### 업로드 처리
    #############################
    if ($result['success'] == true  && file_exists($upload_dir . DIRECTORY_SEPARATOR . $result['uploadName']) && $result['uploadName'] != '' && $result['name'] != '') {
        //전체 파일 경로
        $file_full_path = $upload_dir . DIRECTORY_SEPARATOR . $result['uploadName'];
        clearstatcache();
        //이미지 정보
        $file_info = getimagesize($file_full_path);


        //목록용 썸네일 이미지 생성 
        //ib_thumbnail($result['uploadName'], $upload_dir, $upload_dir, IB_THUMB_W, IB_THUMB_H, false, false, 'center', true);
        $img = $manager->make($file_full_path)->resize(IB_THUMB_W, null, function ($constraint) {
            $constraint->aspectRatio();
        })->orientate();
        //저장
        $img->save($upload_dir . DIRECTORY_SEPARATOR . "thmb-" . $result['uploadName']);

        //지도용 썸네일 리사이즈, 비율조정
        $img = $manager->make($upload_dir . DIRECTORY_SEPARATOR . "thmb-" . $result['uploadName'])->resize(IB_THUMB_MW, IB_THUMB_MH, function ($constraint) {
            $constraint->aspectRatio();
        })->orientate();
        //지도용 썸네일 저장
        $img->save($upload_dir . DIRECTORY_SEPARATOR . "thmb-map-" . $result['uploadName']);

        if (isset($file_info) && $file_info) {
            //이미지 파일 EXIF 정보
            $exif             = ib_get_exif($file_full_path);
            $exif['gps_info'] = ib_get_image_location($exif);
            $flashfired       = 'No';
            $CameraMaker      = strtoupper($exif['Make'] . ' ' . $exif['Model']);
            if (isset($exif['Flash']) && $exif['Flash'] == 1) {
                $flashfired = 'Yes';
            }
            if (isset($exif['Flash']) && $exif['Flash'] == 2) {
                $flashfired = 'Strobe Return Light Detected';
            }
            if (isset($exif['Flash']) && $exif['Flash'] == 4) {
                $flashfired = 'Strobe Return Light Not Detected';
            }
            if (isset($exif['Flash']) && $exif['Flash'] == 8) {
                $flashfired = 'Compulsory Flash Mode';
            }
            if (isset($exif['Flash']) && $exif['Flash'] == 16) {
                $flashfired = '자동';
            }
            if (isset($exif['Flash']) && $exif['Flash'] == 32) {
                $flashfired = '없음';
            }
            if (isset($exif['Flash']) && $exif['Flash'] == 64) {
                $flashfired = 'Red Eye Reduction Mode';
            }
            if (isset($exif['WhiteBalance']) && $exif['WhiteBalance'] == 0) {
                $WhiteBalance = '자동';
            }
            if (isset($exif['WhiteBalance']) && $exif['WhiteBalance'] == 1) {
                $WhiteBalance = '수동';
            }
            $photo_address = '';
            if ((isset($config['cf_kakao_rest_key']) && $config['cf_kakao_rest_key'] != '') && (isset($config['cf_kakao_js_apikey']) && $config['cf_kakao_js_apikey'] != '')) {
                //http://map.daum.net/link/map/우리회사,37.402056,127.108212
                if ((isset($exif['gps_info']['Latitude']) && $exif['gps_info']['Latitude'] != '') && (isset($exif['gps_info']['Longitude']) && $exif['gps_info']['Longitude'] != '')) {
                    /*
                    if (!$view['file'][$i]['bf_content']) {
                        $photo_address = kakao_map_request('/v2/local/geo/coord2address', "x=" . $exif['gps_info']['Longitude'] . "&y=" . $exif['gps_info']['Latitude'] . "&input_coord=WGS84", $file_full_path);
                    } else {
                        $photo_address = '';
                    }*/
                }
            }
            $ib_longitude = isset($exif['gps_info']['Longitude']) && $exif['gps_info']['Longitude'] != '' ?  $exif['gps_info']['Longitude'] : "";
            $ib_latitude = isset($exif['gps_info']['Latitude']) && $exif['gps_info']['Latitude'] != '' ?  $exif['gps_info']['Latitude'] : "";
            if (isset($exif['DateTime'])) {
                $ib_datetime = date("Y-m-d H:i:s", strtotime($exif['DateTime']));
            }
            if (isset($exif['COMPUTED']['Width']) && isset($exif['COMPUTED']['Height'])) {
                $ib_width = $exif['COMPUTED']['Width'];
                $ib_height = $exif['COMPUTED']['Height'];
            }
            if (isset($exif['COMPUTED']['ApertureFNumber'])) {
                $ib_aperturefnumber = $exif['COMPUTED']['ApertureFNumber'];
            }
            if (isset($exif['Flash'])) {
                $ib_flash = $flashfired;
            }
            if (isset($exif['WhiteBalance'])) {
                $ib_whitebalance = $exif['WhiteBalance'];
            }
            if (isset($exif['ISOSpeedRatings'])) {
                $ib_iso = $exif['ISOSpeedRatings'];
            }
            if (isset($exif['FocalLength'])) {
                $ib_focallength = $exif['FocalLength'];
            }
            if (isset($exif['ExposureTime'])) {
                $ib_exposuretime = $exif['ExposureTime'];
            }
        } //EXIF

        $file_info = pathinfo($file_full_path);
        if (IB_OPTIMIZE == true) {
            //이미지 최적화
            $img = $manager->make($file_full_path)->encode($file_info['extension'], 80)->orientate();
            //저장
            $img->save($file_full_path);
        }
        if (IB_RESIZE > 0 && IB_RESIZE != false) {
            //이미지 크기 줄이기
            $img = $manager->make($file_full_path)->resize(IB_RESIZE, null, function ($constraint) {
                $constraint->aspectRatio();
            })->orientate();

            //저장
            $img->save($file_full_path);
        }


        //파일사이즈
        clearstatcache();
        $file_size = filesize($file_full_path);
        $result['filesize'] = $file_size;
        $result['size'] = $file_size;
        $tags = get_text(strip_tags($tags));
        //DB 입력하기
        $sql = " INSERT into `" . IB_TABLE . "`
                    set `mb_id` = '{$member['mb_id']}',
                         `ib_filename` = '{$result['uploadName']}',
                         `ib_datetime` = '" . G5_TIME_YMDHIS . "',
                         `ib_size` = '{$file_size}',
                         `ib_tag` = '{$tags}',
                         `exif_camera` = '{$CameraMaker}',
                         `exif_datetime` = '{$ib_datetime}',
                         `exif_width` = '{$ib_width}',
                         `exif_height` = '{$ib_height}',
                         `exif_aperturefnumber` = '{$ib_aperturefnumber}',
                         `exif_flash` = '{$flashfired}',
                         `exif_wihtebalance` = '{$WhiteBalance}',
                         `exif_exposuretime` = '{$ib_exposuretime}',
                         `exif_iso` = '{$ib_iso}',
                         `exif_focallength` = '{$ib_focallength}',
                         `exif_longitude` = '{$ib_longitude}',
                         `exif_latitude` = '{$ib_latitude}',
                         `ib_address` = '{$photo_address}' ";
        sql_query($sql, true);
        $result['ib_idx'] = sql_insert_id();
    }

    //업로드 결과값 리턴
    echo json_encode($result);
} else if ($method == "DELETE") {
    ###################
    # 파일 삭제
    ###################
    //DB에서 삭제
    $ext = ib_get_ext($_POST['filename']);
    $sql = "DELETE from `" . IB_TABLE . "` where `mb_id` = '{$member['mb_id']}' and `ib_filename` = '{$_POST['uuidfile']}.{$ext}' limit 1";
    sql_query($sql, true);

    //실제 파일 삭제
    $upload_dir = G5_DATA_PATH . DIRECTORY_SEPARATOR . 'editor' . DIRECTORY_SEPARATOR . $member['mb_id'];
    $result = $uploader->handleDelete($upload_dir, $_POST['filename']);
    //썸네일삭제
    @unlink($upload_dir . "/thmb-{$_POST['uuidfile']}.{$ext}");
    @unlink($upload_dir . "/thmb-map-{$_POST['uuidfile']}.{$ext}");
    //결과값 돌려주기
    echo json_encode($result);
} else {
    header("HTTP/1.0 405 Method Not Allowed");
}
