<?php
include_once './ask_sftp.lib.php';

//인증 실패 체크
if ($sftp && !is_resource($sftp)) {
    exit;
}
// 현재 폴더
$homedir = ssh2_sftp_realpath($sftp, ".");
$homedir = rtrim($homedir, '/') . '/';
$current_dir = $homedir . $_GET['folder'];
if (isset($_GET['edit_file']) && $_GET['edit_file']) {
    $file_path = $current_dir . DIRECTORY_SEPARATOR . $_GET['edit_file'];
    // SFTP 서버의 파일 정보 가져오기
    $file_info = @ssh2_sftp_stat($sftp, $file_path);
    if ($file_info == false) {
        die('파일을 열 수 없습니다.');
    }
    //원격 파일 가져오기
    if ($file_info !== false) {
        $stream = @fopen("ssh2.sftp://{$sftp}{$file_path}", 'r');
        if ($stream) {
            $edit_contents = '';
            while (!feof($stream)) {
                $edit_contents .= fread($stream, 8192);
            }
            fclose($stream);

            $edit_contents = htmlspecialchars($edit_contents, ENT_QUOTES);

            $sess_uid =  getSftpUid($sftp);
            $file_uid =  getFileUid($sftp, $file_path);
        } else {
            die('파일을 열 수 없습니다.');
        }
    }

    //설정된 파일 확장자 체크
    $file_ext = pathinfo($_GET['edit_file'], PATHINFO_EXTENSION);
    if (!in_array($file_ext, _SFTP_OPEN_FILES)) {
        die('파일을 열 수 없습니다. 허가되지 않은 파일입니다.');
    }
} else {
    die('파일을 열 수 없습니다.');
    exit;
}


include_once './header.php';
?>


<div class="container">
    <div class="border p-1 p-md-4 bg-white mt-4">
        <h5 class="mb-3">SFTP Editor</h5>
        <a href="./" class="btn btn-sm btn-outline-primary btn-">HOME</a>
        <div class="mt-3 mb-3 p-3">
            <div class='open-file mb-1 <?php echo ($sess_uid == $file_uid) ? "text-black" : "text-secondary"; ?>'>
                <i class="bi bi-file-earmark-code-fill"></i> <?php echo $file_path ?> <?php echo ($sess_uid == $file_uid) ? '(편집가능)' : '(읽기전용)'; ?>
            </div>
            <div id="code_editor" class="code-editor"><?php echo $edit_contents; ?></div>
            <script>
                var editor = ace.edit("code_editor");
                editor.session.setMode("ace/mode/php");
                editor.setReadOnly(<?php echo ($sess_uid == $file_uid) ? 'false' : 'true'; ?>); //읽기전용
                editor.resize(true);
                //editor.getValue(); 데이터 가져오기
            </script>
            <hr />
            <form id='editform' action="./edit_save.php" method="post">
                <div class='d-flex justify-content-end'>
                    <label><input type='checkbox' name='backup_save' value='1'>백업생성 - backup.시간.파일명으로 저장됩니다.</label>
                </div>
                <div class='d-flex'>
                    <input type="hidden" name='folder' value='<?php echo $_GET['folder']; ?>'>
                    <input type="hidden" name='current_dir' value='<?php echo $current_dir; ?>'>
                    <input type="hidden" name='edit_file' value='<?php echo $_GET['edit_file']; ?>'>
                    <input type='hidden' name='contents' class='contents'>
                    <button type='button' id='cancel' class='btn btn-secondary'>취소</button>
                    <button type='submit' <?php echo ($sess_uid == $file_uid) ? '' : 'disabled'; ?> class='btn btn-primary ms-auto'>저장</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('#editform').submit(function(data) {
            var string = editor.getValue();
            $('.contents').val(string);
            return true;
        });
        $('#cancel').on('click', function() {
            history.back();
        });
    });
</script>
<?php
include_once './footer.php';
