<?php
include_once './ask_sftp.lib.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Error");
    exit;
}

//인증 실패 체크
if (isset($sftp) && !is_resource($sftp)) {
    die("접속 Error");
    exit;
}

// 사용자의 홈 디렉토리 경로 가져오기
$homedir = ssh2_sftp_realpath($sftp, ".");
$homedir = rtrim($homedir, '/') . '/';

// SFTP 서버의 파일 정보 가져오기
$dir_info = @ssh2_sftp_stat($sftp, $_POST['current_dir']);
$dir_val = isValidDirectory($_POST['current_dir']);

if ($dir_info == false) {
    die('존재하지 않는 디렉토리입니다.');
}
if ($dir_val == false) {
    die('디렉토리 오류!!');
}

//홈디렉토리에만 저장
if (strpos($_POST['current_dir'], $homedir) === 0) {

    // 파일 저장을 위한 백업 파일명 생성
    if (isset($_POST['backup_save']) && $_POST['backup_save'] == '1') {
        $backup_filename = 'backup.' . date('YmdHis') . '.' . $_POST['edit_file'];
        ssh2_sftp_rename($sftp, $_POST['current_dir'] . DIRECTORY_SEPARATOR . $_POST['edit_file'], $_POST['current_dir'] . DIRECTORY_SEPARATOR . $backup_filename);
    }

    // 저장할 파일명과 경로를 지정합니다.
    $save_file = $_POST['current_dir'] . DIRECTORY_SEPARATOR . $_POST['edit_file'];

    $edit_file = $_POST['edit_file'];
    $extension = pathinfo($edit_file, PATHINFO_EXTENSION);

    if (!in_array(strtolower($extension), _SFTP_OPEN_FILES)) {
        die("허용되지 않는 파일 확장자입니다.");
    }

    // SFTP를 통해 파일을 저장합니다.
    $result = file_put_contents("ssh2.sftp://{$sftp}/{$save_file}", stripslashes($_POST['contents']));
    if ($result == true) {
        $_SESSION['_message'] = "{$save_file} 파일이 저장되었습니다.";
    }
    header("location:./?folder=" . $_POST['folder']);
} else {
    die("저장 경로가 허용되지 않습니다.");
}
