<?php
include_once './ask_sftp.lib.php';
//인증 실패 체크
if ($sftp && !is_resource($sftp)) {
    exit;
}
// 사용자의 홈 디렉토리 경로 가져오기
$homedir = ssh2_sftp_realpath($sftp, ".");
$homedir = rtrim($homedir, '/') . '/';
if (!isset($_GET['folder'])) {
    $files = getSFTPFileList($sftp, $homedir);
} else {
    $files = getSFTPFileList($sftp, $homedir . $_GET['folder']);
}
// 파일 리스트 알파벳순으로 정렬
if (isset($files['dirs']) && is_array($files['dirs'])) {
    sort($files['dirs']);
}

if (isset($files['files']) && is_array($files['files'])) {
    sort($files['files']);
}

//파일 편집 이동
if (isset($_GET['edit_file']) && $_GET['edit_file']) {
    header('location:./edit.php?folder=' . (isset($_GET['folder']) ? $_GET['folder'] : '') . '&edit_file=' . $_GET['edit_file']);
}
include_once './header.php';
?>
<div class="container">
    <div class="border p-4 bg-white mt-4">

        <h5 class="mb-3">SFTP Client</h5>
        <div class="dir-nav d-flex justify-content-between">
            <a href="./" class="btn btn-sm btn-outline-primary btn-">~</a>
            <?php
            //상위폴더로 이동
            if (isset($_GET['folder']) && $_GET['folder'] !== '') {
                $parent_folder = getPreviousFolderParameter($_GET['folder']);
                echo '<a href="./' . $parent_folder . '" class="btn btn-sm btn-outline-primary btn-"><i class="bi bi-arrow-90deg-up"></i></a>';
            }
            ?>
        </div>
        <div class="mt-3 mb-3">
            <div class="dir-nav mb-2 mt-2 border p-2 fs-6 bg-light">
                <i class="bi bi-folder2"></i> <?php echo $homedir . (isset($_GET['folder']) ? $_GET['folder'] : ""); ?>
            </div>
            <?php if (isset($_SESSION['_message']) && $_SESSION['_message'] != '') { ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <strong>Message - </strong> <?php echo $_SESSION['_message']; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php
                unset($_SESSION['_message']);
            } ?>
            <ul class='list-group'>
                <?php
                if (isset($files['dirs']) && is_array($files['dirs'])) {
                    $dir_path = '';
                    // 폴더 출력
                    foreach ($files['dirs'] as $dir) {
                        if (isset($_GET['folder'])) {
                            $dir_path = $_GET['folder'] . DIRECTORY_SEPARATOR . $dir;
                        } else {
                            $dir_path = $dir;
                        }
                        echo "<li class='list-group-item'><i class='bi bi-folder'></i><a href='?folder={$dir_path}' class='text-primary'> {$dir}</a></li>";
                    }
                } else {
                    $no_dir = true;
                }
                if (isset($files['files']) && is_array($files['files'])) {
                    $link = '';
                    // 파일 출력
                    foreach ($files['files'] as $file => $val) {
                        $ext = strtolower(pathinfo($val['name'], PATHINFO_EXTENSION));
                        echo "<li class='list-group-item'>";
                        $link = htmlspecialchars($val['name'], ENT_QUOTES, 'UTF-8');
                        if (in_array($ext, _SFTP_OPEN_FILES)) {
                            // 링크가 가능한 파일 확장자만 출력
                            $link =  "<i class='bi bi-file-earmark-code'></i>{$val['name']} <a href='{$_SERVER['REQUEST_URI']}&edit_file={$val['name']}'><span class='text-warning'> <i class='bi bi-pencil-square'></span></a></i>";
                        }
                        // 링크가 불가능한 파일은 확장자를 표시하며 출력
                        echo "<div class='d-flex file-info-wrap'>
                            <div class='file-name flex-fill'><i class='bi bi-file'></i> {$link}</div>
                            <div class='file-info pe-1'>" . number_format($val['size']) . "Bytes</div>
                            <div class='file-info pe-1 d-none d-md-block'><i class='bi bi-clock-fill'></i>{$val['created']}</div>
                            <div class='file-info'><i class='bi bi-person-fill'></i>{$val['owner']}</div>
                            </div>";

                        echo "</li>";
                    }
                } else {
                    $no_file = true;
                }
                if ((isset($no_file) && $no_file == true) && isset($no_dir) && $no_dir == true) {
                    //파일, 디렉토리 없음.
                    echo "<li class='list-group-item p-5 text-center'><i class='bi bi-emoji-frown'></i> 파일 또는 디렉토리가 없습니다.";
                    if (isset($_SESSION['_warning_error_message']) && $_SESSION['_warning_error_message'] != '') { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <strong>Message - </strong> <?php echo $_SESSION['_warning_error_message']; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                <?php
                        unset($_SESSION['_warning_error_message']);
                    }
                }
                echo '</li';
                ?>
            </ul>
        </div>
    </div>
</div>

<?php
include_once './footer.php';
