<?php

/**
 * SFTP 로그인 화면
 */
include_once './ask_sftp.lib.php';
//로그인 체크 
include_once './header.php';
?>
<div class="container login-wrap">
    <div class="border p-4 bg-white mt-4">

        <h5 class="mb-3">SFTP Login</h5>
        <?php if (isset($_SESSION['_message_login_error']) && $_SESSION['_message_login_error'] != '') { ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <strong>Message - </strong> <?php echo $_SESSION['_message_login_error']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php
            unset($_SESSION['_message_login_error']);
        } ?>
        <div class="mt-3 mb-3">
            <form method="post" action="./login_check.php" autocomplete="new-password">
                <div class="input-group flex-nowrap mb-1">
                    <span class="input-group-text" id="ask_host">HOST</span>
                    <input type="text" name='ask_host' class="form-control required" required placeholder="yourdomian or ip address" aria-label="yourdomian or ip address">
                </div>
                <div class="input-group flex-nowrap mb-1">
                    <span class="input-group-text" id="ask_id">ID</span>
                    <input type="text" name='ask_id' class="form-control required" required placeholder="account" aria-label="account">
                </div>
                <div class="input-group flex-nowrap mb-1">
                    <span class="input-group-text" id="ask_pw">PASSWORD</span>
                    <input type="password" name='ask_pw' class="form-control required" required autocomplete="new-password">
                </div>
                <div class="input-group flex-nowrap mb-1">
                    <span class="input-group-text" id="ask_port">PORT</span>
                    <input type="text" name='ask_port' class="form-control required" required placeholder="22" aria-label="ssh port">
                </div>
                <div class="input-group flex-nowrap mb-1">
                    <span class="input-group-text" id="ask_pin">PIN</span>
                    <input type="password" class="form-control required" required id="ask_pin" name='ask_pin'>
                </div>
                <div class="input-group">
                    <span class="input-group-text">이용약관</span>
                    <textarea class="form-control" rows="4" aria-label="With textarea">
ASK SFTP Client 이용약관
이 소프트웨어는 오픈소스로 제공되며, 무료로 사용할 수 있습니다.
재배포는 엄격히 금지됩니다. 소스 코드 또는 이 소프트웨어의 일부를 재배포하거나 다른 프로젝트에서 사용할 수 없습니다.
이 소프트웨어를 사용함으로써 발생하는 모든 결과에 대한 책임은 사용자에게 있습니다. 개발자는 어떠한 경우에도 책임을 지지 않습니다.
이 소프트웨어는 "있는 그대로" 제공되며, 어떠한 형태의 보증도 제공되지 않습니다. 모든 사용은 사용자의 책임하에 이루어져야 합니다.
이용자는 이 소프트웨어를 사용함으로써 관련 법률, 규정, 저작권 및 지적재산권을 준수해야 합니다.
이용자는 이 소프트웨어를 수정, 변경, 파생물 작성 등의 목적으로 사용할 수 있습니다. 하지만, 이용자는 이러한 수정된 버전을 비공개로 유지해야 합니다.
이용자는 소스 코드의 저작권 및 라이선스 공지를 삭제, 변경하지 않아야 합니다.
                    </textarea>
                </div>
                <hr/>
                <div class="text-center d-flex justify-content-end mt-2">
                    <button type="submit" class="btn btn-primary">약관 동의 및 로그인</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
include_once './footer.php';
