tinymce.PluginManager.add('code_toggle', function (editor) {

  editor.ui.registry.addButton('code_toggle', {
    icon: 'code',
    text: 'Code',
    tooltip: 'Code',
    onAction: function () {
      toggleCode(this, editor);
    }
  });

  editor.on('change', function () {
    editor.setContent(editor.target.innerText);
  });

  var toggleCode = function (elem, editor) {

    elem.active(!elem.active());
    var state = elem.active();
    var self = elem.element;
    var tinymce = self.closest('.tox-tinymce');
    var aceID = 'ace-editor-' + editor.id;

    if (state) {

      // Code mode
      tinymce.findAll('.tox-tbtn').forEach(function (btn) {
        if (btn.id !== self.id) {
          btn.style.pointerEvents = 'none';
          btn.style.opacity = '0.4';
        }
      });
      tinymce.find('.tox-edit-area').style.display = 'none';
      editor.contentAreaContainer.style.height = editor.getDoc().documentElement.scrollHeight + 'px';
      editor.contentAreaContainer.style.display = 'block';

      if (typeof ace !== 'undefined') {

        var textarea = tinymce.find('textarea');
        textarea.style.display = 'none';
        tinymce.find('body').insertAdjacentHTML('beforeend', '<div id="' + aceID + '"></div>');
        var aceEditor = ace.edit(aceID);

        aceEditor.$blockScrolling = Infinity;
        aceEditor.setTheme("ace/theme/chrome");
        aceEditor.session.setMode("ace/mode/html_ruby");
        aceEditor.setValue(textarea.value, 1);
        aceEditor.setOptions({
          wrap: true,
          displayIndentGuides: true,
          highlightActiveLine: false,
          showPrintMargin: false,
          minLines: Math.round(300 / 17),
          maxLines: Math.round(300 / 17)
        });
        aceEditor.on('change', function () {
          textarea.value = aceEditor.getValue();
          editor.setContent(aceEditor.getValue());
        });
      }

    } else {

      // Editor mode
      tinymce.findAll('.tox-tbtn').forEach(function (btn) {
        if (btn.id !== self.id) {
          btn.style.pointerEvents = 'auto';
          btn.style.opacity = '1';
        }
      });
      tinymce.find('.tox-edit-area').style.display = 'block';
      editor.contentAreaContainer.style.display = 'none';

      if (typeof ace !== 'undefined') {

        var aceEditor = ace.edit(aceID);
        aceEditor.destroy();
        tinymce.find('#' + aceID).remove();

      }
    }
  };
});
