<?php
declare(strict_types=1);

/**
 * 그누보드 에디터 이미지 자동정리 플러그인
 * @author kkigomi
 * @version 0.1.0
 * @link https://github.com/kkigomi
 * @license https://opensource.org/licenses/LGPL-2.1 GNU LGPL v2.1 or later
 */

if (!defined('_GNUBOARD_')) {
    exit;
}

define('KG_PLUGIN_EDITOR_IMAGES_VERSION', '0.1.0');

// DB 테이블 생성 등 설치가 완료되지 않았다면 동작 중지
// super 관리자만 설치를 실행할
if (!installed_c7ac4e02()) {
    if ($is_admin === 'super') {
        install_c7ac4e02();
    } else {
        return;
    }
}

// 이미지 파일 업로드
add_replace(
    'get_editor_upload_url',
    'listenerGetEditorUploadUrl_c7ac4e02',
    G5_HOOK_DEFAULT_PRIORITY,
    2
);
// 게시판 글 쓰기
add_event(
    'write_update_after',
    'listenerWriteUpdateAfter_c7ac4e02',
    G5_HOOK_DEFAULT_PRIORITY,
    3
);
// 글 삭제
add_event(
    'bbs_delete',
    'listenerBbsDelete_c7ac4e02',
    G5_HOOK_DEFAULT_PRIORITY,
    4
);

/**
 * 에디터에서 이미지 업로드 시 목록을 받아 DB에 저장
 */
function listenerGetEditorUploadUrl_c7ac4e02($file_url = null, $savefile = null)
{
    $filesize = filesize($savefile);
    $filehash = sha1_file($savefile);
    $savefile = str_replace(G5_PATH, '', $savefile);
    $memberId = $GLOBALS['member']['mb_id'] ?? '';
    $createdAt = G5_TIME_YMDHIS;

    $sql = "INSERT
        INTO `g5_kg_editor_images`
        SET `filepath` = '{$savefile}',
            `filesize` = '{$filesize}',
            `filehash` = '{$filehash}',
            `member_id` = '{$memberId}',
            `created_at` = '{$createdAt}'
    ";
    sql_query($sql);
}

function listenerWriteUpdateAfter_c7ac4e02($board, $wr_id, $w)
{
    preg_match_all('/(?:src=)(?:\\\|\'|\\")(?:.+?)(?<path>\/data\/editor\/.+?)(?:\\\|\'|\\")/i', $GLOBALS['wr_content'], $matches, PREG_UNMATCHED_AS_NULL);

    foreach ($matches['path'] as $file) {
        if (file_exists(G5_PATH . $file)) {
            $targetType = "article:{$board['bo_table']}";
            $targetId = (string) $wr_id;
            sql_query("UPDATE `g5_kg_editor_images`
                SET `target_type` = '{$targetType}',
                    `target_id` = '{$targetId}'
                WHERE
                    `target_type` IS NULL
                    AND `target_id` IS NULL
                    AND `filepath` = '{$file}'
            ");
        }
    }
}

/**
 * 지정된 글에 포함된 이미지 삭제
 */
function listenerBbsDelete_c7ac4e02($write, $board)
{
    $targetType = "article:{$board['bo_table']}";
    $targetId = (string) $write['wr_id'];
    $tableName = G5_TABLE_PREFIX . 'kg_editor_images';

    if (!$targetType || !$targetId) {
        return;
    }

    // 파일 목록
    $result = sql_query("SELECT `filepath`
        FROM `{$tableName}`
        WHERE
            `target_type` = '{$targetType}'
            AND `target_id` = '{$targetId}'
    ");

    // 파일 목록을 순회하며 파일 삭제
    while ($row = sql_fetch_array($result)) {
        $path = dirname(G5_PATH . $row['filepath']);
        $fileName = explode('/', $row['filepath']);
        $fileId = strstr(end($fileName), '.', true);

        // 파일 삭제
        unlink(G5_PATH . $row['filepath']);

        // 썸네일 삭제
        $thumbFiles = glob("{$path}/thumb-{$fileId}_*");
        foreach ($thumbFiles as $thumbFile) {
            unlink($thumbFile);
        }
    }

    // DB에서 삭제
    sql_query("DELETE FROM `{$tableName}`
        WHERE
            `target_type` = '{$targetType}'
            AND `target_id` = '{$targetId}'
    ");
}

/**
 * 테이블 생성
 */
function install_c7ac4e02(): void
{
    if (installed_c7ac4e02()) {
        return;
    }

    $tableName = G5_TABLE_PREFIX . 'kg_editor_images';
    sql_query("CREATE TABLE IF NOT EXISTS `{$tableName}` (
        `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `target_type` varchar(50) CHARACTER SET ascii DEFAULT NULL,
        `target_id` varchar(190) CHARACTER SET ascii DEFAULT NULL,
        `filepath` varchar(255) CHARACTER SET ascii NOT NULL,
        `filesize` int(10) UNSIGNED NOT NULL,
        `filehash` varchar(100) CHARACTER SET ascii NOT NULL,
        `member_id` varchar(50) CHARACTER SET ascii DEFAULT NULL,
        `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `target_type` (`target_type`,`target_id`),
        KEY `member_id` (`member_id`),
        KEY `filehash` (`filehash`)
    );");
}

/**
 * DB 테이블 생성 확인 등 설치 여부 확인
 */
function installed_c7ac4e02(): bool
{
    // cache에서 업데이트 기록이 있으면 패스
    $cacheData = g5_get_cache('kg-editor-images-updated') ?: '0.0.0';
    if ($cacheData >= \KG_PLUGIN_EDITOR_IMAGES_VERSION) {
        return true;
    }

    $tableName = G5_TABLE_PREFIX . 'kg_editor_images';
    $result = sql_query("SHOW TABLES LIKE '{$tableName}'");
    $existsEditorImages = $result->num_rows > 0;

    if (!$existsEditorImages) {
        return false;
    }

    g5_set_cache('kg-editor-images-updated', KG_PLUGIN_EDITOR_IMAGES_VERSION);

    return true;
}