<?php
/**
 * @author kkigomi
 * @version 1.0.0
 * @link https://github.com/kkigomi
 * @license https://opensource.org/licenses/LGPL-2.1 GNU LGPL v2.1 or later
 */
if (!defined('_GNUBOARD_')) {
    exit;
}

if (!!$config['cf_use_member_icon']) {
    add_replace('member_sideview_items', 'iconFallback_54abe2ba', G5_HOOK_DEFAULT_PRIORITY, 2);
}

function iconFallback_54abe2ba($items, $args)
{
    global $config;

    // true로 변경하면 회원아이콘이 있어도 프로필 이미지로 변경
    $override = false;

    if (!(!!$args['mb_id'])) {
        return;
    }

    if (!isset($items['name_tag']['profile_image'])) {
        return;
    }

    if (!file_exists(G5_DATA_PATH . '/member_image/' . substr($args['mb_id'], 0, 2) . '/' . get_mb_icon_name($args['mb_id']) . '.gif')) {
        return;
    }

    if (
        !$override
        && file_exists(G5_DATA_PATH . '/member/' . substr($args['mb_id'], 0, 2) . '/' . get_mb_icon_name($args['mb_id']) . '.gif')
    ) {
        return;
    }

    if (
        $override
        || (
            defined('G5_THEME_NO_PROFILE_IMG')
            && $items['name_tag']['profile_image'] === G5_THEME_NO_PROFILE_IMG
        )
        || (
            defined('G5_NO_PROFILE_IMG')
            && $items['name_tag']['profile_image'] === G5_NO_PROFILE_IMG
        )
    ) {
        $image = get_member_profile_img($args['mb_id'], $config['cf_member_icon_width'], $config['cf_member_icon_height']);

        $items['name_tag']['profile_image'] = '<span class="profile_img">' . $image . '</span>';
    }

    return $items;
}