<?php
include_once('./_common.php');

if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

include_once($_gsc->path_plugin . '/install.check.php');

// 자동 로그인
// 쿠키 체크, 로그인 하지 않았다면
if (($is_auto_login=get_cookie($_gsc->text_cookie_auto_login) && !$_gsc->session_user_id))
{
	$user_id = $_gsc->func_get_user_id(get_cookie($_gsc->text_cookie_id_save));

	$_gsc->row_user = $_gsc->func_get_user($user_id);

	if (!$_gsc->row_user->user_id || $_gsc->row_user->user_last_login_time != get_cookie($_gsc->text_cookie_last_login_time))
	{
		$_gsc->func_set_cookie($_gsc->text_cookie_id_save, '');
		$_gsc->func_set_cookie($_gsc->text_cookie_auto_login, '');
		$_gsc->func_set_cookie($_gsc->text_cookie_last_login_time, '');

		alert('자동 로그인 시 오류가 발생하였습니다.', G5_URL . '/calendar.login.php');
	}

	$_gsc->func_set_user_login($user_id);

	// 아이디 저장
	$_gsc->session_user_id = $_gsc->row_user->user_id;

	include_once(G5_PATH.'/head.sub.php');
	echo "<script>location.reload();</script>";
	include_once(G5_PATH.'/tail.sub.php');
	exit;
}

$_gsc->check_not_login();

include_once($_gsc->path_plugin . '/inc.member.check.php');

$g5['title'] = '출근달력';

$md5_page_access = md5(microtime());
set_session('md5_page_access', $md5_page_access);

include_once(G5_PATH.'/head.sub.php');

$getdate = getdate();

$year = !isset($_GET['year']) ? date("Y") : (int)$_GET['year'];
$month = !isset($_GET['month']) ? $getdate['mon'] : (int)$_GET['month'];

$_gsc->create_table($year);
?>

<!--
favicon.ico 출처
https://www.iconfinder.com/adambaihaqi88
-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/df-number-format/2.1.6/jquery.number.min.js"></script>

<link rel="preconnect" href="https://fonts.googleapis.com" />
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
<link href="https://fonts.googleapis.com/css2?family=Gothic+A1:wght@200&family=Noto+Sans+KR&display=swap" rel="stylesheet" />
<link href="<?php echo $_gsc->url_plugin?>/css/calendar.css?ver=<?php echo time()?>" rel="stylesheet" />
<link href="<?php echo $_gsc->url_plugin?>/css/loading.css?ver=<?php echo time()?>" rel="stylesheet" />
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0" />

<div class="calendar_body">
	<div class="black_back"></div>
    <div class="black_back2"></div>
	<div class="menu_body">
		<ul class="td_menus">
			<li class="date_info"></li>
			<li number="10">👷 <font class="menu_title">근태설정</font></li>
			<li number="20">📖 <font class="menu_title">메모장</font></li>
			<li number="30">🎞 <font class="menu_title">이미지</font></li>
			<!--
			<li number="40">📒 <font class="menu_title">가계부 </font></li>
			<li number="50">📆 <font class="menu_title">일정관리</font></li>
			-->
			<li number="110">📝 <font class="menu_title">한줄메모(음성)</font></li>
			<!--<li number="100">🎙 <font class="menu_title">음성메모(10초)</font></li>-->
		</ul>
	</div>

	<div class="td_sub_menus">
		<ul temp="true" class="td_sub_menu td_sub_menus10">
			<li>
				<form id="gongsu_update" method="post" action="<?php echo $_gsc->url_plugin?>/gongsu.update.php" target="hidden_iframe">
				<input type="hidden" name="type" value="" />
				<input type="hidden" name="date" value="" />
				<table class="gongsu-table" width="100%" border="0" cellpadding="0" cellspacing="0">
				<thead>
				<tr>
					<td width="20%">유형</td>
					<td>
						<?php foreach($_gsc->array_atten_type as $k => $v) { ?>
						<input type="button" class="gongsu_type_btn <?php echo $k==1?'selected':''?>" number="<?php echo $k?>" value="<?php echo $_gsc->array_atten_type[$k]?>" />
						<?php } ?>
					</td>
				</tr>
				</thead>
				<tbody>
				<tr>
					<td>단가</td>
					<td>
						<input type="button" class="gongsu_pm_btn dan_minus" value="-" /><input type="text" class="number_obj job_price2" name="job_price2" value="0" /><input type="button" class="gongsu_pm_btn dan_plus" value="+" />
					</td>
				</tr>
				<tr>
					<td>합계</td>
					<td><font class="disp_gongsu_total"></font></td>
				</tr>
				<tr>
					<td>공수</td>
					<td>
						<?php
						foreach($_gsc->array_gongsu_per as $k => $v) { ?>
						<input type="button" class="gongsu_per_btn<?php echo $v['default']?' selected':''?>" value="<?php echo $v['val']?>" />
						<?php } ?>
					</td>
				</tr>
				<tr>
					<td></td>
					<td>
						<input type="button" class="gongsu_pm_btn gongsu_minus" value="-" /><input type="text" class="number_obj job_price_per" name="job_price_per" value="0" /><input type="button" class="gongsu_pm_btn gongsu_plus" value="+" />
					</td>
				</tr>
				</tbody>
				<tfoot>
				<tr>
					<td colspan="2" class="gongsu_btn_area">
					<br />
						<input type="button" id="gongsu_form_submit" value="입력" />
					</td>
				</tr>
				</tfoot>
				</table>
				</form>
			</li>
		</ul>

		<!-- 이미지 서브 메뉴 -->
		<ul temp="true" class="td_sub_menu td_sub_menus30">
			<li number="10">📸 <font class="menu_title">사진찍기</font></li>
			<li number="20">📤 <font class="menu_title">사진업로드</font></li>
		</ul>
	</div>
	<!-- 서브 메뉴 끝 -->

	<div id="controll_panel" class="controll_panel">
		<span> 설정메뉴</span>
		<!--
		<ul>
			<li>
				<font><b>보기</b></font>
				<label><input type="checkbox" class="view_holis" name="view_type1" checked /> <font>공휴일</font></label>
				<label><input type="checkbox" class="view_price" name="view_type2" /> <font>단가</font></label>
				<label><input type="checkbox" class="view_scehdule" name="view_type3" /> <font>일정</font></label>
			</li>
		</ul>
		-->
		<a href="" class="falseEvent" onclick="location.reload();"><font>🔄 새로고침</font></a>
		<?php if($_gsc->is_admin) { ?>
		<!--<a href="" onclick="return false;"><font>☢️ 작업자관리</font></a>-->
		<?php } ?>
		<a href="" class="falseEvent" id="user_info_modify"><font>🔧 정보수정</font></a>
		<!--<a href="" class="falseEvent" id=""><font>📅 공수/단가/기간 변경</font></a>
		<a href="" id="user_info_modify"><font>🛠 설정</font></a>
		<a href="calendar.backup.php" onclick="if(!confirm('백업하시겠습니까??\n\n저장된 전체기간에 대해서 txt파일로 다운로드 합니다.')){return false;}" target="hidden_iframe"><font>🗃 백업</font></a>-->
		<!--<a href=""><font>📊 통계</font></a>-->
		<a href="<?php echo $_gsc->url_plugin?>/logout.php" onclick="if(!confirm('로그아웃 하시겠습니까??')){return _falseEvent(e);}" target="hidden_iframe"><font>🔚 로그아웃</font></a>
	</div>

	<div class="calendar_container">
		<div class="top_nav">
			<span><b><u id="user_name"><?php echo $_gsc->row_user->user_name?></u></b>님
			출근 : <b><u><font class="att1"></font></u></b> 일,
			결근 : <b><u><font class="att2"></font></u></b> 일,
			조퇴 : <b><u><font class="att3"></font></u></b> 일</span>
			<a href="" class="falseEvent" id="a_setting">⚙<font> 설정</font></a>
		</div>

		<div id="calendar_div_contents">
			<table class="touch_none" width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td align="center" height="50">
						<a href="<?php
							if ($month == 1) {
								$year_pre  = $year-1;
								$month_pre = 12;
							} else {
								$year_pre  = $year;
								$month_pre = $month-1;
							}

							echo $_SERVER['PHP_SELF'] . "?year={$year_pre}&month={$month_pre}";
						?>">‹ <?php echo $month_pre?>월</a>

						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

						<a href="" onclick="return false;" onfocus="this.blur()" style="font-size:18px;font-weight:bold;"><?php echo "{$year}년&nbsp;{$month}월"; ?></a>

						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

						<a href="<?php
							if ($month == 12) {
								$year_pre  = $year + 1;
								$month_pre = 1;
							} else {
								$year_pre  = $year;
								$month_pre = $month + 1;
							}
							echo $_SERVER['PHP_SELF'] . "?year={$year_pre}&month={$month_pre}";
						?>"><?php echo $month_pre?>월 ›</a>
					</td>
				</tr>
			</table>

			<table class="calendar_table" width="100%" bgcolor="#cfcfcf" border="0" cellspacing="1" cellpadding="5">
				<thead>
					<tr bgcolor="#fdfac2" align="center">
						<th class="th_sun">일</th>
						<th class="th_mon">월</th>
						<th class="th_tue">화</th>
						<th class="th_wed">수</th>
						<th class="th_thu">목</th>
						<th class="th_fri">금</th>
						<th class="th_sat">토</th>
					</tr>
				</thead>

				<tbody>
				<?php
				$holi_file = $_gsc->path_data . '/' . $year . '.txt';

				if ($_gsc->key_gonggong && !file_exists($holi_file))
					$_gsc->set_calendar($year);

				if (file_exists($holi_file))
				{
					$holis = explode("\n", file_get_contents($holi_file));

					foreach($holis as $k => $v)
					{
						$v = explode("\t", $v);

						if (!isset($holis[$v[3]]))
							$holis[$v[3]] = array();

						$holis[$v[3]][] = array(
							'dateKind' => $v[0],
							'dateName' => $v[1],
							'isHoliday' => $v[2],
							'seq' => $v[4]
						);

						unset($holis[$k]);
					}
				} else
					$holis = array();


				$tmp_month = sprintf("%02d", $month);

				$_gsc->table_rename($year);

				// 데이타 로딩
				$query = sql_query(" select a.*, b.*
				from
					`{$_gsc->db_calendar}` as a left join `{$_gsc->db_timeline}` as b
				on
					b.user_id = a.user_id and
					b.tl_date = a.cc_date
				where
					a.user_id = '{$_gsc->session_user_id}' and
					a.cc_date like '{$year}-{$tmp_month}%'
				order by
					a.cc_date asc ");

				$datas = array();

				$att1_day = 0;
				$att2_day = 0;
				$att3_day = 0;

				while($row=sql_fetch_array($query))
				{
					$a = array();
					$a['no'] = $row['cc_no'];
					$a['type'] = $row['cc_type'];
					$a['content'] = $row['cc_content'];

					$a['job_price'] = explode("|", $_gsc->row_user->user_job_prices[(int)$row['cc_job_price']]);
					$a['job_price'] = (int)$a['job_price'][0];
                    $a['job_price2'] = (int)$row['cc_job_price2'];

					$a['company'] = explode("|", $_gsc->row_user->user_companys[(int)$row['cc_company']]);
					$a['company'] = strip_tags($a['company'][0]);

					$a['job_price_per'] = sprintf('%0.1f', (float)$row['cc_job_price_per']);

					$a['files'] = $row['cc_files'] != '' ? explode("\n", $row['cc_files']) : array();
					$a['filter_files'] = array_filter($a['files']);
					$a['is_content'] = isset($row['cc_content']) && trim($row['cc_content']) != '' ? true : false;
					$a['is_timeline'] = (isset($row['tl_content']) && trim($row['tl_content'])) != '' || count($a['filter_files']) > 0 ? true : false;

					$datas["{$row['cc_date']}"] = (object)$a;

					if ($a['type'] == 1) $att1_day++;
					if ($a['type'] == 2) $att2_day++;
					if ($a['type'] == 3) $att3_day++;
				}

				$day = 1;
				$sel_mon = sprintf("%02d", $month);

				$totime = strtotime(date("{$year}-{$month}-01"));
				$lastday = date('t', $totime);

				$dayoftheweek = date("w", $totime);

				$temp = 7 - (($lastday + $dayoftheweek) % 7);

				if ($temp == 7)
					$temp = 0;

				$lastcount = $lastday + $dayoftheweek + $temp;

				for ($i=1; $i<=$lastcount; $i++)
				{
					$bgcolor = "#ffffff";  // 쭉 흰색으로 칠하고
					$font_style = '';

					$today_class = '';
					if ($getdate['year'] == $year && $getdate['mon'] == $month && $getdate['mday'] == $day)
						$today_class = ' td_today ';

					if ($i % 7 == 1)
						echo "<tr>\n";

					if ($dayoftheweek < $i && $i <= $lastday + $dayoftheweek)
					{
						$daycontcolor = "" ;
						$daycolor = "";

						if ($i % 7 == 1) $daycolor = "#ff0000"; // 공휴일
						if ($i % 7 == 0) $daycolor = "#0000ff"; // 토요일

						$tmp_day = sprintf("%02d", $day);

						$att_type = 0;
						$att_content = '';
						$add_class = $add_class2 = $add_class3 = '';
						$add_text2 = $add_text3 = '';

						$tmp_datas = new stdClass;

						if (isset($datas["{$year}-{$tmp_month}-{$tmp_day}"]))
							$tmp_datas = $datas["{$year}-{$tmp_month}-{$tmp_day}"];

						if (isset($tmp_datas->no))
						{
							$att_type = (int)$tmp_datas->type;
							$att_content = $tmp_datas->content;

							if ($att_type > 0)
								$add_class = ' att' . $att_type . ' ';

							if ($att_content)
							{
								$add_text2 = '📄';
								$add_class2 = ' memo ';
							}

							if (count($tmp_datas->filter_files))
							{
								$add_text3 = '🖼';
								$add_class3 = ' files ';
							}
						}
						else
						{
							$tmp_datas->no = 0;
							$tmp_datas->job_price = 0;
							$tmp_datas->job_price2 = 0;
							$tmp_datas->company = '';
							$tmp_datas->job_price_per = 0;
							$tmp_datas->files = array();
							$tmp_datas->filter_files = array();
							$tmp_datas->is_content = false;
							$tmp_datas->is_timeline = false;
							$tmp_datas->content = '';
						}

						echo "<td
						data-no='{$tmp_datas->no}'
						data-date='{$year}년 {$tmp_month}월 {$tmp_day}일'
						data-att-type='{$att_type}'
						data-price='{$tmp_datas->job_price}'
                        data-price2='{$tmp_datas->job_price2}'
						data-company='{$tmp_datas->company}'
						data-price-per='{$tmp_datas->job_price_per}'
						data-is-content='" . ($tmp_datas->is_content?'1':'0') . "'
						data-is-timeline='" . ($tmp_datas->is_timeline?'1':'0') . "'
						class='td_select{$today_class}'
						valign='top'>";

						echo "<p class='memo_p {$add_class2}'>{$add_text2}</p>";
						echo "<p class='files_p {$add_class3}' files='" . join(',', $tmp_datas->files) . "'>{$add_text3}</p>";

						$tmp_str2 = '';

						if (isset($holis["{$year}{$tmp_month}{$tmp_day}"]))
						{
							foreach($holis["{$year}{$tmp_month}{$tmp_day}"] as $k => $v)
							{
								$holi_class = '';

								if ($v['isHoliday'] == 'Y')
								{
									$daycolor = '#ff0000';
									$holi_class = ' holi_day';
								}

								$tmp_str2 = "<font class='holis{$holi_class}' full_name='{$v['dateName']}'>" . cut_str($v['dateName'], 5, '') . '</font>';
							}
						}

						echo "<span class='cc_content'>{$tmp_datas->content}</span>";
						echo "<font color=\"{$daycolor}\" style=\"{$font_style}\">{$day}</font>";
						echo $tmp_str2;

						$att_per = ($att_type == 1 || $att_type == 3) && $tmp_datas->job_price_per < 1 ? 100 - (100 * $tmp_datas->job_price_per) : 0;

						$gauge_class= '';
						$gauge_per = 0;

						if (($att_type == 1 || $att_type == 3) && $tmp_datas->job_price_per > 1)
						{
							if ($att_type == 1) $gauge_class = ' att1 ';
							if ($att_type == 3) $gauge_class = ' att3 ';

							$gauge_per = 100 - (200 - (100 * $tmp_datas->job_price_per));
						}

						if (($att_type == 1 || $att_type == 3) && $tmp_datas->job_price_per > 2)
						{
							if ($att_type == 1) $gauge_class = ' att1 ';
							if ($att_type == 3) $gauge_class = ' att3 ';

							$gauge_per = 100 - (300 - (100 * $tmp_datas->job_price_per));
						}

						$att_type_text = isset($_gsc->array_atten_type[$att_type]) ? $_gsc->array_atten_type[$att_type] : '';

						$job_price = '';

						$job_price_per = sprintf('%0.1f', $tmp_datas->job_price_per);

						if ($att_type == 1 || $att_type == 3)
						{
							$job_price = ($tmp_datas->job_price2=(int)$tmp_datas->job_price2) ? number_format($tmp_datas->job_price2 * ((float)$job_price_per)) : '';
						}

						echo "<div class='job_price'>{$job_price}</div>";

						echo "<div class='att {$add_class}'><span class='att_per' style='width:{$att_per}%;'></span><span class='att_gauge{$gauge_class}' style='width:{$gauge_per}%;'></span><font>" . $att_type_text . ($att_type == 1 || $att_type == 3 ? '<u>(' . $job_price_per . ')</u>' : '') . '</font></div>';

						echo "</td>\n";

						$day++;
					}
					else
						echo "<td class='td_other'>&nbsp;</td>\n";

					if ($i % 7 == 0)
						echo "</tr>\n";

				} // 반복문 끝
				?>
				</tbody>
			</table>
		</div>
	</div>
</div>

<table class="total-calculate" border="0" cellspacing="1" cellpadding="1">
<tr>
	<td width="44%" height="26"><font class="tit-pay">회사</font> : <b id="disp_company"><?php echo $_gsc->row_user->company;?></b></td>
	<td rowspan="2" align="right"><span class="job-total"><font class="tit-total">합계</font> : <b><font class="won"></font></b> 원</span></td>
</tr>
<tr>
	<td height="26"><font class="tit-pay">단가</font> : <b><font class="won" id="disp_job_price2"><?php echo number_format($_gsc->row_user->job_price);?></font></b> 원</td>
</tr>
</table>
<div id="message"></div>

<?php include($_gsc->path_plugin . '/inc.forms.php'); ?>

<svg></svg>
<iframe name="hidden_iframe" style="display:none;"></iframe>

<script type="text/javascript">
function _falseEvent(e)
{
	e.returnValue = false;
	if(e.preventDefault) { e.preventDefault(); }
	if(e.stopPropagation) { e.stopPropagation(); }
	if(e.stopImmediatePropagation) { e.stopImmediatePropagation(); }
	return false;
}

function typeString(name)
{
	return String(typeof(name)).toLowerCase();
}

var url_gsc_plugin = '<?php echo $_gsc->url_plugin?>';
var att1_day = 0;
var att2_day = 0;
var att3_day = 0;
var ts_target_td = null;
var tc_target_td = null;
var is_fileupload = false;
var md5_page_access = '<?php echo $md5_page_access?>';
var calendar_data_url = "<?php echo $_gsc->url_data?>";
var image_width = <?php echo ((int)$_gsc->size_image_width);?>;
var image_height = <?php echo ((int)$_gsc->size_image_height);?>;
var image_upload_close,image_upload_error_close,att_days,memo_close,one_memo_close,black_back_close,worker_list_close = function(){};

var speechMsg = null;
var is_text_play = false;
var is_voice_start = false;
var event_td_start = null;
var is_del_img = false;
var ts_target_a = null;
var temp_nn = 150;

var cx = 0, cy = 0;
var temp_n = 40;
var is_true = false;
var notifi_div = null;
var target_notifi = null;

var is_touchstart = false;
var settime = null;
var gongsu_form = null;
var notifi_default_zidx = null;

var recognition = new(window.SpeechRecognition || window.webkitSpeechRecognition)();
recognition.lang = "ko";
recognition.maxAlternatives = 10;

var default_job_pay = <?php echo (int)$_gsc->row_user->job_price;?>;
var text_upload_type = '';
var gongsu_timeout = null;
var gongsu_interval = null;
var speak_memo_target = null;
var td_select_settime = null;
var is_stay_open = false;
var cxx;
var is_page_mode = false;
var select_day_html = '';
var is_camera_down = false;

(function($)
{
	att_days = function()
	{
		var att1_val = parseInt($("table.calendar_table td div.att1").length); // 출근일
		var att2_val = parseInt($("table.calendar_table td div.att2").length); // 결근일
		var att3_val = parseInt($("table.calendar_table td div.att3").length); // 조퇴일

		$('div.top_nav').find('span font.att1').text(att1_val);
		$('div.top_nav').find('span font.att2').text(att2_val);
		$('div.top_nav').find('span font.att3').text(att3_val);

		var total_price = 0;
		$("table.calendar_table td").find('div.att1, div.att3').each(function()
		{
			var obj_div = $(this);
			var obj_td = obj_div.parents('td:first');
			var price = parseInt(obj_td.attr('data-price2'));
			var price_per = parseFloat(obj_td.attr('data-price-per'));

			total_price += price * price_per;
		});

		$('span.job-total font.won').text($.number(total_price));
	}

	att_days();
	$(document).ready(att_days);
	$(window).on('load', function()
	{
		att_days();
		$('svg').attr('width', $(window).width());
		$('svg').attr('height', $(window).height());

		$('title:first')
			.after("<link href='<?php echo $_gsc->url_plugin?>/img/favicon.ico' rel='shortcut icon' />")
			.after("<meta name='mobile-web-app-capable' content='yes' />")
			.after("<meta name='apple-mobile-web-app-title' content='출근달력' />")
			.after("<meta name='apple-mobile-web-app-status-bar-style' content='default' />")
			.after("<link rel='apple-touch-icon' href='<?php echo $_gsc->url_plugin?>/img/favicon.ico' />")
			.after("<link rel='apple-touch-icon-precomposed' href='<?php echo $_gsc->url_plugin?>/img/favicon.ico' />")
			.text('출근달력');

		$('iframe.view_iframe')
			.attr('vspace', '0')
			.attr('hspace', '0')
			.attr('frameborder', '0');
	});

	$(window).on('touchend', function(e)
	{
		if (notifi_div != null)
		{
			notifi_div.removeClass('alpha');
		}

		if (target_notifi != null)
		{
			target_notifi.removeClass('alpha');
		}

		notifi_div = null;
		target_notifi = null;
		is_true = false;
		is_touchstart = false;
	});

	$('a').live('click', function(e)
	{
		if ($(this).hasClass('falseEvent')) {
			return _falseEvent(e);
		}
	});

	$('td.td_select').bind('selectstart', _falseEvent);
})(jQuery);
</script>
<script type="text/javascript" src="<?php echo $_gsc->url_plugin?>/js/calendar.js?vers=<?php echo time()?>"></script>
<script type="text/javascript" src="<?php echo $_gsc->url_plugin?>/js/pageshow.js?vers=<?php echo time()?>"></script>

<?php
include_once(G5_PATH.'/tail.sub.php');
