<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

class gsc_calendar
{
	function init()
	{
		// 프로그램 이름 머릿문자
		$this->plugin_prefix = 'gsc_';

		// 디비명
		$this->db_user = $this->plugin_prefix. 'user';
		$this->db_calendar = $this->plugin_prefix. 'calendar';
		$this->db_timeline = $this->plugin_prefix. 'timeline';

		// 쿠키 초
		$this->number_cookie_time_php = 86400 * 31;

		$this->text_session_user_id = $this->plugin_prefix. 'user_id';
		$this->text_session_user_confirm = $this->plugin_prefix. 'user_confirm';

		$this->text_cookie_id_save = $this->plugin_prefix. 'calendar_id_save';
		$this->text_cookie_auto_login = $this->plugin_prefix. 'calendar_auto_login';
		$this->text_cookie_last_login_time = $this->plugin_prefix. 'calendar_last_login_time';

		$this->url_data = G5_DATA_URL . '/' . $this->plugin_prefix . 'calendar';
		$this->path_data = G5_DATA_PATH . '/' . $this->plugin_prefix . 'calendar';

		$this->url_plugin = G5_PLUGIN_URL . '/' . $this->plugin_prefix . 'calendar';
		$this->path_plugin = G5_PLUGIN_PATH . '/' . $this->plugin_prefix . 'calendar';

		$this->session_user_id = get_session($this->text_session_user_id);

		$this->array_atten_type = array();
		$this->array_atten_type[1] = '출근';
		$this->array_atten_type[2] = '결근';
		$this->array_atten_type[3] = '조퇴';
		//$this->array_atten_type[4] = '휴일';

		$this->array_gongsu_per = array(
			array('val' => '0.5', 'default' => false),
			array('val' => '1.0', 'default' => true),
			array('val' => '1.5', 'default' => false),
			array('val' => '2.0', 'default' => false)
		);

		// 이미지 썸네일 크기
		// 자신의 핸드폰 이미지 크기에 비례하여 입력하시면 됩니다.
		$this->size_image_width = 1920;
		$this->size_image_height = 1440;

		$this->row_user = new stdClass;

		$this->is_admin = false;
		$this->key_gonggong = '';

		// 로그인 사용자 구하기
		if ($this->session_user_id)
		{
			$this->row_user = $users = $this->func_get_user($this->session_user_id);
			$this->session_user_no = $this->row_user->user_no;

			// 직장명과 단가는 가장 나중에 등록된 것을 사용합니다.
			$this->row_user->user_companys = explode("\n", $this->row_user->user_companys);
			$this->row_user->companys = explode("|", $this->row_user->user_companys[count($this->row_user->user_companys) - 1]);
			$this->row_user->company = base64_decode($this->row_user->companys[0]);

			$this->row_user->user_job_prices = explode("\n", $this->row_user->user_job_prices);
			$this->row_user->job_prices = explode("|", $this->row_user->user_job_prices[count($this->row_user->user_job_prices) - 1]);
			$this->row_user->job_price = (int)$this->row_user->job_prices[0];

			if ($this->row_user->is_admin == '1')
				$this->is_admin = true;

			$this->user_options = json_decode(base64_decode($this->row_user->user_options));
			$this->key_gonggong = $this->user_options->key_gonggong;
		}
		else
		{
			$this->row_user = new stdClass;
			$this->session_user_no = 0;
		}

		$this->calendars = [];
	}

	function func_set_cookie($name, $value, $expire=0)
	{
		setcookie(md5($name), base64_encode($value), G5_SERVER_TIME + $expire, '/', G5_COOKIE_DOMAIN);
	}

	function func_get_user($user_id)
	{
		$row = sql_fetch(" select * from `{$this->db_user}` where user_id = '{$user_id}' ");

		return (object)$row;
	}

	function func_get_user_id($user_id)
	{
		return substr(preg_replace("/[^0-9a-zA-Z]/", "", $user_id), 0, 20);
	}

	function func_set_user_login($user_id)
	{
		// 마지막 로그인 타임 저장
		sql_query(" update `{$this->db_user}` set user_last_login_time = '" . G5_SERVER_TIME . "' where user_id = '{$user_id}' ");

		// 아이디 저장
		set_session($this->text_session_user_id, $user_id);

		// 로그인 보안
		set_session($this->text_session_user_confirm, md5($user_id . '_' . G5_SERVER_TIME));

		// 마지막 로그인 타임 저장
		$this->func_set_cookie($this->text_cookie_last_login_time, G5_SERVER_TIME, $this->number_cookie_time_php);
	}

	function func_get_db_pass($user_pw)
	{
		$row = sql_fetch(" select CONCAT('*', UPPER(SHA1(UNHEX(SHA1('{$user_pw}'))))) as pass ");

		return $row['pass'];
	}

	// 이미지 화질 줄여서 용량을 줄임
	// $tmp_file, 생성 파일 패스, 퀄리티 0~100
	function func_compress($source, $destination, $quality)
	{
		$info = getimagesize($source);

		if ($info['mime'] == 'image/jpeg') {
			$image = imagecreatefromjpeg($source);
		}

		imagejpeg($image, $destination, $quality);

		return $destination;
	}

	function thumbnail($file, $save_filename, $width, $height)
	{
		$src_img = ImageCreateFromJPEG($file); //JPG파일로부터 이미지를 읽어옵니다

		$img_info = getImageSize($file);//원본이미지의 정보를 얻어옵니다
		$img_width = $img_info[0];
		$img_height = $img_info[1];

		$exifData = exif_read_data($file);

		if ($exifData['Orientation'] != 1)
		{
			$degree = 0;
			if ($exifData['Orientation'] == 6) $degree = 270;
			else if ($exifData['Orientation'] == 8) $degree = 90;
			else if ($exifData['Orientation'] == 3) $degree = 180;

			$img_width = $img_info[1];
			$img_height = $img_info[0];

			$width = $this->size_image_height;
			$height = $this->size_image_width;

			$src_img = imagerotate($src_img, $degree, 0);
		}

		$dst_img = imagecreatetruecolor($width, $height); //타겟이미지를 생성합니다

		ImageCopyResized($dst_img, $src_img, 0, 0, 0, 0, $width, $height, $img_width, $img_height); //타겟이미지에 원하는 사이즈의 이미지를 저장합니다

		ImageInterlace($dst_img);
		ImageJPEG($dst_img,  $save_filename); //실제로 이미지파일을 생성합니다
		ImageDestroy($dst_img);
		ImageDestroy($src_img);
	}

	function get_text($str)
	{
		$source[] = "<";
		$target[] = "&lt;";
		$source[] = ">";
		$target[] = "&gt;";
		$source[] = "\"";
		$target[] = "&#034;";
		$source[] = "\'";
		$target[] = "&#039;";
		$source[] = "|";
		$target[] = "&#124;";

		return str_replace($source, $target, $str);
	}

	function get_calendar($y, $type)
	{
		$ch = curl_init();
		$url = 'http://apis.data.go.kr/B090041/openapi/service/SpcdeInfoService/' . $type; /*URL*/
		$queryParams = '?' . urlencode('serviceKey') . '=' . $this->key_gonggong; /*Service Key*/
		$queryParams .= '&' . urlencode('pageNo') . '=' . urlencode('1');
		$queryParams .= '&' . urlencode('numOfRows') . '=' . urlencode('200');
		$queryParams .= '&' . urlencode('solYear') . '=' . urlencode($y);
		//$queryParams .= '&' . urlencode('solMonth') . '=' . urlencode($m);

		curl_setopt($ch, CURLOPT_URL, $url . $queryParams);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
		$response = curl_exec($ch);
		curl_close($ch);

		$xml = simplexml_load_string($response) or die("Error: Cannot create object");

		foreach($xml->body->items->item as $k => $v) {
			$this->calendars[] = $v;
		}
	}

	function set_calendar($y)
	{
		$this->get_calendar($y, 'getRestDeInfo');
		$this->get_calendar($y, 'getAnniversaryInfo');

		$times = [];

		foreach($this->calendars as $k => $v) {
			$times[] = strtotime($v->locdate);
		}

		array_multisort($times, SORT_ASC, $this->calendars);

		$arr = [];

		foreach($this->calendars as $k => $v)
		{
			$arr[] = $v->dateKind . "\t" . $v->dateName . "\t" . $v->isHoliday . "\t" . $v->locdate . "\t" . $v->seq;
		}

		$f = fopen($this->path_data . '/' . $y . '.txt', 'w');
		fwrite($f, join("\n", $arr));
	}

	function table_rename($year)
	{
		$this->db_calendar .= "_{$year}";
		$this->db_timeline .= "_{$year}";
	}

	function create_table($year)
	{
		$rename = "`{$this->plugin_prefix}calendar_{$year}`";
		$query = sql_query(" select * from `{$rename}` ");

		if (!$query)
		{
			$table_calendar = str_replace("`{$this->plugin_prefix}calendar`", $rename, file_get_contents($this->path_data . '/gsc_calendar.sql'));
			sql_query($table_calendar);
		}

		$rename = "`{$this->plugin_prefix}timeline_{$year}`";
		$query = sql_query(" select * from `{$rename}` ");

		if (!$query)
		{
			$table_timeline = str_replace("`{$this->plugin_prefix}timeline`", $rename, file_get_contents($this->path_data . '/gsc_timeline.sql'));
			sql_query($table_timeline);
		}
	}

	function check_first_confirm()
	{
		if (isset($this->row_user->user_id))
			alert('이미 인증 되었습니다.', G5_URL . '/calendar.php');
	}

	function check_not_login()
	{
		if (!$this->session_user_id)
			alert('인증 후 사용하세요', G5_URL . '/calendar.login.php');
	}

	function check_not_access()
	{
		if (!$this->session_user_id)
		{
			include_once(G5_PATH.'/head.sub.php');
			?>
			<script type="text/javascript">
			alert('인증 후 사용하세요.');
			parent.$('div.black_back').trigger('click');
			</script>
			<?php
			include_once(G5_PATH.'/tail.sub.php');
			exit;
		}
	}
}

$_gsc = new gsc_calendar();
$_gsc->init();

function sql_object($sql)
{
	$row = sql_fetch($sql);
	return (object)$row;
}