<?php
include_once('./_common.php');
include_once('inc.member.check.php');

include_once(G5_PATH.'/head.sub.php');

@mkdir($_gsc->path_data, G5_DIR_PERMISSION);
@chmod($_gsc->path_data, G5_DIR_PERMISSION);

$msg = '';

if (isset($_FILES['camera']))
{
	$source_img = $_FILES['camera']['tmp_name'];
	$destination_img = $_FILES['camera']['tmp_name'];
	$error = $_FILES['camera']['error'];
	$name = $_FILES['camera']['name'];

}
else if (isset($_FILES['uploader']))
{
	$source_img = $_FILES['uploader']['tmp_name'];
	$destination_img = $_FILES['uploader']['tmp_name'];
	$error = $_FILES['uploader']['error'];
	$name = $_FILES['uploader']['name'];
}
else
	$msg = '잘못된 접근입니다.';

// 오류 확인
if($error != UPLOAD_ERR_OK) {
	switch($error) {
		case UPLOAD_ERR_INI_SIZE:
		case UPLOAD_ERR_FORM_SIZE:
			$msg = "파일이 너무 큽니다. ($error)";
			break;
		case UPLOAD_ERR_NO_FILE:
			$msg = "파일이 첨부되지 않았습니다. ($error)";
			break;
		default:
			$msg = "파일이 제대로 업로드되지 않았습니다. ($error)";
	}
}

// 설정
$allowed_ext = array('jpg', 'JPG');
$ext = array_pop(explode('.', $name));

// 확장자 확인
if(!in_array($ext, $allowed_ext)) {
	$msg = '허용되지 않는 확장자입니다.';
}

if ($msg)
{
	echo "<script>
	alert('{$msg}');
	parent.image_upload_error_close();
	parent.black_back_close();
	</script>";
	exit;
}
else
{
	// 파일 리사이즈 후 복사하기
	//$destination_img = $_gsc->func_compress($source_img, $destination_img, 50);

	$text = preg_replace("/[\n\t]/", '', $_gsc->get_text(strip_tags($_POST['text'])));

	$file_info = explode('.', $name);
	$new_filename = md5($file_info[0] . time()) . '.' . $file_info[1];

	if (!isset($_POST['upload']))
		$_gsc->thumbnail($destination_img, $_gsc->path_data . '/' . $new_filename, $_gsc->size_image_width, $_gsc->size_image_height);
	else
		move_uploaded_file($destination_img, $_gsc->path_data . '/' . $new_filename);

	$date = preg_replace("/[^0-9 ]/", "", $_POST['date']);

	list($year, $month, $day) = explode(' ', $date);

	$_gsc->table_rename($year);

	$row = sql_fetch(" select * from `{$_gsc->db_calendar}`
	where
		user_id = '{$_gsc->session_user_id}' and
		cc_date = '{$year}-{$month}-{$day}' ");

	$file = $new_filename . '|' . base64_encode(str_replace('|', '&#124;', $text));

	if (isset($row['cc_no']))
	{
		$files = $row['cc_files'] != '' ? explode("\n", $row['cc_files']) : array();
		$files[] = $file;

		sql_query(" update `{$_gsc->db_calendar}`
		set
			cc_files = '" . join("\n", $files) . "'
		where
			user_id = '{$_gsc->session_user_id}' and
			cc_date = '{$year}-{$month}-{$day}' ");
	}
	else
	{
		sql_query(" insert into `{$_gsc->db_calendar}`
		set
			user_id = '{$_gsc->session_user_id}',
			cc_date = '{$year}-{$month}-{$day}',
			cc_files = '{$file}' ");

		 $data_no = sql_insert_id();

		 echo "<script type='text/javascript'>
		 parent.tc_target_td.attr('data-no', '{$data_no}');
		 </script>";
	}

	echo "<script>
	parent.image_upload_close('{$new_filename}');
	parent.black_back_close();
	</script>";
}

include_once(G5_PATH.'/tail.sub.php');