(function($)
{
	$(window).on('load', function()
	{
		$.fn.set_center = function()
		{
			$(this).css({
				'left' : (($(window).width() / 2) - ($(this).width() / 2)) + 'px',
				'top' : (($(window).height() / 2) - ($(this).height() / 2)) + 'px'
			});
		};

		$.getScript(url_gsc_plugin + '/js/event.js', function()
		{
			$('div.memo_notifi span.title').live('dblclick', function(e)
			{
				var memo_notifi = $(this).parents('div.memo_notifi:first');

				if (memo_notifi.attr('is_full'))
				{
					memo_notifi.removeAttr('is_full');
					memo_notifi.css({
						'width' : '',
						'height' : '',
						'left' : memo_notifi.attr('old_left') + 'px',
						'top' : memo_notifi.attr('old_top') + 'px'
					});

					memo_notifi.removeAttr('old_left old_top');
					memo_notifi.find('span.content').css('height', '');
				}
				else
				{
					memo_notifi
						.attr('old_left', parseInt(memo_notifi.css('left')))
						.attr('old_top', parseInt(memo_notifi.css('top')));

					memo_notifi.attr('is_full', 'true');
					memo_notifi.css({
						'width' : '100%',
						'height' : $(window).height() + 'px',
						'left' : '0',
						'top' : '0'
					});

					memo_notifi.find('span.content').css('height', ($(window).height() - memo_notifi.find('span.title').height()) + 'px');
				}
			});

			$('div.memo_notifi a.btn_close').live('click', function(e)
			{
				var memo_notifi = $(this).parents('div.memo_notifi:first');
				var zidx = parseInt(memo_notifi.css('z-index'));

				$('div.memo_notifi').not(memo_notifi).each(function()
				{
					var tmp_notifi = $(this);
					var tmp_zidx = parseInt(tmp_notifi.css('z-index'));

					if (zidx < tmp_zidx)
						tmp_notifi.css('z-index', (tmp_zidx - 1));
				});

				$("line.line" + memo_notifi.attr('div_number')).remove();
				memo_notifi.remove();
			});

			$('div.layers_box span a.btn_close').on('click', function(e)
			{
				var div_obj = $(this);

				// 버튼 주위 클릭 시
				if (!div_obj.hasClass('btn_close'))
					return _falseEvent(e);

				div_obj.parents('div.layers_box:first').css('display', 'none');

				if (div_obj.attr('id') == 'timeline_body')
					timeline_close();

				black_back_close();
			});

			$('div#calendar_div_contents').on('touchstart', function(e)
			{
				cxx = e.originalEvent.targetTouches[0].clientX;
			});

			$('div#calendar_div_contents').on('touchend', function(e)
			{
				var xx = e.originalEvent.changedTouches[0].clientX;

				if (is_page_mode == false)
				{
					if (cxx - 100 > xx) {
						is_page_mode = '-';
					} else if (cxx + 100 < xx) {
						is_page_mode = '+';
					}

					/* 실행 */
					is_page_mode = false;
				}
			});

			$('input#gongsu_cancel').live('click', function(e)
			{
				if(confirm('근태설정을 해제 하시겠습니까?'))
				{
					gongsu_form.find('input[name=type]').attr('value', '-1');
					gongsu_form.find('input[name=date]').attr('value', tc_target_td.attr('data-date'));

					var formData = gongsu_form.find('form:first').serialize();

					$.post(url_gsc_plugin + '/gongsu.update.php', formData, function(data)
					{
						location.reload();
					}, 'json');
				}
			});

			// --------------------------------------------------------------------------------------------------------------
			// ■■■■■■■■■■■■■■ li 메뉴 클릭
			// --------------------------------------------------------------------------------------------------------------
			$('ul.td_menus > li').live('click', function(e)
			{
				var target_li = $(this);

				if (target_li.attr('number') == null)
					return _falseEvent(e);

				var data_no = parseInt(tc_target_td.attr('data-no'));
				var menu_number = parseFloat(target_li.attr('number'));
				var target_li_parent = target_li.parent();
				var target_sub_menus = $('div.td_sub_menus ul.td_sub_menus' + menu_number);

				// 서브메뉴 열기
				if (target_li_parent.hasClass('td_menus') && target_sub_menus.length)
				{
					target_li_parent.find('ul[temp=true]').remove();

					if (target_sub_menus.length)
					{
						var f = tc_target_td.find('div.att');
						target_sub_menu = target_sub_menus.clone();

						if (menu_number == 10)
						{
							gongsu_form = target_sub_menu;

							if (f.hasClass('att1') || f.hasClass('att2') || f.hasClass('att3'))
							{
								gongsu_form.find('td.gongsu_btn_area').append($(" <input type='button' id='gongsu_cancel' value='설정해제 →' />"));
							}

							var gongsu_type_number = parseInt(gongsu_form.find('.gongsu_type_btn:first').attr('number'));

							gongsu_calculate(gongsu_type_number);
							gongsu_form.find('input[name=date]').val(tc_target_td.attr('data-date'));
							gongsu_form.find('input[name=type]').val(gongsu_type_number);
						}

						target_li.after(target_sub_menu);
						$('div.menu_body').set_center();

						if (data_no > 0) {
							gongsu_form.find('input.gongsu_type_btn[number=' + tc_target_td.attr('data-att-type') + ']').click();
						}
					}
				}
				else
				{
					// 서브메뉴 클릭
					if (target_li_parent.hasClass('td_sub_menu'))
					{
						// 근태설정
						if (target_li_parent.hasClass('td_sub_menus10'))
						{
						}
					}
					// 서브메뉴 없는 클릭
					else
					{
						// 메모장
						switch(menu_number)
						{
							// 메모장
							case 20 :
								$('form#memo_update').find('input[name=date]').val(tc_target_td.attr('data-date'));

								memo_open();
								break;

							// 가계부
							case 40 :
								break;

							// 일정관리
							case 50 :
								break;

							// 타임라인
							case 60 :
								timeline_open();
								break;

							// 갤러리
							case 70 :
								gallery_open();
								break;

							case 90 :
								is_text_play = true;

								func_speak(tc_target_td.find('span.cc_content').text(), {
									rate: 1,
									pitch: 1.0,
									lang: 'ko-KR'
								});

								break;

							// 음석 인식 60초
							case 100 :
								speak_memo_target = 'recognition_box';

								recognition_upload_open();
								startSpeechRecognition();
								break;

							// 메모장
							case 110 :
								$('form#one_memo_update').find('input[name=date]').val(tc_target_td.attr('data-date'));

								one_memo_open();
								break;

							default :
								break;
						}

                        td_menus_close();
					}
				}
			});

			$('ul.td_sub_menu > li').live('click', function(e)
			{
				var data_no = parseInt(tc_target_td.attr('data-no'));
				var target_li = $(this);
				var menu_number = parseFloat(target_li.attr('number'));

				// 근태설정 클릭
				if ($(e.target).parents('ul.td_sub_menus10:first').length)
				{
				}
				else if ($(e.target).parents('ul.td_sub_menus30:first').length)
				{
					if (menu_number == 10) // 사진찍기
					{
						$('form#camera-form').find('input[name=date]').val(tc_target_td.attr('data-date'));
						camera_open();
					}
					else if (menu_number == 20) // 사진업로드
					{
						$('form#upload-form').find('input[name=date]').val(tc_target_td.attr('data-date'));
						$('input#uploader').trigger('click');
						obj_display('div.black_back', 'none');
					}

					td_menus_close();
				}
			});

			// 공수유형클릭
			$('input.gongsu_type_btn').live('click', function(e)
			{
				var data_no = parseInt(tc_target_td.attr('data-no'));
				var target_input = $(this);
				var type_number = parseFloat(target_input.attr('number'));

				target_input.parent().find('input').removeClass('selected');
				target_input.addClass('selected');

				gongsu_form.find('input[name=date]').val(tc_target_td.attr('data-date'));
				gongsu_form.find('input[name=type]').val(type_number);

				if (type_number == 1 || type_number == 3) {
					gongsu_calculate(type_number);
				} else {
					gongsu_form.find('tbody').css('display', 'none');
				}

				$('div.menu_body').set_center();
			});

			// 공수클릭
			$('input.gongsu_per_btn').live('click', function(e)
			{
				var data_no = parseInt(tc_target_td.attr('data-no'));
				var target_input = $(this);

				target_input.parent().find('input').removeClass('selected');
				target_input.addClass('selected');

				gongsu_form.find('input[name=job_price_per]').val(target_input.val());
				var type_number = parseInt(gongsu_form.find('input.gongsu_type_btn.selected').attr('number'));

				if (type_number == 1 || type_number == 3) {
					disp_gongsu_total();
				}
			});

			// 공수 업데이트
			$('input#gongsu_form_submit').live('click', function(e)
			{
				var formData = $(this).parents('form:first').serialize();

				$.post(url_gsc_plugin + '/gongsu.update.php', formData, function(data)
				{
					location.reload();
				}, 'json');
			});

			$('input.gongsu_minus, input.gongsu_plus').live('touchstart', function(e)
			{
				var obj = this;
				gongsu_per_calculate(obj);
				disp_gongsu_total();

				gongsu_timeout = setTimeout(function()
				{
					gongsu_interval = setInterval(function()
					{
						gongsu_per_calculate(obj);
						disp_gongsu_total();
					}, 200);
				}, 500);
			});

			$('input.dan_minus, input.dan_plus').live('touchstart', function(e)
			{
				var obj = this;
				gongsu_price_calculate(obj);
				disp_gongsu_total();

				gongsu_timeout = setTimeout(function()
				{
					gongsu_interval = setInterval(function()
					{
						gongsu_price_calculate(obj);
						disp_gongsu_total();
					}, 200);
				}, 500);
			});

			$('input.gongsu_minus, input.gongsu_plus, input.dan_minus, input.dan_plus').live('click', function(e)
			{
				clearTimeout(gongsu_timeout);
				clearInterval(gongsu_interval);
			});
			// --------------------------------------------------------------------------------------------------------------
			// ■■■■■■■■■■■■■■ 검은 배경 클릭
			// --------------------------------------------------------------------------------------------------------------
			$('div.black_back').on('click', function(e)
			{
				if (is_fileupload || is_voice_start)
					return false;

				memo_close();
				file_explan_close();
				one_memo_close();
				setting_panel_close();
				td_menus_close();
				recognition_box_close();
				worker_list_close();
				timeline_close();
				gallery_close();
				modify_info_close();
				black_back_close();

				obj_display('div#timeline_body, div#modify_info_body', 'none');

				if (speechMsg != null) {
					window.speechSynthesis.cancel();
					speechMsg = null;
				}

				gongsu_form = null;
				tc_target_td = null;
			});

			$('a#a_setting').on('click', function(e)
			{
				black_back_open();
				setting_panel_open();

				return false;
			});

			$('div#controll_panel a').on('click', function(e)
			{
				return false;
			});

			$('form#memo_update').on('submit', function()
			{
				if(document.getElementById('wr_content').value == '')
				{
					alert('메모를 입력해주세요.');
					return false;
				}

				return true;
			});

			$('form#one_memo_update').on('submit', function(e)
			{
				var obj_input_text = $(this).find('input.content');

				if (obj_input_text.val() == '')
				{
					alert('내용을 입력하세요.');
					obj_input_text.foucs();
					return _falseEvent(e);
				}

				recognition_box_close();
				black_back_close();
			});

			$('table.calendar_table').find('td.td_select').on('touchstart', function(e)
			{
				ts_target_td = $(this);

				cx = e.originalEvent.targetTouches[0].clientX;
				cy = e.originalEvent.targetTouches[0].clientY;

				td_select_settime = setTimeout(function()
				{
					is_stay_open = true;
					speak_memo_target = 'one_memo_content';

					var f = $('form#one_memo_update');
					f.find('input[name=date]').val(ts_target_td.attr('data-date'));

					black_back_open();
					recognition_upload_open();
					startSpeechRecognition();

					is_true = false;
					is_touchstart = false;
					ts_target_td = null;
				}, 1000);

				is_touchstart = true;

				$('font.title_date').text(ts_target_td.attr('data-date'));
			});

			$('table.calendar_table').find('td.td_select').on('click', function(e)
			{
				clearTimeout(td_select_settime);

				tc_target_td = $(this);

				black_back_open();
				td_menus_open();

				is_true = false;
				is_touchstart = false;
				ts_target_td = null;
			});

			$('div.memo_notifi').live('touchstart', function(e)
			{
				var this_notifi = $(this);
				var event_target = $(e.target);

				if (event_target.hasClass('btn_close'))
					return _falseEvent(e);

				var zidx = parseInt(this_notifi.css('z-index'));

				$('div.memo_notifi').not(this_notifi).each(function()
				{
					var tmp_notifi = $(this);
					var tmp_zidx = parseInt(tmp_notifi.css('z-index'));

					if (zidx < tmp_zidx)
						tmp_notifi.css('z-index', (tmp_zidx - 1));
				});

				this_notifi.css('z-index', (notifi_default_zidx + $('div.memo_notifi').length));
			});

			$('div.memo_notifi span.title').live('touchstart', function(e)
			{
				var event_target = $(e.target);

				if (event_target.hasClass('btn_close'))
					return _falseEvent(e);

				target_notifi = $(this).parents('div.memo_notifi:first');

				cx = e.originalEvent.targetTouches[0].clientX;
				cy = e.originalEvent.targetTouches[0].clientY;

				target_notifi.attr('x', parseInt(target_notifi.css('left')));
				target_notifi.attr('y', parseInt(target_notifi.css('top')));

				target_notifi.addClass('alpha');
			});

			$('div.memo_notifi span.content a').live('touchstart', function(e)
			{
				ts_target_a = this;
				is_del_img = true;

				cx = e.originalEvent.targetTouches[0].clientX;
				cy = e.originalEvent.targetTouches[0].clientY;
			});

			// 터치 이미지 삭제
			$('div.memo_notifi span.content a').live('touchend', function(e)
			{
				var xx = e.originalEvent.changedTouches[0].clientX;
				var yy = e.originalEvent.changedTouches[0].clientY;
				var is_x_pos = cx - temp_nn >= xx || cx + temp_nn <= xx;

				if (
					is_x_pos &&
					is_del_img == true
				)
				{
					if (confirm('삭제하시겠습니까?'))
					{
						var f = $('form#file-del-form');
						var number = $(this).parents('div.memo_notifi:first').attr('div_number');
						var tmp_target_td = $("table.calendar_table tbody tr td[data-no=" + number + "]");

						f.find('input[name=date]').val(tmp_target_td.attr('data-date'));
						f.find('input[name=number]').val($(this).attr('data-number'));
						f.submit();

						$(ts_target_a).remove();

						var target_p = tmp_target_td.find('p.files');
						var files = target_p.attr('files').split(',');

						files[$(this).attr('data-number')] = '';

						target_p.attr('files', files.join(','));

						if (!$(this).parent().find('a.content-img').length)
						{
							target_p
								.removeClass('files')
								.text('');

							tc_target_td.attr('data-is-timeline', '0');
						}
					}

					ts_target_a = null;
					is_del_img = false;
				}
			});

			var input_camera = document.querySelector('#camera');

			$(input_camera).change(function(e)
			{
				text_upload_type = 'camera-form';
				file_explan_open();

				if (is_camera_down)
				{
					var arr = String($('#camera').val()).split("\\");

					const link = document.createElement("a");
					link.href = URL.createObjectURL(e.target.files[0]);
					link.download = arr[arr.length - 1]; //파일명
					link.click();
				}
			});

			$('div.filename_content input.speak_memo_btn').on('click', speak_memo_open);
			$('div.one_memo_content input.speak_memo_btn').on('click', speak_memo_open2);

			// 파일 설명 입력
			$('div.filename_content input.submit_btn').on('click', function(e)
			{
				var fc = $('div.filename_content');
				var f = $('form#' + text_upload_type);
				f.find('input[name=text]').attr('value', fc.find('input[name=content]').val());
				fc.find('input[name=content]').val('').blur();

				setTimeout(function()
				{
					f.submit();

					image_upload_open();

					is_fileupload = true;
					file_explan_close();
				}, 300);
			});

			$('#uploader').change(function(e)
			{
				file_explan_open();
				text_upload_type = 'upload-form';
			});

			$('input#recognition_submit').on('click', function(e)
			{
				is_voice_start = false;

				var f = $('form#one_memo_update');
				f.find('input[name=date]').val(tc_target_td.attr('data-date'));
				f.find('input[name=content]').attr('value', $('div#recognition_text').text());
				f.submit();
			});

			$('input#recognition_cancel').on('click', function(e) // 음성메모 해제
			{
				is_voice_start = false;

				recognition_box_close();
				black_back_close();
			});

			$('div.recognition_upload').on('click', function(e) // 업로드 보이기
			{
				recognition.stop();
				clearTimeout(settime);
				spechend();
			});

			$('a#user_info_modify').on('click', function(e) // 정보수정 보이기
			{
				setting_panel_close();
				modify_info_open();
			});

			$(window).on('touchmove', function(e)
			{
				var xx = e.originalEvent.targetTouches[0].clientX;
				var yy = e.originalEvent.targetTouches[0].clientY;

				var is_x_pos = cx - temp_n >= xx || cx + temp_n <= xx;
				var is_y_pos = cy - temp_n >= yy || cy + temp_n <= yy;

				// 1초 터치 스타트 후 음성메모 바로 출력 해제
				if (is_touchstart && (is_x_pos || is_y_pos))
				{
					clearTimeout(td_select_settime);
				}

				// 상하 터치 무브 창 생성
				if (
					is_y_pos && // 상하 터치 이동 수치 체크
					is_touchstart == true && // 최초 터치
					notifi_div == null && // 레이어 창 없으면
					is_true == false // 생성
				)
				{
					var target_memo_p = ts_target_td.find('p.memo');
					var target_files_p = ts_target_td.find('p.files');

					if (!$('div[div_number=' + ts_target_td.attr('data-no') + ']').length && (target_memo_p.length || target_files_p.length))
					{
						notifi_div = $("<div class='memo_notifi touch_none alpha' div_number='" + ts_target_td.attr('data-no') + "'><div class='memo_notifi_in'><span class='title'>" + ts_target_td.attr('data-date') + "<a href='#' class='btn_close'>✘</a></span><span class='content'>" + ts_target_td.find('span.cc_content').text().replace(/\n/g, "<br />") + "</span></div></div>");

						if (target_files_p.length)
						{
							var files = target_files_p.attr('files').split(',');

							for(var i=0; i<files.length; i++)
							{
								if (files[i] != '')
								{
									files[i] = String(files[i]).split('|');

									var file_path = calendar_data_url + '/' + files[i][0];
									notifi_div.find('span.content').append($("<a class='content-img' href='" + file_path + "' data-number='" + i + "' target='_blank'><img width='100%' src='" + file_path + "' /></a>"));
								}
							}
						}

						$('body').append(notifi_div);

						if (notifi_default_zidx == null)
							notifi_default_zidx = parseInt(notifi_div.css('z-index'));

						notifi_div.css('z-index', (notifi_default_zidx + $('div.memo_notifi').length));

						var newLine = document.createElementNS('http://www.w3.org/2000/svg','line');
						newLine.setAttribute('class','line' + ts_target_td.attr('data-no'));
						newLine.setAttribute("stroke", "#ff0000");
						$("svg").append(newLine);
					}

					is_true = true;
				}

				// 터치 스타트 창 움직임
				if (notifi_div)
				{
					var tx = xx - (notifi_div.width() / 2);
					var ty = yy - (notifi_div.height() / 2);

					if (tx <= 0) tx = 0;
					if (ty <= 0) ty = 0;

					if ((tx + notifi_div.width()) > $(window).width()) tx = $(window).width() - notifi_div.width();
					if ((ty + notifi_div.height()) > $(window).height()) ty = $(window).height() - notifi_div.height();

					notifi_div.css({
						'left' : tx + 'px',
						'top' : ty + 'px'
					});

					var target_p = ts_target_td.find('p.memo').length ? ts_target_td.find('p.memo') : ts_target_td.find('p.files') ;
					var p_os = target_p.offset();
					var d_os = notifi_div.offset();

					$('line.line' + ts_target_td.attr('data-no'))
						.attr('x1', parseInt(p_os.left))
						.attr('y1', parseInt(p_os.top))
						.attr('x2', parseInt(d_os.left))
						.attr('y2', parseInt(d_os.top));
				}

				// 터치 스타트 창 움직임
				if (target_notifi && target_notifi.hasClass('alpha') && !target_notifi.attr('is_full'))
				{
					var xxx = (parseInt(target_notifi.attr('x')) + (xx - cx));
					var yyy = (parseInt(target_notifi.attr('y')) + (yy - cy));

					if (xxx <= 0) xxx = 0;
					if (yyy <= 0) yyy = 0;

					if ((xxx + target_notifi.width()) > $(window).width()) xxx = $(window).width() - target_notifi.width();
					if ((yyy + target_notifi.height()) > $(window).height()) yyy = $(window).height() - target_notifi.height();

					target_notifi.css({
						'left' : xxx + 'px',
						'top' : yyy + 'px'
					});

					var tmp_target_td = $('table.calendar_table tbody').find('td[data-no=' + target_notifi.attr('div_number') + ']');

					var target_p = tmp_target_td.find('p.memo').length ? tmp_target_td.find('p.memo') : tmp_target_td.find('p.files') ;

					$('line.line' + tmp_target_td.attr('data-no'))
						.attr('x1', parseInt(target_p.offset().left))
						.attr('y1', parseInt(target_p.offset().top))
						.attr('x2', parseInt(target_notifi.offset().left))
						.attr('y2', parseInt(target_notifi.offset().top));
				}
			});
		});
	});
})(jQuery);