function func_speak(text, opt_prop) // 음성 읽기 출력
{
	window.speechSynthesis.cancel(); // 현재 읽고있다면 초기화

	var prop = opt_prop || {};

	speechMsg = new SpeechSynthesisUtterance();
	speechMsg.rate = prop.rate || 1; // 속도: 0.1 ~ 10
	speechMsg.pitch = prop.pitch || 1; // 음높이: 0 ~ 2
	speechMsg.lang = prop.lang || "ko-KR";
	speechMsg.text = text;

	speechMsg.addEventListener("end", (event) =>
	{
		black_back_close();
	});

	window.speechSynthesis.speak(speechMsg);
}

function obj_display(selctors, prop_name, add_func)
{
	var tmp_arr = String($.trim(selctors)).split(',');

	if (tmp_arr.length)
	{
		var objs = [];

		for(var i=0; i<tmp_arr.length; i++)
		{
			objs[i] = $($.trim(tmp_arr[i]));
			objs[i].css('display', prop_name);

			if (typeString(add_func) == 'array' && typeString(add_func[i]) == 'function') {
				add_func[i]();
			}
		}
	}
	else
	{
		var obj = $($.trim(selctors));
		obj.css('display', prop_name);

		if (typeString(add_func) == 'function') {
			add_func();
		}
	}
}

function image_upload_open() // 이미지 업로드 이미지 오픈
{
	var iu = $('div.image_upload');

	iu.css('display', 'block');
	iu.set_center();
}

function black_back_open() // 검은 배경 오픈
{
	var bb = $('div.black_back');

	bb.css('height', $(window).height() + 'px');
	bb.css('display', 'block');
}

function camera_open() // 카메라 오픈
{
	$('input#camera').trigger('click');
	obj_display('div.black_back', 'none');
}

function setting_panel_open() // 세팅 패널 오픈
{
	var cp = $('div.controll_panel');
	cp.css('display', 'block');
}

function black_back_close()
{
	var bb = $('div.black_back');
	bb.css('display', 'none');
}

image_upload_close = function(new_file)
{
	var iu = $('div.image_upload');
	var target_p = tc_target_td.find('p.files_p');

	if (!target_p.hasClass('files') && iu.css('display') == 'block')
	{
		target_p.addClass('files');
		target_p.text('🖼');
	}

	tc_target_td.attr('data-is-timeline', '1');

	var files = target_p.attr('files') != '' ? target_p.attr('files').split(',') : [];
	files.push(new_file);

	target_p.attr('files', files.join(','));

	is_fileupload = false;
	iu.css('display', 'none');
}

image_upload_error_close = function()
{
	var iu = $('div.image_upload');

	iu.css('display', 'none');
	is_fileupload = false;
}

function setting_panel_close()
{
	var cp = $('div.controll_panel');
	cp.css('display', 'none');
}

// 한줄 메모 오픈
function one_memo_open()
{
	var omc = $('div.one_memo_content');
	var f = omc.find('form')
	f.get(0).reset();
	f.find('input[name=content]').attr('value', '');
	omc.set_center();
	omc.css('display', 'block');

	f.find('input[name=content]').click();
	f.find('input[name=content]').focus();
}

one_memo_close = function(is_write)
{
	var omc = $('div.one_memo_content');

	if (tc_target_td != null && omc.css('display') == 'block' && typeString(is_write) == 'number')
	{
		var tmp_p = tc_target_td.find('p.memo_p');

		if (is_write == 1)
		{
			tmp_p.addClass('memo');
			tmp_p.text('📄');
			tc_target_td.attr('data-is-timeline', '1');
		}
	}

	omc.css('display', 'none');
}

// 메모 오픈
function memo_open()
{
	var mc = $('div.memo_content');
	mc.set_center();

	var data = {'date' : mc.find("form:first input[name='date']").val()};

	$.post(url_gsc_plugin + '/get_cc_content.php', data, function(html)
	{
		$('div.memo_content').find('textarea[name=cc_content]').html(html);
		mc.css('visibility', 'visible');
	}, 'html');
}

memo_close = function(is_write)
{
	var mc = $('div.memo_content');

	if (tc_target_td != null && mc.css('display') == 'block' && typeString(is_write) == 'number')
	{
		var tmp_p = tc_target_td.find('p.memo_p');

		tmp_p.removeClass('memo');
		tmp_p.text('');

		if (is_write == 1)
		{
			tmp_p.addClass('memo');
			tmp_p.text('📄');
		}
	}

	$('div.memo_content').find('textarea[name=cc_content]').html('');
	mc.css('visibility', 'hidden');
}

function startSpeechRecognition()
{
	is_voice_start = true;

	recognition.addEventListener("result", (event) =>
	{
		is_voice_start = false;

		clearTimeout(settime);
		recognition_upload_close();

		if (speak_memo_target == 'recognition_box')
		{
			var rb = $('div.recognition_box');
			rb.find('div.recognition_text').text(event.results[0][0].transcript);

			rb.css('display', 'block');
			rb.set_center();
			rb.css('visibility', 'visible');
		}
		else if (speak_memo_target == 'filename_content')
		{
			file_explan_open();
			$('div.filename_content').find('input.content').val(event.results[0][0].transcript);
		}

		else if (speak_memo_target == 'one_memo_content')
		{
			one_memo_open();
			$('div.one_memo_content').find('input.content').val(event.results[0][0].transcript);

			is_stay_open = false;
		}
	});

	recognition.start();

	settime = setTimeout(function()
	{
		recognition.stop();
		spechend();
	}, recognition.maxAlternatives * 1000);
}

// 음성 로딩 이미지 오픈
function recognition_upload_open()
{
	var ru = $('div.recognition_upload');

	ru.set_center();
	ru.css('display', 'block');
}

function recognition_upload_close()
{
	var ru = $('div.recognition_upload');
	ru.css('display', 'none');
}

function recognition_box_close()
{
	var rb = $('div.recognition_box');
	rb.css('display', 'none');
	rb.css('visibility', 'hidden');
}

function spechend()
{
	recognition_upload_close();
	recognition_box_close();
	black_back_close();

	is_voice_start = false;
}

// 파일 설명
function file_explan_open()
{
	var fc = $('div.filename_content');
	fc.set_center();

	black_back_open();
	fc.css('display', 'block');
	fc.find('input.content').focus();
}

function file_explan_close()
{
	var fc = $('div.filename_content');
	fc.css('display', 'none');
	text_upload_type = '';
}

// 작업자 관리 오픈
function worker_list_open()
{
	var wl = $('div.worker_list');
	wl.set_center();
	wl.css('display', 'block');
}

function worker_list_close()
{
	var wl = $('div.worker_list');
	wl.css('display', 'none');
}

// 타임라인 오픈
function timeline_open()
{
	var date_text = tc_target_td.attr('data-date').replace(/[^0-9]/gi, '');

	var tb = $('div#timeline_body');
	var height = parseInt((($(window).height() / 100) * 90));
	tb.css('height', height + 'px');
	tb.set_center();
	tb.find('iframe').attr('src', tb.find('iframe').attr('tmp_src') + '?date=' + date_text);
	tb.css('display', 'block');
	tb.find('iframe').css('height', ((height - tb.find('span').height()) - 6) + 'px');
}

// 타임라인 닫기
function timeline_close()
{
	var tb = $('div#timeline_body');
	tb.find('iframe').attr('src', '');
}

// 갤러리 오픈
function gallery_open()
{
	var gall_box = $('div#gallery_content');
	gall_box.find('tr').remove();
	gall_box.css('display', 'block');

	var height = parseInt((($(window).height() / 100) * 90));
	gall_box.css('height', height + 'px');
	gall_box.set_center();

	var onload_count = 0;
	var files_count = 0;
	var files_obj = tc_target_td.find('p.files');

	if (files_obj.length)
	{
		var files = files_obj.attr('files').split(',');
		var files_count = 0;

		for(var i=0; i<files.length; i++)
		{
			if (files[i] != '')
			{
				files[i] = String(files[i]).split('|');

				var file_path = calendar_data_url + '/' + files[i][0];
				var obj_td = $("<td align='center' valing='middle'><a class='content-img' href='" + file_path + "' data-number='" + i + "' target='_blank'><img src='" + file_path + "' /></a></td>");

				obj_td.find('img').bind('load', function()
				{
					onload_count++;

					if (files_count == onload_count)
					{
						setTimeout(function()
						{
							gall_box.find('img').each(function()
							{
								var img = new Image();
								img.src = $(this).attr('src');

								if (img.width > img.height)
									$(this).attr('width', '90%');
								else
									$(this).attr('height', '90%');

								gall_box.find('td').each(function()
								{
									if (!$(this).attr('height'))
									{
										$(this).attr('height', $(this).prop('offsetWidth'));
										$(this).css('visibility', 'visible');
									}
								});
							});
						}, 1);
					}
				});

				if (files_count % 3 == 0)
					gall_box.find('table:first').append($('<tr></tr>'));

				gall_box.find('tr:last').append(obj_td);
				files_count++;
			}
		}

		if (files_count && files_count % 3 > 0)
			for(var i=files_count%3; i<3; i++)
				gall_box.find('tr:last').append($("<td></td>"));
	}
	else
		alert('갤러리가 없습니다.');
}

// 타임라인 오픈
function gallery_close()
{
	var gc = $('div#gallery_content');
	gc.css('display', 'none');
}

// 정보수정 오픈
function modify_info_open()
{
	var mi = $('div#modify_info_body');
	var height = parseInt((($(window).height() / 100) * 90));
	mi.css('height', height + 'px');
	mi.set_center();

	mi.find('iframe').attr('src', mi.find('iframe').attr('tmp_src') + '&pa=' + md5_page_access);
	mi.css('display', 'block');

	mi.find('iframe').css('height', ((height - mi.find('span').height()) - 6) + 'px');
}

// 정보수정 닫기
function modify_info_close()
{
	var mi = $('div#modify_info_body');
	mi.find('iframe').attr('src', '');
}

function disp_float(num)
{
	var number = parseFloat(num);

	if (String(number).indexOf('.') == -1)
		number = String(number) + '.0';

	return number;
}

// 공수 계산
function gongsu_calculate(type_number)
{
	var data_no = parseInt(tc_target_td.attr('data-no'));
	var default_type_number = parseInt(tc_target_td.attr('data-att-type'));

	if (type_number == 1 || type_number == 3)
	{
		gongsu_form.find('tbody').css('display', '');
		gongsu_form.find('input.gongsu_per_btn').removeClass('selected');

		var job_pay = default_job_pay;
		var job_price_per = '1.0';

		if (data_no > 0)
		{
			if (default_type_number > 0)
			{
				job_pay = parseInt(tc_target_td.attr('data-price2'));
				job_price_per = tc_target_td.attr('data-price-per');
			}
			else
			{
				job_pay = default_job_pay;
				job_price_per = '1.0';
			}

			if (default_type_number == 1 && type_number == 3)
			{
				job_price_per = '0.5';
			}
			else if (default_type_number == 2)
			{
				job_pay = default_job_pay;

				if (type_number == 1)
					job_price_per = '1.0';
				else if (type_number == 3)
					job_price_per = '0.5';
			}
			else if (default_type_number == 3 && type_number == 1)
			{
				job_price_per = '1.0';
			}
		}

		if ((data_no > 0 && default_type_number == 0) || type_number == 1 || type_number == 3)
		{
			gongsu_form.find("input.gongsu_per_btn[value='" + job_price_per + "']").addClass('selected');
			gongsu_form.find('input[name=job_price2]').val($.number(job_pay));
			gongsu_form.find('input[name=job_price_per]').val(job_price_per);
			disp_gongsu_total();
		}
	}
}

function disp_gongsu_total()
{
	var price = String(gongsu_form.find('input[name=job_price2]').val()).replace(/[^0-9]/g, '');
	var per = parseFloat(String(gongsu_form.find('input[name=job_price_per]').val()));

	var total_price = price * per;

	$('font.disp_gongsu_total').text($.number(total_price) + '원');

	setTimeout(disp_gongsu_total, 100);
}

function td_menus_open() // td 메뉴 오픈
{
	var mb = $('div.menu_body');
	var at = $('ul.td_menus');

	at.find('li').css('background-color', '');

	at.children('li:first').html("<span>" + tc_target_td.attr('data-date') + "<span>");

	if (tc_target_td.find('font.holis').length)
	{
		for(var i=0; i<tc_target_td.find('font.holis').length; i++)
		{
			var tmp_font = $("<font class='holis'></font>");
			var tatget_font = tc_target_td.find('font.holis').eq(i);

			if (tatget_font.hasClass('holi_day'))
				tmp_font.addClass('holi_day');

			tmp_font.text(tatget_font.attr('full_name'));
			at.children('li:first').append(tmp_font);
		}
	}

	var f = tc_target_td.find('div.att');

	if (tc_target_td.attr('data-is-timeline') == '1') {
		at.append('<li number="60" temp="true">⏳ <font class="menu_title">타임라인(작업일지)</font></li>');
	}

	if (tc_target_td.find('p.files').length) {
		at.append('<li number="70" temp="true">🖼 <font class="menu_title">갤러리</font></li>');
	}

	if (tc_target_td.attr('data-is-content') == '1') {
		at.append('<li number="90" temp="true">🔊 <font class="menu_title">메모 음성듣기</font></li>');
	}

	mb.css('display', 'block');
	mb.set_center();

	mb.css('visibility', 'visible');
}

function td_menus_close()
{
    var mb = $('div.menu_body');
	var at = $('ul.td_menus');

	at.find('li[temp=true]').remove();
	at.find('ul[temp=true]').remove();

	mb.css('display', 'none');
	mb.css('visibility', 'hidden');
}

function gongsu_price_calculate(obj)
{
	var btn_obj = $(obj);
	var input_obj = btn_obj.parent('td:first').find('input.number_obj');
	var str = typeString(input_obj.val()) == 'undefined' ? 0 : input_obj.val().replace(/[^0-9]/g, '');
	var num = parseInt(str);

	if (btn_obj.attr('value') == '-') {
		num -= 5000;
	} else {
		num += 5000;
	}

	input_obj.attr('value', $.number(String(num)));
}

function gongsu_per_calculate(obj)
{
	if (typeString(obj) == 'object')
	{
		var btn_obj = $(obj);
		var input_obj = btn_obj.parent('td:first').find('input.number_obj');
		var num = String(input_obj.val()).split('.');
		var num1 = parseInt(num[0]);
		var num2 = parseInt(num[1]);

		num2 = parseInt(num2) + (btn_obj.val() == '-' ? -1 : 1);

		if (num2 <= -1)
		{
			num1 -= 1;

			if (num1 == -1)
			{
				num1 = 0;
				num2 = 1;
			}
			else
				num2 = 9;
		}

		if (num2 >= 10)
		{
			num1 = parseInt(num1) + 1;
			num2 = 0;
		}

		if (num1 == 0 && num2 == 0)
		{
			num1 = 0;
			num2 = 1;
		}

		var str = String(num1) + '.' + String(num2);
		input_obj.attr('value', str);
	}
}

function speak_memo_open(e)
{
	speak_memo_target = 'filename_content';

	var fc = $('div.filename_content');
	fc.css('display', 'none');

	recognition_upload_open();
	startSpeechRecognition();
}

function speak_memo_open2(e)
{
	speak_memo_target = 'one_memo_content';

	var fc = $('div.one_memo_content');
	fc.css('display', 'none');

	recognition_upload_open();
	startSpeechRecognition();
}