<?php
include_once('./_common.php');

$_gsc->check_not_access();

$date = preg_replace("/([0-9]{4})([0-9]{2})([0-9]{2})/", "$1-$2-$3", ((int)$_GET['date']));

list($year, $month, $day) = explode('-', $date);

$_gsc->table_rename($year);

$cc_row = sql_fetch(" select * from `{$_gsc->db_calendar}` where user_id = '{$_gsc->session_user_id}' and cc_date = '{$year}-{$month}-{$day}' ");

$files = array();

if (isset($cc_row['cc_files']) && $cc_row['cc_files'])
	$files = array_filter(explode("\n", $cc_row['cc_files']));

$tl_row = sql_fetch(" select * from `{$_gsc->db_timeline}` where user_id = '{$_gsc->session_user_id}' and tl_date = '{$year}-{$month}-{$day}' ");

$contents = array();

if (isset($tl_row['tl_content']) && $tl_row['tl_content'])
	$contents = array_filter(explode("\n", $tl_row['tl_content']));

if (!count($files) && !count($contents))
{
	include_once(G5_PATH.'/head.sub.php');
	?>
	<script type="text/javascript">
	alert('작성된 타임라인이 없습니다.');
	parent.$('div.black_back').trigger('click');
	</script>
	<?php
	include_once(G5_PATH.'/tail.sub.php');
	exit;
}

include_once($_gsc->path_plugin . '/inc.member.check.php');

$g5['title'] = '작업자관리';

$icon_image = '🖼';
$icon_text = '📄';

include_once(G5_PATH.'/head.sub.php');
?>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Gothic+A1:wght@200&family=Noto+Sans+KR&display=swap" rel="stylesheet">
<link href="<?php echo $_gsc->url_plugin?>/css/timeline.css?ver=<?php echo time()?>" rel="stylesheet" />

<table width="100%" border="0" cellspacing="0" cellpadding="0">
<tbody>
<?php
foreach($files as $k => $v)
{
	$v = explode('|', $files[$k]);

	$times[] = $time = filemtime($_gsc->path_data . '/' . $v[0]);
	$lines[] = array(
		'key' => $k,
		'type' => 'image',
		'time' => $time,
		'url' => $_gsc->url_data . '/' . $v[0],
		'text' => base64_decode($v[1])
	);
}

foreach($contents as $k => $v)
{
	$v = explode('|', $contents[$k]);

	$times[] = $time = (int)$v[1];
	$lines[] = array(
		'key' => $k,
		'type' => 'text',
		'time' => $time,
		'text' => base64_decode($v[0])
	);
}

array_multisort($times, SORT_ASC, $lines);

foreach($lines as $k => $v)
{
?>
<tr data-type="<?php echo $v['type']=='image'?'image':'text'?>">
	<td class="time<?php if (date("Ymd", $v['time']) != $year.$month.$day){echo ' not_today ';}else{echo ' today ';}?>" valign="top"><?php
	if (date("Ymd", $v['time']) != $year.$month.$day)
		echo date("Y-m-d H:i", $v['time']);
	else
		echo date("H:i", $v['time']);
	?></th>
	<td class="kind <?php echo $v['type']?>" valign="top"><div class="line_cell"></div><div class="line_rows"></div><div
	class="circle touch_area"
	data-date="<?php echo $year?> <?php echo $month?> <?php echo $day?>"
	data-number="<?php echo $v['key'];?>"><font><?php echo $v['type']=='image'?$icon_image:$icon_text?></font></div></td>
	<td class="type <?php echo $v['type']?>"><span class="arrow1"></span><div><?php
	if ($v['type'] == 'image') {
		echo "<span><a href='{$v['url']}' target='_blank'><img src='{$v['url']}' width='100%' /><font>{$v['text']}</font></a></span>";
	} else if ($v['type'] == 'text') {
		echo $v['text'];
	}
	?></div></td>
</tr>
<?php } ?>
</tbody>
</table>

<script type="text/javascript">
(function($)
{
	$(window).on('load', function()
	{
		var sx, sy;
		var is_del = false;
		var ts_target = null;

		$('div.touch_area').on('touchstart', function(e)
		{
			sx = e.originalEvent.targetTouches[0].clientX;
			sy = e.originalEvent.targetTouches[0].clientY;

			ts_target = $(this);
			is_del = true;
		});

		$(window).on('touchend', function(e)
		{
			var x = e.originalEvent.changedTouches[0].clientX;
			var y = e.originalEvent.changedTouches[0].clientY;
			var is_x_pos = sx + 150 <= x;

			if (is_del == true && is_x_pos)
			{
				var target_table = ts_target.parents('table:first');
				var target_tr = ts_target.parents('tr:first');
				var tc_target_td = parent.tc_target_td;

				if (target_tr.attr('data-type') == 'image')
				{
					if (confirm('이미지를 삭제하시겠습니까??'))
					{
						var f = parent.$('form#file-del-form');

						f.find('input[name=date]').val(ts_target.attr('data-date'));
						f.find('input[name=number]').val(ts_target.attr('data-number'));
						f.submit();

						target_tr.remove();

						var target_p = tc_target_td.find('p.files');
						var files = target_p.attr('files').split(',');

						files[ts_target.attr('data-number')] = '';

						target_p.attr('files', files.join(','));

						if (!target_table.find("tr[data-type='image']").length)
						{
							target_p
								.removeClass('files')
								.text('');
						}
					}
				}
				else if (target_tr.attr('data-type') == 'text')
				{
					if (confirm('텍스트를 삭제하시겠습니까??'))
					{
						var f = parent.$('form#timeline-text-del-form');

						f.find('input[name=date]').val(ts_target.attr('data-date'));
						f.find('input[name=number]').val(ts_target.attr('data-number'));
						f.submit();

						target_tr.remove();
					}
				}

				if (!target_table.find('tr').length)
				{
					tc_target_td.attr('data-is-timeline', '0');
					alert('타임라인이 없습니다.');
					parent.$('div.black_back').trigger('click');
				}
			}

			ts_target = null;
			is_del = false;
		});
	});
})(jQuery);
</script>
<script type="text/javascript" src="<?php echo $_gsc->url_plugin?>/js/pageshow.js?ver=<?php echo time()?>"></script>

<?php
include_once(G5_PATH.'/tail.sub.php');