<!--코어{-->
<?php
// 포함된 페이지의 URL을 가져오기
function getIncludedPageURL() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $url = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    return $url;
}

// 인스타그램 공유 링크 생성
function getInstagramShareLink($url) {
    $caption = "캡션을 입력.";
    $instagramLink = "instagram://share?text=" . urlencode($caption) . "&url=" . urlencode($url);
    return $instagramLink;
}

// 페이스북 공유 링크 생성
function getFacebookShareLink($url) {
    $facebookLink = "https://www.facebook.com/sharer.php?u=" . urlencode($url);
    return $facebookLink;
}

// 트위터 공유 링크 생성
function getTwitterShareLink($url) {
    $twitterLink = "https://twitter.com/intent/tweet?url=" . urlencode($url);
    return $twitterLink;
}

// 텔레그램 공유 링크 생성
function getTelegramShareLink($url) {
    $telegramLink = "https://t.me/share/url?url=" . urlencode($url);
    return $telegramLink;
}

// 라인 공유 링크 생성
function getLineShareLink($url) {
    $message = "라인으로 공유합니다!";
    $lineLink = "https://social-plugins.line.me/lineit/share?url=" . urlencode($url) . "&text=" . urlencode($message);
    return $lineLink;
}

// 네이버 밴드 공유 링크 생성
function getNaverBandShareLink($url) {
    // 네이버 밴드에서는 "title" 파라미터를 추가하여 링크에 페이지의 제목을 포함시킬 수 있습니다.
    $pageTitle = "페이지의 제목을 입력하세요."; // 페이지 제목을 여기에 넣어주세요.
    $naverBandLink = "http://band.us/plugin/share?body=" . urlencode($url) . "&title=" . urlencode($pageTitle);
    return $naverBandLink;
}

// 서버의 URL 가져오기
function getPluginImagePath() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];

    // 포트 번호가 80(HTTP), 443(HTTPS)이 아닌 경우 포트 번호를 포함.
    $port = $_SERVER['SERVER_PORT'];
    $portSuffix = ($port !== 80 && $port !== 443) ? (":" . $port) : "";

    $url = $protocol . $host . $portSuffix . "/plugin/sns_share/img";
    return $url;
}

$pluginImagePath = getPluginImagePath();
$includedPageURL = getIncludedPageURL();
$instagramShareLink = getInstagramShareLink($includedPageURL);
$facebookShareLink = getFacebookShareLink($includedPageURL);
$twitterShareLink = getTwitterShareLink($includedPageURL);
$telegramShareLink = getTelegramShareLink($includedPageURL);
$lineShareLink = getLineShareLink($includedPageURL);
$naverBandShareLink = getNaverBandShareLink($includedPageURL);
?>
<!--}코어-->

<div id='sns'>
    <!-- URL 복사 -->
    <a href="javascript:void(0);" id="copyLink">
        <img src="<?= $pluginImagePath ?>/url.webp" alt="url 복사" width='50px' height='auto'/>
    </a>

    <a href="<?= $instagramShareLink ?>" target="_blank">
        <img src="<?= $pluginImagePath ?>/instagram.webp" alt="인스타그램 공유" width='45px' height='auto'/>
    </a>

    <a href="<?= $facebookShareLink ?>" target="_blank">
        <img src="<?= $pluginImagePath ?>/facebook.webp" alt="페이스북 공유" width='50px' height='auto'/>
    </a>

    <a href="<?= $twitterShareLink ?>" target="_blank">
        <img src="<?= $pluginImagePath ?>/twitter.webp" alt="트위터 공유" width='50px' height='auto'/>
    </a>

    <a href="<?= $telegramShareLink ?>" target="_blank">
        <img src="<?= $pluginImagePath ?>/telegram.webp" alt="텔레그램 공유" width='50px' height='auto'/>
    </a>

    <a href="<?= $lineShareLink ?>" target="_blank">
        <img src="<?= $pluginImagePath ?>/line.webp" alt="라인 공유" width='55px' height='auto'/>
    </a>

    <a href="<?= $naverBandShareLink ?>" target="_blank">
        <img src="<?= $pluginImagePath ?>/n_band.webp" alt="네이버 밴드 공유" width='50px' height='auto'/>
    </a>
</div>

<style>
    #sns img {margin-right:5px}
    #sns {border-top:2px solid #ddd;text-align:center;margin:5px}
</style>

<!--페이지 url 복사-->
<script>
    document.getElementById('copyLink').addEventListener('click', function() {
        var url = '<?= $includedPageURL ?>';

        var tempInput = document.createElement('input');
        tempInput.setAttribute('value', url);
        document.body.appendChild(tempInput);

        tempInput.select();
        document.execCommand('copy');
        document.body.removeChild(tempInput);

        alert('URL이 복사되었습니다.');
    });
</script>
<!--Provided by Tak2 / dsclub.kr-->
<!--본 플러그인은 상업적 이용이 가능합니다. 하지만 이미지 자체의 저작권은 각 아이콘 회사와 tak2에게 있습니다.-->
<!--아이콘 자체 제작-->
