<?php
/*************************************************************
 * SEO 설정
 *************************************************************/
define('G5_SEO_INDEXNOW_KEY', '');

/*************************************************************
 * 아래부터는 수정하지 마세요.
 *************************************************************/

if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가;

function kh_indexnow($board, $wr_id, $w, $qstr, $redirect_url)
{
	if($board['bo_read_level'] != 1) return;
	if($board['bo_use_search'] != 1) return;

	$api_key = G5_SEO_INDEXNOW_KEY;

	if(!$api_key)
	{
		if($dh = opendir(G5_PATH))
		{
			while(($file = readdir($dh)) !== false)
			{
				if(substr($file, -4, 4) != '.txt') continue;
				if(strlen($file) < 12 || strlen($file) > 132) continue;

				$text = substr($file, 0, -4);
				if(preg_match('/^[0-9a-fA-F-]+$/', $text) == 0) continue;
				if(file_get_contents(G5_PATH.'/'.$file) != $text)  continue;

				$api_key = $text;
			}
			closedir($dh);
		}
	}

	if($api_key)
	{
		$params = array(
			'url' => get_pretty_url($board['bo_table'], $wr_id),
			'key' => $api_key
		);

		$url = 'https://searchadvisor.naver.com/indexnow?'.http_build_query($params);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_exec($ch);
		curl_close($ch);
	}
}
add_event('write_update_after', 'kh_indexnow', G5_HOOK_DEFAULT_PRIORITY, 5);
