<?php
$sub_menu = "200830";
include_once('./_common.php');

auth_check($auth[$sub_menu], 'r');

$g5['title'] = '회원가입 통계';
include_once('./member_count.sub.php');

$colspan = 5;

$sql_common = " from {$g5['member_table']} ";
$sql_search = " where date(mb_datetime) between '{$fr_date}' and '{$to_date}' ";

$sql = " select count(*) as cnt
            {$sql_common}
            {$sql_search} ";
$row = sql_fetch($sql);
$total_count = $row['cnt'];

$rows = $config['cf_page_rows'];
$total_page  = ceil($total_count / $rows);  // 전체 페이지 계산
if ($page < 1) $page = 1; // 페이지가 없으면 첫 페이지 (1 페이지)
$from_record = ($page - 1) * $rows; // 시작 열을 구함

$sql = " select *
            {$sql_common}
            {$sql_search}
            order by mb_no desc
            limit {$from_record}, {$rows} ";
$result = sql_query($sql);

?>

<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> 목록</caption>
    <thead>
    <tr>
        <th scope="col">아이디</th>
        <th scope="col">이름</th>
        <th scope="col">닉네임</th>
        <th scope="col">이메일</th>
        <th scope="col">최종접속</th>
        <th scope="col">로그인IP</th>
        <th scope="col">접속IP</th>
        <th scope="col">가입일자</th>

    </tr>
    </thead>
    <tbody>
    <?php
    for ($i=0; $row=sql_fetch_array($result); $i++) {

        $bg = 'bg'.($i%2);
    ?>
    <tr class="<?php echo $bg; ?>">
        <td class="td_category"><?php echo $row['mb_id'] ?></td>
        <td><?php echo  $row['mb_name'] ?></td>
        <td><?php echo  $row['mb_nick'] ?></td>
        <td><?php echo  $row['mb_email'] ?></td>
        <td><?php echo  $row['mb_today_login'] ?></td>
        <td><?php echo  $row['mb_login_ip'] ?></td>
        <td><?php echo  $row['mb_ip'] ?></td>
        <td><?php echo  $row['mb_datetime'] ?></td>
    </tr>

    <?php
    }
    if ($i == 0)
        echo '<tr><td colspan="'.$colspan.'" class="empty_table">자료가 없거나 관리자에 의해 삭제되었습니다.</td></tr>';
    ?>
    </tbody>
    </table>
</div>

<?php
$qstr .= "&amp;page=";

$pagelist = get_paging($config['cf_write_pages'], $page, $total_page, "{$_SERVER['PHP_SELF']}?$qstr");
echo $pagelist;

include_once('./admin.tail.php');
?>
