<?php
use mc\Category;

include_once("./_common.php");
auth_check($auth[$sub_menu], "r");
$result = array();
if (empty($_POST['mode'])) {
    exit;
}
$mode = $_POST['mode'];
$result['mode'] = $mode;
function parseTitle($title)
{
    $title = trim($title);
    $titles = array_map('trim', explode(',', $title));
    foreach ($titles as $k => $v) {
        if (!$v) {
            unset($titles[$k]);
        }
    }
    return $titles;
}

switch ($mode) {
    case 'install':
        if (!mc::isInstalled()) {
            if (!empty($_POST['with_test_data'])) {
                include __DIR__ . '/test.php';
                $result['reload'] = true;
            } else {
                if (mc::install()) {
                    $result['reload'] = true;
                }
            }
        }
        break;
    case 'uninstall':
        if (mc::isInstalled()) {
            if (mc::uninstall(empty($_POST['board_config_use']))) {
                $result['reload'] = true;
            }
        }
        break;
    case 'add':
        try {
            if ($category = Category::get($_POST['mc'])) {
                $result['a'] = $category;
                if (!empty($_POST['extend_title'])) {
                    $category->addMulti($_POST['titles']);
                    $result['reload'] = true;
                } else {
                    if ($titles = parseTitle($_POST['title'])) {
                        foreach ($titles as $title) {
                            $category->add($title);
                        }
                        $result['reload'] = true;
                    } else {
                        $result['alert'] = '카테고리명을 입력해주세요.';
                    }
                }
            } else {
                $result['alert'] = '부모카테고리가 존재하지 않습니다.';
            }
        } catch(Exception $e) {
            $result['alert'] = $e->getMessage();
        }
        break;
    case 'remove':
        if ($category = Category::get($_POST['mc'])) {
            if ($category->depth > 0) {
                $category->remove();
                $result['reload'] = true;
            }
        } else {
            $result['alert'] = '카테고리가 존재하지 않습니다.';
        }
        break;
    case 'add_board_column':
        // 게시판 여분필트설정
        $data = $_POST['data'];
        if (empty($data['name'])) {
            $result['alert'] = '저장 컬럼명을 선택해주세요.';
        } elseif (empty($data['root'])) {
            $result['alert'] = '출력할 카테고리 위치를 선택해 주세요.';
        } else {
            if ($data['type'] === 'select') { // @todo 셀렉트일경우 최종 카테고리는 선택할 수 없다.

            }
            mc_board($bo_table)->addColumn($data['name'], $data)->save();
            $result['reload'] = true;
        }
        break;
    case 'removeConfigColumn':
        mc_board($bo_table)->removeColumn($_POST['column'])->save();
        $result['reload'] = true;
        break;
    case 'board_config':
        $data = $_POST['data'];
        foreach ($data as $_bo_table => $values) {
            if ($mc_board = mc_board($_bo_table)) {
                $_config = &$mc_board->getConfig();
                foreach ($values as $k => $value) {
                    $_config[$k] = $value;
                }
                $mc_board->save();
            }
        }
        $result['reload'] = true;
        break;
    case 'modify_wr':
        if ($mc_board = mc_board($bo_table)) {
            $allow_names = array('title', 'caption', 'searchable', 'required');
            $config = &$mc_board->getConfig();
            $data = $_POST['data'];
            foreach ($data as $name => $values) {
                if (!empty($config['columns'][$name])) {
                    foreach ($values as $k => $v) {
                        if (in_array($k, $allow_names)) {
                            $config['columns'][$name][$k] = $v;
                        }
                    }
                }
            }
            $mc_board->save();
            $result['reload'] = true;
        }
        break;
    case 'moveUp':
        if ($mc = mc((int)$_POST['mc'])) {
            $mc->moveUp();
            $result['reload'] = true;
        }
        break;
    case 'moveDown':
        if ($mc = mc((int)$_POST['mc'])) {
            $mc->moveDown();
            $result['reload'] = true;
        }
        break;
}


echo json_encode($result);
