<?php
/**
 * category library
 * @author eyesonlyz@nate.com
 */
namespace {

    use mc\Board;
    use mc\Category;

    const MC = true;

    /**
     * 환경설정 사용시 저장 컬럼
     */
    defined('MC_BOARD_CONFIG_COLUMN') || define('MC_BOARD_CONFIG_COLUMN', 'bo_10');
    define('MC_DATA_PATH', G5_DATA_PATH . '/mc');
    define('MC_PLUGIN_PATH', G5_PLUGIN_PATH . '/mc');

    /**
     * @return Category|null
     */
    function mc()
    {
        static $obj = null;
        if (func_num_args() > 0) {
            return Category::get(func_get_arg(0));
        }
        return $obj ?: $obj = Category::root();
    }

    /**
     * @param $bo_table
     * @return Board|null
     */
    function mc_board($bo_table)
    {
        global $g5;
        static $obj = array();
        if (empty($obj[$bo_table])) {
            if ($GLOBALS['bo_table'] === $bo_table) {
                $board = $GLOBALS['board'];
            } else {
                $board = sql_fetch("SELECT * FROM {$g5['board_table']} WHERE bo_table = '$bo_table' ");
            }
            if (is_array($board) && !empty($board['bo_table'])) {
                $obj[$bo_table] = new Board($board);
            }
        }
        return isset($obj[$bo_table]) ? $obj[$bo_table] : null;
    }

    if (function_exists('mysqli_fetch_object') && G5_MYSQLI_USE) {
        function sql_fetch_obj($result, $class = 'stdClass')
        {
            return call_user_func_array("mysqli_fetch_object", func_get_args());
        }
    } else {
        function sql_fetch_obj()
        {
            return call_user_func_array("mysql_fetch_object", func_get_args());
        }
    }

    /**
     * @param string $str
     * @return array
     */
    function mc_checkbox_to_array($str)
    {
        $words = array();
        foreach (explode('..', $str) as $word) {
            $word = trim($word, '.');
            if ($word) {
                $words[] = $word . '.';
            }
        }
        return $words;
    }

    /**
     * @param string $str
     * @return string
     */
    function mc_title($str)
    {
        return (string)str_replace('.', '', str_replace('..', ', ', $str));
    }

    class mc
    {
        /**
         * 설치여부 제출
         * @param bool $cached
         * @return bool
         */
        public static function isInstalled($cached = false)
        {
            static $installed = null;
            if ($cached && $installed !== null) {
                return $installed;
            }
            return ($installed = sql_fetch("SHOW TABLES LIKE '" . mc\TABLE_NAME . "'")) ? true : false;
        }

        /**
         * 인스톨.
         * @return bool
         */
        public static function install()
        {
            if (!self::isInstalled()) {
                $sql = "CREATE TABLE IF NOT EXISTS " . mc\TABLE_NAME . " (
                    `mc`  INT(10) UNSIGNED NOT NULL AUTO_INCREMENT ,
                    `parent_id`  INT(11) UNSIGNED NULL DEFAULT NULL ,
                    `lft`  INT(11) UNSIGNED NOT NULL ,
                    `rgt`  INT(11) UNSIGNED NOT NULL ,
                    `depth`  TINYINT(3) UNSIGNED NOT NULL ,
                    `title`  VARCHAR(32) NOT NULL ,
                    `path`  VARCHAR(255) NOT NULL ,
                    `path_id`  VARCHAR(255) ,
                    PRIMARY KEY (`mc`),
                    INDEX `lft` (`lft`) ,
                    INDEX `rgt` (`rgt`) ,
                    INDEX `depth` (`depth`) , 
                    UNIQUE INDEX `path` (`path`) , 
                    UNIQUE INDEX `path_id` (`path_id`)  
                ) DEFAULT CHARACTER SET=utf8";
                sql_query($sql);
                mc::insert(mc\TABLE_NAME, array('title' => '카테고리', 'lft' => 1, 'rgt' => 2, 'depth' => 0));
                if (!is_dir(MC_DATA_PATH)) {
                    mkdir(MC_DATA_PATH, G5_DIR_PERMISSION);
                }
            }
            return self::isInstalled();
        }

        /**
         * 언인스톨
         * @param bool $data_delete 디렉토리 데이타 삭제여부.
         * @return bool
         */
        public static function uninstall($data_delete = false)
        {
            if (self::isInstalled()) {
                sql_query("DROP TABLE IF EXISTS " . mc\TABLE_NAME);
                if ($data_delete && is_dir(MC_DATA_PATH)) {
                    foreach (glob(MC_DATA_PATH . '/*.js') as $file) {
                        unlink($file);
                    }
                    rmdir(MC_DATA_PATH);
                }
            }
            return !self::isInstalled();
        }

        public static function insert($table, $data)
        {
            $data = array_map('sql_escape_string', $data);
            $sql = "INSERT INTO $table ";
            $columns = array();
            foreach ($data as $k => $v) {
                $columns[] = "`$k`";
                $values[] = $v;
            }
            if (!empty($values)) {
                $sql .= "(" . join(',', $columns) . ") VALUES ('" . join("','", $values) . "')";
                sql_query($sql, true);
            }
        }

        public static function update($table, $data, $where)
        {
            $data = array_map('sql_escape_string', $data);
            $sql = "UPDATE $table SET ";
            $columns = array();
            foreach ($data as $k => $v) {
                $columns[] = "`$k`='$v'";
            }
            $sql .= join(',', $columns);
            $wheres = array();
            foreach ($where as $k => $v) {
                $wheres[] = "`$k`='$v'";
            }
            $sql .= " WHERE " . join(' AND ', $wheres);
            sql_query($sql, true);
        }
    }
}

namespace mc {

    use \Exception;
    const TABLE_NAME = 'mc_category';
    const DEBUG = true;

    /**
     * 계시판별 설정 처리 클래스.
     * Class Board
     * @package mc
     */
    class Board
    {
        /**
         * 그누보드 board 설정값
         * @var array
         */
        protected $board;
        protected $config = array(
            'list_skin' => 'basic', // 리스트 스킨
            'write_skin' => 'basic', // 글쓰기 스킨
            'view_skin' => 'basic', // 내용보기 스킨
            'columns' => array(), // 여분플드 설정
        );
        public static $default_column_config = array(
            'root' => '',
            'name' => '', // input name
            'column' => 'mc', // 테이타 컬럼
            'type' => 'select', // 출력방식
            'title' => '', //
            'label' => '',
            'required' => 0, //필수 입력
            'searchable' => 1,
        );

        public function __construct(array $board)
        {
            $this->board = $board;
            $this->file = MC_DATA_PATH . '/' . $board['bo_table'] . '.js';
            if (is_file($this->file)) {
                if ($config = json_decode(file_get_contents($this->file), true)) {
                    if (json_last_error() === JSON_ERROR_NONE) {
                        $this->config = $config;
                    }
                }
            }
        }

        /**
         * 리스트 스킨셋
         * @param string $type ist,write
         * @return array
         */
        public static function getSkins($type = 'write')
        {
            $skins = array();
            if (self::isValidSkinType($type)) {
                $dir = MC_PLUGIN_PATH . '/' . $type . '_skin';
                foreach (glob($dir . '/*') as $name) {
                    $name = pathinfo($name, PATHINFO_FILENAME);
                    $skins[$name] = $name;
                }
            }
            return $skins;
        }

        /**
         * 스킨허용타입확인
         * @param $type
         * @return string|false
         */
        public static function isValidSkinType($type)
        {
            if (in_array($type, array('list', 'write', 'view'))) {
                return $type;
            } else {
                return false;
            }
        }

        /**
         * @param array|null $params
         * @return string
         */
        public function getSearchSql(array $params = null)
        {
            if ($params === null) {
                $params = $_GET;
            }
            $mc_search = array();
            foreach ($this->config['columns'] as $k => $v) {
                if (!empty($params[$k])) {
                    if ($v['type'] === 'radio') {
                        $mc_search[] = "$k='{$params[$k]}'";
                    } elseif ($v['type'] === 'checkbox') {
                        $words = explode('..', $params[$k]);
                        $words = array_map(function ($value) {
                            return '.' . trim($value, '.') . '.';
                        }, $words);
                        $_word_sql = array();
                        foreach ($words as $word) {
                            if (!empty($word) && $word !== '.' && $word != '..') {
                                $_word_sql[] = "$k LIKE '%{$word}%'";
                            }
                        }
                        if ($_word_sql) {
                            $op = $params[$k . '_op'] === 'or' ? 'or' : 'and';
                            $mc_search[] = '(' . join(" $op ", $_word_sql) . ')';
                        }
                    } else {
                        if ($v['column'] === 'mc') {
                            $mc_search[] = "$k LIKE '{$params[$k]}%'";
                        } else {
                            if ($v['column'] === 'path') {
                                $mc_search[] = "$k LIKE '{$params[$k]}%'";
                            }
                        }
                    }
                }
            }
            if (!empty($mc_search)) {
                return '(' . join(' AND ', $mc_search) . ')';
            }
            return '';
        }

        public function getAddQueryString(array $params = null)
        {
            if ($params === null) {
                $params = $_GET;
            }
            $query = array();
            foreach ($this->config['columns'] as $k => $v) {
                if (!empty($params[$k])) {
                    $query[$k] = $params[$k];
                }
            }
            return $query ? '&amp;' . http_build_query($query, '&amp') : '';
        }

        /**
         * @return \stdClass
         */
        public function &getConfig()
        {
            return $this->config;
        }

        /**
         * 리스트 스킨 파일 제출.
         * @param string $type
         * @return null|string
         */
        public function getSkinFile($type)
        {
            $file = MC_PLUGIN_PATH . '/' . $type . '_skin/' . $this->config[$type . '_skin'] . '.php';
            if (is_file($file)) {
                return $file;
            }
            return null;
        }

        public function getSelectbox($type, $name = null, $value = null)
        {
            $name = $name === null ? $type . '_skin' : $name;
            $current_value = $value === null ? $this->config[$type . '_skin'] : 'basic';
            $html = '<select name="' . $name . '">';
            foreach (self::getSkins($type) as $v) {
                $selected = $v === $current_value ? ' selected' : '';
                $html .= '<option value="' . $v . '"' . $selected . '>' . $v . '</option>';
            }
            $html .= '</select>';
            return $html;
        }

        /**
         * 컬럼 설정 추가
         * @param $column
         * @param $config
         * @return $this
         */
        public function addColumn($column, array $config)
        {
            $config = array_merge(self::$default_column_config, $config);
            $this->config['columns'][$column] = $config;
            return $this;
        }

        /**
         * 환결설정 저장
         */
        public function save()
        {
            ksort($this->config['columns']);
            ksort($this->config);
            $json = json_encode($this->config);
            file_put_contents($this->file, $json);
        }

        /**
         * 컬럼설정삭제.
         * @param string $column
         * @return $this
         */
        public function removeColumn($column)
        {
            if (isset($this->config['columns'][$column])) {
                unset($this->config['columns'][$column]);
            }
            return $this;
        }

        /**
         * @return Input[]
         */
        public function getInputs()
        {
            $array = array();
            foreach ($this->config['columns'] as $name => $attrs) {
                if (!empty($attrs['root'])) {
                    $attrs['name'] = $name;
                    $array[$name] = \mc($attrs['root'])->input($attrs);
                }
            }
            return $array;
        }

        /**
         * 데이타 유효성 체크
         * @param array $params $_GET or $_POST ...
         * @throws \Exception
         */
        public function validateParams(array $params)
        {
            foreach ($this->config['columns'] as $name => $attrs) {
                if ($attrs['required'] && empty($params[$name])) {
                    throw new \Exception($attrs['title'] . '를 선택해 주세요.');
                }
                if (!$root = \mc($attrs['root'])) {
                    throw new \Exception($attrs['title'] . ' 값이 올바르지 않습니다.');
                }
                $value = $ori_value = $params[$name]; //유호한 테이터인지 확인.
                $_params = array('mc' => $value);
                if ($attrs['column'] === 'path') {
                    if ($attrs['type'] === 'checkbox') {
                        if (true === $root->inContains(mc_checkbox_to_array($value), $attrs['column'], true)) {
                            return;
                        }
                    } else {
                        $_params = array('path' => $root->path . $value);
                    }
                }
                $mc = \mc($_params);
                if (!$mc) {
                    throw new \Exception($attrs['title'] . ' 값이 존재하지 않습니다.');
                }
                if (strncmp($mc->path_id, $root->path_id, strlen($root->path_id))) {
                    throw new \Exception($attrs['title'] . ' 값이 올바르지 않습니다.');
                }
            }
        }
    }

    class Category
    {
        /**
         * 카테고리명
         * @var string
         */
        public $title = '';

        /**
         * depth
         * @var int
         */
        public $depth;

        /**
         * 기본키
         * @var int
         */
        public $mc;

        public $path;

        public $path_id;

        /**
         * 기본키 제출
         * @return int
         */
        public function getPk()
        {
            return $this->mc;
        }

        /**
         * 카테고리 검색 제출.
         * @param array|int $where
         * @return Category|null
         */
        public static function get($where)
        {
            if (!is_array($where)) {
                $where = array('mc' => (int)$where);
            }
            $sql = "SELECT mc, parent_id, title, depth, path, path_id FROM " . TABLE_NAME . " WHERE ";
            $wheres = array();
            foreach ($where as $k => $v) {
                $wheres[] = "`$k`='$v'";
            }
            $sql .= join(' AND ', $wheres);
            $result = sql_query($sql, DEBUG);
            return sql_fetch_obj($result, __CLASS__);
        }

        /**
         * ROOT 제출.
         * @return Category
         */
        public static function root()
        {
            return self::get(array('mc' => 1));
        }

        /**
         * 카테고리 추가.
         * @param string $title
         * @return Category
         * @throws Exception
         */
        public function add($title)
        {
            $title = trim((string)$title);
            if (preg_match('/\.|\|"\'/', $title)) {
                throw new Exception('카테고리명에 사용할 수 없는 문자가 있습니다.');
            }
            if ($title === "") {
                throw new Exception('카테고리명에을 입력해주세요.');
            }
            if(!$this->mc || !sql_query("SELECT @rgt := rgt FROM " . TABLE_NAME . " WHERE mc=" . $this->mc)){
                throw new Exception('카테고리가 존재하지 않습니다.');
            }
            $sql = "SELECT COUNT(0) FROM total FROM ".TABLE_NAME." WHERE parent_id=".$this->mc." AND title='$title'";
            $row = sql_fetch($sql);
            if($row['total'] > 0){
                throw new Exception($title . ' 카테고리명이 중복됩니다.');
            }

            $sql = "UPDATE " . TABLE_NAME . " SET 
            lft = CASE WHEN lft >= @rgt THEN lft+2 ELSE lft END,
            rgt = rgt + 2
            WHERE rgt >= @rgt";
            sql_query($sql, DEBUG);
            $depth = $this->depth + 1;
            $path = $this->path . $title . '.';
            $sql = "INSERT INTO " . TABLE_NAME . " (title, lft, rgt, depth, parent_id, path) 
            VALUES ('$title', @rgt, @rgt+1, $depth, $this->mc, '$path')";
            sql_query($sql);
            if($id = sql_insert_id()) {
                $path_id = $this->path_id . $id . '.';
                $sql = "UPDATE " . TABLE_NAME . " SET path_id='$path_id' WHERE mc=$id";
                sql_query($sql);
                return self::get($id);
            }
        }


        public function moveUp()
        {
            $sql = "SELECT * FROM " . TABLE_NAME . " WHERE mc=$this->mc";
            $current = sql_fetch($sql);
            $current_count = $current['rgt'] - $current['lft'] + 1;
            $sql = "SELECT * FROM " . TABLE_NAME . " AS A WHERE rgt=" . ($current['lft'] - 1);
            $prev = sql_fetch($sql);
            if (!empty($prev)) {
                $prev_count = $prev['rgt'] - $prev['lft'] + 1;
                $sql = "UPDATE " . TABLE_NAME . " SET lft=lft-$prev_count, rgt=rgt-$prev_count WHERE path_id LIKE '{$this->path_id}%'";
                sql_fetch($sql, DEBUG);
                $sql = "UPDATE " . TABLE_NAME . " SET lft=lft+$current_count, rgt=rgt+$current_count WHERE path_id LIKE '{$prev['path_id']}%'";
                sql_fetch($sql, DEBUG);
            }
        }

        public function moveDown()
        {
            $sql = "SELECT * FROM " . TABLE_NAME . " WHERE mc=$this->mc";
            $current = sql_fetch($sql);
            $current_count = $current['rgt'] - $current['lft'] + 1;
            $sql = "SELECT * FROM " . TABLE_NAME . " AS A WHERE lft=" . ($current['rgt'] + 1);
            $next = sql_fetch($sql);
            if (!empty($next)) {
                $next_count = $next['rgt'] - $next['lft'] + 1;
                $sql = "UPDATE " . TABLE_NAME . " SET lft=lft+$next_count, rgt=rgt+$next_count WHERE path_id LIKE '{$this->path_id}%'";
                sql_fetch($sql, DEBUG);
                $sql = "UPDATE " . TABLE_NAME . " SET lft=lft-$current_count, rgt=rgt-$current_count WHERE path_id LIKE '{$next['path_id']}%'";
                sql_fetch($sql, DEBUG);
                return true;
            }
            return false;
        }

        /**
         * 부모 카테고리 제출.
         * @return Category|null
         */
        public function parent()
        {
            return $this->parent_id ? self::get(array('mc' => $this->parent_id)) : null;
        }

        public function tree($callback, $tag = 'ul')
        {
            $rows = $this->getChild(-1);
            $depth = 0;
            foreach ($rows as $row) {
                if ($row->depth > $depth) {
                    echo "<$tag>";
                } else {
                    if ($row->depth < $depth) {
                        echo str_repeat("</$tag>", $depth - $row->depth);
                    }
                }
                $callback($row);
                $depth = $row->depth;
            }
            if ($this->depth < $depth) {
                echo str_repeat("</$tag>", $depth - $this->depth);
            }
        }

        /**
         * 카테고리 멀티 추가.
         * @param string $context
         * @param string $indent_char
         * @return int 입력성공한 갯수.
         */
        public function addMulti($context, $indent_char = "\t")
        {
            $title = str_replace($indent_char, "    ", $context);
            $titles = array_map('rtrim', explode("\n", $title));
            $array = array();
            $array[-1] = $this;
            $i = 0;
            $matches = array();
            foreach ($titles as $title) {
                $depth = 0;
                if (preg_match('/^(\s+)/', $title, $matches)) {
                    $depth = strlen($matches[1]) / 4;
                }
                $title = ltrim($title);
                if (!empty($title)) {
                    $array[$depth] = $array[$depth - 1]->add($title);
                    ++$i;
                }
            }
            return $i;
        }

        /**
         * @param int $offset
         * @param string $class_name
         * @return \ArrayIterator[Category]
         */
        public function getChild_($offset = 0, $class_name = __CLASS__)
        {
            setType($offset, 'int');
            if ($offset === 0) {
                $sql = "SELECT * FROM " . TABLE_NAME . " WHERE parent_id={$this->mc} ORDER BY lft ASC";
            } else {
                if (!$this->path_id) {
                    $sql = "SELECT * FROM " . TABLE_NAME . " WHERE path_id <> ''";
                } else {
                    $sql = "SELECT * FROM " . TABLE_NAME . " WHERE path_id LIKE '{$this->path_id}%";
                }
                if ($offset > 0) {
                    $depth = $this->depth + $offset + 1;
                    $sql .= " AND depth=$depth";
                }
            }
            $rows = array();
            $result = sql_query($sql, DEBUG);
            if ($result) {
                while ($row = sql_fetch_obj($result, $class_name)) {
                    if ($row->mc) {
                        $rows[] = $row;
                    }
                }
            }
            return $rows;
        }


        /**
         * 자식 카테고리 제출.
         * @param int $offset
         * @param string $class_name
         * @return Category[]
         */
        public function getChild($offset = 0, $class_name = __CLASS__)
        {
            setType($offset, 'int');
            $id = (int)$this->mc;
            if($offset === 0){
                $sql = "SELECT * FROM " . TABLE_NAME . " WHERE parent_id={$this->mc} ORDER BY lft ASC";
            }else {
                $sql = "SELECT B.mc, B.title, B.depth, B.path, B.path_id
                FROM " . TABLE_NAME . " AS A LEFT JOIN " . TABLE_NAME . " AS B";
                $sql .= " ON B.lft BETWEEN A.lft + 1 AND A.rgt";
                $sql .= " WHERE A.mc=$id";
                if ($offset > -1) {
                    $depth = $this->depth + $offset + 1;
                    $sql .= " AND B.depth <= $depth";
                }
                $sql .= " ORDER BY B.lft ASC";
            }
            $rows = array();
            $result = sql_query($sql, DEBUG);
            if ($result) {
                while ($row = sql_fetch_obj($result, $class_name)) {
                    if ($row->mc) {
                        $rows[] = $row;
                    }
                }
            }
            return $rows;
        }

        /**
         * 하위 카테고리인지 여부 체크.
         * @param $category
         * @return bool
         */
        public function contains(Category $category)
        {
            $sql = "SELECT COUNT(0) AS total
            FROM " . TABLE_NAME . " AS A LEFT JOIN " . TABLE_NAME . " AS B";
            $sql .= " ON B.lft BETWEEN A.lft AND A.rgt";
            $sql .= " WHERE A.mc=$this->mc AND B.mc=$category->mc";
            $row = sql_fetch($sql);
            return !empty($row['total']);
        }

        public function inContains($values, $type = 'mc', $as_root = false)
        {
            $where = array();
            $sql = "SELECT COUNT(0) AS total FROM " . TABLE_NAME . " WHERE ";
            foreach ($values as $v) {
                if ($type === 'path' && $as_root) {
                    $v = ($type === 'path' ? $this->path : $this->path_id) . $v;
                }
                $where[] = $type . "='$v'";
            }
            $sql .= join(' OR ', $where);
            $row = sql_fetch($sql);
            $total = (int)$row['total'];
            if ($total === count($values)) {
                return true;
            } else {
                return $total;
            }
        }

        /**
         * 카테고리 삭제.
         */
        public function remove()
        {
            sql_query("SELECT @lft := lft, @rgt := rgt, @width := rgt - lft + 1 FROM " . TABLE_NAME . " WHERE mc = " . $this->mc);
            sql_query("DELETE FROM " . TABLE_NAME . " WHERE lft BETWEEN @lft AND @rgt", DEBUG);
            sql_query("UPDATE " . TABLE_NAME . " SET rgt = rgt - @width WHERE rgt > @rgt", DEBUG);
            sql_query("UPDATE " . TABLE_NAME . " SET lft = lft - @width WHERE lft > @rgt", DEBUG);

        }

        /**
         * 부모카테고리 배열셋 제출.
         * @param int $from_depth
         * @return Category[]
         */
        public function getParents($from_depth = 0)
        {
            settype($from_depth, 'int');
            $sql = "SELECT B.* FROM " . TABLE_NAME . " AS A, " . TABLE_NAME . " AS B 
		    WHERE A.lft BETWEEN B.lft AND B.rgt AND A.mc='$this->mc' AND B.depth > $from_depth
		    ORDER BY A.lft ASC";
            $result = sql_query($sql, DEBUG);
            $rows = array();
            if ($result) {
                while ($row = sql_fetch_obj($result, __CLASS__)) {
                    $rows[] = $row;
                }
            }
            return $rows;
        }

        /**
         * @param bool $from_root root 로부터의 depth 또는 현제로부터의 depth.
         * @return int
         */
        public function getMaxDepth($from_root = true)
        {
            $depth = 0;
            $sql = "SELECT MAX(B.depth) AS depth FROM " . TABLE_NAME . " AS A LEFT JOIN " . TABLE_NAME . " AS B ON B.lft BETWEEN A.lft AND A.rgt WHERE A.mc=" . $this->mc;
            $row = sql_fetch($sql);
            if ($row) {
                $depth = (int)$row['depth'];
                if (!$from_root) {
                    $depth = $depth - $this->depth;
                }
            }
            return $depth;
        }

        /**
         * 양식 출력.
         * @param array $attrs
         */
        public function render($attrs = array())
        {
            return $this->input($attrs)->render();
        }

        public function __toString()
        {
            return $this->title;
        }

        /**
         * 양식 클래스 제출.
         * @param array $attrs
         * @return Input
         */
        public function input($attrs = array())
        {
            return new Input($this, $attrs);
        }
    }

    /**
     * Class Input
     * @package mc
     * @property-read $name
     */
    class Input
    {
        public $value;
        public $type = 'select';
        public $title;
        public $submit = false;
        public $required;
        public $caption;
        /**
         * 검색사용여부
         * @var bool
         */
        public $searchable;
        protected $ori_value = '';
        protected $offset;
        protected $name;
        protected $max_depth;
        protected $id;
        protected $column;
        protected $category;
        protected $attrs = array();

        /**
         * 테이타 유효컬럼.
         * @param $name
         * @return bool
         */
        public static function isValidValidColumn($name)
        {
            return in_array($name, array('mc', 'path'));
        }

        public function __get($name)
        {
            return $this->$name;
        }

        public function __construct(Category $category, $attrs = array())
        {
            static $_attrs = array(
                'title' => '',
                'name' => '',
                'value' => '',
                'required' => false,
                'column' => 'mc',
                'type' => 'select',
                'searchable' => 1,
                'offset' => 0,
                'caption' => '선택하세요'
            );
            $attrs = array_merge($_attrs, $attrs);
            $this->attrs = $attrs;

            $this->category = $category;
            $this->id = 'mc' . uniqid();
            $this->name = !empty($attrs['name']) ? $attrs['name'] : '';
            $this->value = !empty($attrs['value']) ? $attrs['value'] : '';
            $this->column = self::isValidValidColumn($attrs['column']) ? $attrs['column'] : 'mc';
            $this->title = !empty($attrs['title']) ? $attrs['title'] : $this->category->title;
            $this->max_depth = $this->category->getMaxDepth(false);
            $this->required = !empty($attrs['required']);
            $this->type = $this->max_depth == 1 && ($attrs['type'] === 'checkbox' || $attrs['type'] === 'radio') ? $attrs['type'] : 'select';
            $this->offset = (int)$this->offset;
            $this->caption = $attrs['caption'];
            $this->searchable = (bool)$attrs['searchable'];
        }

        public function offsetGet($name)
        {
            return isset($this->attrs[$name]) ? $this->attrs[$name] : '';
        }

        public function offsetSet($name, $value)
        {

        }

        public function offsetExists($name)
        {

        }

        public function offsetUnset($name)
        {
        }

        /**
         * @param $child
         * @param array $attrs
         * @param string $value
         * @return string
         */
        public function createSelectbox($child, array $attrs, $value = '')
        {
            $attributes = array();
            foreach ($attrs as $k => $v) {
                $attributes[] = $k . '="' . $v . '"';
            }
            $attributes = join(' ', $attributes);
            $column = $attrs['data-column'];
            $html = '<select ' . $attributes . '>';
            $html .= '<option value="">▒ ' . $attrs['caption'] ?: '선택하세요' . ' ▒</option>';
            if ($child) {
                foreach ($child as $row) {
                    $val = $row->{$column};
                    if ($column === 'path') {
                        $selected = $val === $value ? ' selected="selected"' : '';
                        $val = substr($row->path, strlen($this->category->path));
                    } else {
                        $selected = $val === $value ? ' selected="selected"' : '';
                    }
                    $html .= '<option value="' . $val . '"' . $selected . '>' . $row->title . '</option>';
                }
            }
            $html .= '</select>';
            return $html;
        }

        public function render()
        {
            $parents = array();
            if ($this->value) {
                $this->ori_value = $this->column === 'path' ? $this->category->path . $this->value : $this->value;
            }
            $value_category = $this->value ? Category::get(array($this->column => $this->ori_value)) : null;
            if ($value_category) {
                $parents = $value_category->getParents($this->category->depth);
            }
            if ($this->name) {
                echo sprintf('<input type="hidden" id="%s" name="%s" value="%s" />', 'input-' . $this->id, $this->name, htmlspecialchars($this->value));
            }
            $child = $this->category->getChild();
            if ($this->type !== 'select') {
                $html = '';
                $values = mc_checkbox_to_array($this->value);
                foreach ($child as $row) {
                    $value = $row->{$this->column};
                    if ($this->column === 'path') {
                        $value = substr($value, strlen($this->category->path));
                    }
                    $checked = in_array($value, $values) ? ' checked="checked"' : '';
                    $html .= '<label><input' . $checked . ' 
                    class="' . $this->id . '" 
                    data-id="' . $this->id . '" 
                    data-input="' . $this->name . '" 
                    data-root="' . $this->category->mc . '" 
                    type="' . $this->type . '" 
                    value="' . htmlspecialchars($value) . '" 
                    onclick="mcApi.handleCheck(this,\'' . $this->submit . '\');"/>' . $row->title . '</label> ';
                }
                echo $html;
                return;
            }

            $next_select = $this->max_depth > 0 ? $this->id . '--2' : '';
            $attrs = array(
                'data-root' => $this->category->mc,
                'data-input' => $this->name,
                'id' => $this->id . '--1',
                'data-next' => $next_select,
                'data-column' => $this->column,
                'onchange' => 'mcApi.handleSelect(this)',
                'title' => $this->title,
                'data-no' => '1',
                'data-max-no' => $this->max_depth,
                'data-id' => $this->id,
                'caption' => $this->caption,
            );

            if ($this->submit) {
                $attrs['onchange'] = 'mcApi.handleSelect(this, true)';
            }
            if ($this->required) {
                $attrs['required'] = 'required';
                $attrs['data-required'] = true;
            }
            $value = !empty($parents[0]) ? $parents[0]->{$this->column} : '';
            echo $this->createSelectbox($child, $attrs, $value);
            if ($this->max_depth > 1) {
                for ($i = 2; $i <= $this->max_depth; $i++) {
                    $next_select = $this->max_depth > $i + 1 ? $this->id . '--' . ($i + 1) : '';
                    $child = array();
                    $attrs['disabled'] = 'disabled';
                    $attrs['data-next'] = $next_select;
                    $attrs['caption'] = '선택해주세요';
                    $attrs['id'] = $this->id . '--' . $i;
                    $attrs['data-no'] = $i;
                    if (!empty($parents[$i - 2])) {
                        $child = $parents[$i - 2]->getChild();
                        if (count($child) > 0) {
                            unset($attrs['disabled']);
                        }
                    }
                    $value = !empty($parents[$i - 1]) ? $parents[$i - 1]->{$this->column} : '';
                    echo $this->createSelectbox($child, $attrs, $value);
                }
            }
        }
    }
}
