<?php
$sub_menu = '600100';
include_once('./_common.php');

$sql = "CREATE TABLE IF NOT EXISTS `cate_menu` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `rang` int(11) UNSIGNED NOT NULL,
  `parent_id` int(11) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `bo_table` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `rang` (`rang`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8";
sql_query($sql);

$g5['title'] = '게시판 분류관리';
if ($fm_subject) $g5['title'] .= ' : '.$fm_subject;
include_once (G5_ADMIN_PATH.'/admin.head.php');

add_javascript('<script src="' . G5_PLUGIN_URL . '/moodo/functions.js"></script>');
add_javascript('<script src="' . G5_PLUGIN_URL . '/moodo/jquery.nestable.js"></script>');
add_stylesheet('<link rel="stylesheet" href="'.G5_PLUGIN_URL.'/moodo/nes_style.css">', 1);
?>



<div class="loading"></div>
<div id="main_left">

</div>

<div id="main_right">
		<table class="s_tb">
			<tr>
				<td colspan=2>
					<menu id="nestable-menu">
						<button type="button" data-action="expand-all">모두 펼치기</button>
						<button type="button" data-action="collapse-all">모두 닫기</button>
						<button type="button" onclick="insertCate();">카테고리추가</button>
						&nbsp;&nbsp;&nbsp;<select name="bo_table" id="bo_table" onchange="get_first();">
						<option value="">게시판선택</option>
						<option value="">----------</option>
						<?php
							$sql = "select bo_table,bo_subject from {$g5['board_table']}";
							$result = sql_query($sql);
							while($row=sql_fetch_array($result)){
								echo "<option value=".$row['bo_table'].">".$row['bo_subject']."</option>";
							}
						?>
						</select>
						<a href="" class="btn_frmline" target="_blank">게시판바로가기</a>
					</menu>
				</td>
			</tr>

			<form name=ff method="post">
				<input type='hidden' name='mode'>
				
			<tr>
				<td>id</td>
				<td><input type='text' id='cate_id' name='cate_id' size='3' readonly>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					이게시판에<button type="button" id="cate_use" onclick="get_use('update');">무한카테 사용하기</button>
				</td>
			</tr>
			<tr>
				<td>분류명</td>
				<td>
				<input type='text' id='cate_name' name='cate_name'>
				</td>
			</tr>
			<tr>
				<td colspan="2" align="center">
					<button type='button' onclick='cateUpdate();'>수정</button>
					<button type='button' onclick='deleteCate();'>카테고리 삭제</button>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<ol class="txt">
						<li>카테고리를 사용할 게시판을 선택합니다.</li>
						<li>카테고리 추가하면 왼쪽에 NewCategory 카테고리가 생김니다.</li>
						<li>카테고리의 M버튼 클릭 하고 카테고리명을 수정하시면 됩니다.</li>
						<li>카테고리를 드래그 하여 위치를 조정 / 오른쪽으로 밀면 하위로 들어갑니다.</li>
					</ol>
				</td>
			</tr>
			<tr><td colspan="2"><div id="sortDBfeedback"></div></td></tr>
			</form>
		</table>
</div>

<script>
var brdTable='';
function get_first(){
	brdTable = $("#bo_table option:selected").val();
	$(".btn_frmline").attr("href", "../bbs/board.php?bo_table="+brdTable);

	$("#cate_id").val("");
	$("#cate_name").val("");

	$.ajax({
		type:"GET",
		url:"board_categorySave.php",
		contentType:'application/json',
		data:"mode=first&bo_tab="+brdTable,
		dataType:"html",
		beforeSend : function(){
			$('.loading').show();//로딩중이미지
		},
		success : function(html) {
			$("#main_left").html(html);
			nesCall();
			get_use('read');
			$('.loading').hide();//로딩중이미지

		},error : function(xhr,status,error) {
			alert("id:"+xhr.status+ "error:"+error); //실패시 실행부분		 
		}
	});
}

function get_use(s){
	var check = s;
	
		$.ajax({
			type:"GET",
			url:"board_categorySave.php",
			contentType:'application/json',
			data:"mode=cate_use&bo_tab="+brdTable+"&use_check="+check,
			dataType:"json",
			beforeSend : function(){
				
				$('.loading').show();//로딩중이미지
			},
			success : function(result) {
				//$("#cate_use").val(result.use);
				if(result.use){
					$("#cate_use").text("사용중");
				}else{
					$("#cate_use").text("무한카테 사용하기");
				}
				$('.loading').hide();//로딩중이미지

			},error : function(xhr,status,error) {
				alert("id:"+xhr.status+ "error:"+error); //실패시 실행부분		 
			}
		});

}


function nesCall(){

	$(document).ready(function()
	{
		var updateOutput = function(e)
		{
			var list   = e.length ? e : $(e.target),
				output = list.data('output');
			if (window.JSON) {
				output.val(window.JSON.stringify(list.nestable('serialize')));//, null, 2));
				menu_updatesort(window.JSON.stringify(list.nestable('serialize')));
			} else {
				output.val('JSON browser support required for this demo.');
			}
		};
		

		// activate Nestable for list menu
		$('#nestable').nestable({
			group: 1,
			maxDepth:10
		})
		.on('change', updateOutput);

		// nestable-output 에 출력
		updateOutput($('#nestable').data('output', $('#nestable-output')));



		$('#nestable-menu').on('click', function(e)
		{
			var target = $(e.target),
				action = target.data('action');
			if (action === 'expand-all') {
				$('.dd').nestable('expandAll');
			}
			if (action === 'collapse-all') {
				$('.dd').nestable('collapseAll');
			}
		});

		//$('#nestable3').nestable();

		//최초 닫고시작하자
		//$('.dd').nestable('collapseAll');
	});
}





function get_category(id){

	$.ajax({
		type:"GET",
		url:"board_categorySave.php",
		contentType:'application/json',
		data:"mode=getCate&cate_id="+id,
		dataType:"json",
		beforeSend : function(){

			$('.loading').show();//로딩중이미지

			if(!id){
				return false;
			}
		},
		success : function(result) {

			var cate_id = result.id;
			var cate_name = result.cate_name;

			$("#cate_id").val(cate_id);
			$("#cate_name").val(cate_name);
			
			$('.loading').hide();//로딩중이미지

		},error : function(xhr,status,error) {
			alert("id:"+xhr.status+ "error:"+error); //실패시 실행부분		 
		}
	});
}

function cateUpdate(){
	var f = document.ff;
	var id = f.cate_id.value;
	var name = f.cate_name.value;

	if(!id){
		alert('수정할 카테고리를 선택하세요.');
		return false;
	}

	if(!name){
		alert('카테고리명을 입력하세요.');
		f.cate_name.focus();
		return false;
	}

	if(id && name){
		$.ajax({
			type:"GET",
			url:"board_categorySave.php",
			contentType:'application/json',
			data:"mode=modify&cate_id="+id+"&cate_name="+name+"&bo_tab="+brdTable,
			dataType:"json",
			beforeSend : function(){
				$('.loading').show();//로딩중이미지
			},
			success : function(result) {
				//alert(result.cate_name + '=>'+ name + ' 수정완료.');
				get_first();

				$('.loading').hide();//로딩중이미지
			},error : function(xhr,status,error) {
				alert("id:"+xhr.status+ "error:"+error); //실패시 실행부분		 
			}

		});//ajax
	}
}


function insertCate(){

	if(brdTable){

		$.ajax({
			type:"GET",
			url:"board_categorySave.php",
			contentType:'application/json',
			data:"mode=insert&bo_tab="+brdTable,
			dataType:"json",
			beforeSend : function(){

				$('.loading').show();//로딩중이미지
			},
			success : function(result) {

				var cate_id = result.id;
				var str = "<li id='cate_"+ cate_id +"' class='dd-item' data-id='"+ cate_id +"' data-name='NewCategory' data-board='"+ brdTable +"'><div id='cate_"+ cate_id +"' class='dd-handle'>NewCategory</div><div class='dd4-handle' onclick=\"get_category('"+ cate_id +"');\"></div></li>";
				
				$('.dd > ol').prepend(str);
				nesCall();
				$('.loading').hide();//로딩중이미지

			},error : function(xhr,status,error) {
				alert("id:"+xhr.status+ "error:"+error); //실패시 실행부분		 
			}
		});

	}else{
		alert("게시판을 선택하세요.");
		return false;
	}

}


function deleteCate(id){
	var f = document.ff;
	var id = f.cate_id.value;

	if(id){
		var child=0;
		eval($("#cate_"+id)).each(function(index, element) {
			var li		= $(this);
			var myp		= li.parent().closest("li");
			var childAll = li.closest('li').find('.dd-list');
			var myp_childAll = myp.find('.dd-list > li');
			
			var mm = li.parent().closest("li > ol");
			var pp = myp.data("id");
			

			child = childAll.length;

			if(child){
				alert('하위 카테고리가 있습니다.');
				return false;

			}else{//!child

			var con = confirm(f.cate_name.value + "를 삭제하시겠습니까?");
				if(con){
					$.ajax({
						type:"GET",
						url:"board_categorySave.php",
						contentType:'application/json',
						data:"mode=delete&cate_id="+id+"&bo_tab="+brdTable,
						dataType:"json",
						beforeSend : function(){
							$('.loading').hide();//로딩중이미지
						},
						success : function(result) {

							get_first();

							$('.loading').hide();//로딩중이미지
						},error : function(xhr,status,error) {
							alert("id:"+xhr.status+ "error:"+error); //실패시 실행부분		 
						}

					});//ajax

				}//con
			}//!child

	});	

	}else{
		alert('삭제할 카테고리를 선택하세요.');
		return false;
	}

}

</script>


<?php
include_once (G5_ADMIN_PATH.'/admin.tail.php');
?>
