<?php
if(!defined("_GNUBOARD_")) exit("Access Denied");

include_once('config.php');
include_once('Telegram.php');

/**
* @bref 텔레그램으로 보내기
* @param $chat_id: 채팅아이디
* @param $text: 메시지
**/
function bt_tg_send($chat_id, $text){
	global $config;
	
	$text = '<strong>'.$config['cf_title'].'</strong>'.PHP_EOL.PHP_EOL.$text;
	
	$token = $config[BT_TG_TKNFLD];	
		
	$tg = new Telegram($token);
			
	$res = $tg->sendMessage(array(
		'chat_id'		=> $chat_id,
		'text'			=> $text,
		'parse_mode'	=> 'HTML'
	));
}


/**
* @bref 일반답변 알림처리
* @param $bo_table: 게시판 아이디
* @param $wr: 부모글배열 (레퍼런스로 받음)
* @param $wr_id: 등록된댓글의 글번호
* @param $mb_id: 등록된댓글의 글쓴이 아이디
**/
function bt_tg_reply($bo_table, &$wr, $wr_id, $mb_id){
	
	global $write_table;
	
	$mem = get_member($wr['mb_id']);
	$chat_id = $mem[BT_TG_TIDFLD];
	
	$sql = "SELECT * FROM ".$write_table." WHERE wr_id=".$wr_id;
	$rs = sql_fetch($sql);
	
	//chat_id 가 없거나 본인글이면 제외
	if(trim($chat_id)=='' || $mem['mb_id']===$mb_id) return;
	
	$text = $wr['wr_name'].'님 글에 답변이 등록되었습니다'.PHP_EOL.
		'제목: '.cut_str($rs['wr_subject'], 20).PHP_EOL.
		G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&wr_id='.$wr_id;

	bt_tg_send($chat_id, $text)	;
}


/**
* @bref 댓글알림 처리
* @param $bo_table: 게시판 아이디
* @param $wr: 부모글배열 (레퍼런스로 받음)
* @param $reply_array: 부모댓글배열 (레퍼런스로 받음)
* @param $comment_id: 등록된 댓글의 글번호
**/
function bt_tg_cmt($bo_table, &$wr, &$reply_array, $comment_id){
	
	global $g5, $write_table;
	
	$sql = "SELECT * FROM ".$write_table." WHERE wr_id=".$comment_id;
	$cmt = sql_fetch($sql);
		
	//코멘트의 댓글이면
	if(is_array($reply_array) && count($reply_array) > 0){
		$mem = get_member($reply_array['mb_id']);
		$name = $reply_array['wr_name'];
		
	//원글의 댓글이면
	}else{
		$mem = get_member($wr['mb_id']);
		$name = $wr['wr_name'];
	}
	$subject = cut_str($cmt['wr_content'], 20);
	
	$chat_id = $mem[BT_TG_TIDFLD];
	
	//chat_id 가 없거나 본인글이면 제외
	if(trim($chat_id)=='' || $mem['mb_id']===$cmt['mb_id']) return;
	
	$text = $name.'님 글에 댓글이 등록되었습니다'.PHP_EOL.
		'글: '.$subject.PHP_EOL.
		G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&wr_id='.$wr['wr_id'].'#c_'.$comment_id;

	bt_tg_send($chat_id, $text);
}


/**
* @bref 메모수신 알림 보내기
* @param $mlist: 수신자목록
* @param $mb_nick: 발신자 닉네임
* @param $text: 수신내용
**/
function bt_tg_memo($mlist, $mb_nick, $text){
	
	foreach($mlist['id'] as $mb_id){
		$mem = get_member($mb_id);
		
		$chat_id = $mem[BT_TG_TIDFLD];
		
		if(trim($chat_id)=='') return;
		
		$text = $mb_nick.'님의 쪽지가 도착했습니다'.PHP_EOL.
		cut_str($text, 20).PHP_EOL.G5_URL;
		
		bt_tg_send($chat_id, $text);
	}
}
