<?php
/**
 * 카테고리 json 출력 요청
 */
use mc\Category;
use mc\Input;

include_once('./_common.php');
header('Content-Type: application/json; charset=utf-8', true);

$result = array();
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode($result);
    exit;
}
if (!mc::isInstalled()) {
    $result['alert'] = 'MC 가 설치되어 있지 않습니다.';
    echo json_encode($result);
    exit;
}

if (empty($_GET['column']) || !Input::isValidValidColumn($_GET['column'])) {
    $result['alert'] = '컬럼지정이 유효하지 않습니다.';
    echo json_encode($result);
    exit;
}
$column = $_GET['column'];
if ($column === 'path' && !empty($_GET['root'])) {
    if (!$root = Category::get($_GET['root'])) {
        $result['alert'] = 'root 카테고리가 존재하지 않습니다.';
        echo json_encode($result);
        exit;
    } else {
        $params = array($column => $root->path . $_GET[$column]);
    }
} else {
    $params = array($column => $_GET[$column]);
}
$category = Category::get($params);
if (!$category) {
    $result['alert'] = '요청하신 카테고리가 존재하지 않습니다.';
    echo json_encode($result);
    exit;
}
$rows = $category->getChild(0, 'stdClass');
if ($column === 'path') {
    if($root = mc((int) $_GET['root'])) {
        $result['root_path'] = $root->path;
    }
}
$result['data'] = $rows;
echo json_encode($result);




