<?php
// LDD: 2019-07-19 실시간 쪽지
if(!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//memo_form_update.php

// --------------------- 함수 --------------------- //
	// fsockopen POST
	function curl_async($url) {
		$parts = parse_url($url);
		if(empty($parts['host'])) {
			$parts['scheme'] = '';
			$parts['host'] = reset(explode(':', $_SERVER['HTTP_HOST']));
			$parts['port'] = (count(explode(':', $_SERVER['HTTP_HOST'])) > 1?end(explode(':', $_SERVER['HTTP_HOST'])):80);
			if($parts['port'] != '80') $parts['scheme'] = 'https';
		}
		if(is_array($parts) && isset($parts['query'])) $post_string = $parts['query'];
		else $post_string = '';
		$fp = fsockopen(($parts['scheme'] == 'https'?'ssl://':null).$parts['host'], isset($parts['port'])?$parts['port']:80,  $errno, $errstr, 1);
		$out = "POST ".$parts['path']." HTTP/1.1\r\n";
		$out.= "Host: ".$parts['host']."\r\n";
		$out.= "Content-Type: application/x-www-form-urlencoded\r\n";
		$out.= "Content-Length: ".strlen($post_string)."\r\n";
		$out.= "Connection: Close\r\n\r\n";
		if(isset($post_string)) $out.= $post_string;
		fwrite($fp, $out);
		fclose($fp);

	}
	function post_curl_basic($url, $data=array()) {

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data, '', '&'));
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
		curl_setopt($ch, CURLINFO_HEADER_OUT, false);
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 3);
		$res = curl_exec($ch);
		$hcode = curl_getinfo($ch);
		curl_close($ch);
	}




	// JWT Enc/Dec
	function JwtEnc($type='e', $value=array(), $scret='', $alg='HS256') {
		$JWT = new JWT();
		if($type == 'e') return $JWT->encode($JWT->jsonEncode($value), $scret, $alg);
		else return $JWT->decode($value, $scret, array($alg));
	}
// --------------------- 함수 --------------------- //



// --------------------- 후킹 --------------------- //
	// 플러그인 호출
	add_event('tail_sub', 'TbMemo');
	function TbMemo() {
		global $member, $is_member;

		include_once(G5_PLUGIN_PATH.'/tb_memo/index.php');
	}

	// 쪽지 소켓 전송
	add_event('memo_form_update_after', 'tbSendMemo');
	function tbSendMemo() {
		global $member_list, $recv_mb_nick, $member;

		$memo = str_replace(PHP_EOL, ' ', $_POST['me_memo']);
		foreach($member_list['id'] as $k=>$v) {
			$nick = $member_list['nick'][$k];
			$send = array('from'=>$member['mb_nick']."({$member['mb_id']})", 'to'=>$nick."({$v})", 'memo'=>$memo);
			post_curl_basic(G5_URL.':7770/memo/'.$v, $send);
		}
	}
// --------------------- 후킹 --------------------- //