<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 12월 일 요일 오 시 분 - 날씨 

	저 작 권 : Copyright ⓒ 2014 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 피리 마이 페이지 FREE G5 > 자기소개 보기
===========================================================


*/


	#########################################################
	# 시작 => 라이브러리__화일__첨부____선처리
	#########################################################

	//=======================================================
	// 라이브러리__첨부
	include_once ('./_common.php');

	#########################################################
	# 끝 => 라이브러리__화일__첨부____선처리
	#########################################################



	#########################################################
	# 시작 => 상수__변수
	#########################################################

	//=======================================================
	// 개인정보_보기__에러_건수
	$info_view_error_t = 0;


	//=======================================================
	// 개인정보__안보이면_메세지
	$info_view_msg_arr = array();

	#########################################################
	# 끝 => 상수__변수
	#########################################################



	#########################################################
	# 시작 => 검증하기
	#########################################################

	//=======================================================
	// 시작 => 회원_여부__확인
	IF ($is_guest || !$is_member)
	{
		alert ('회원만 이용하실 수 있습니다.', G5_DOMAIN.'/');
		EXIT;
	}
	// 끝 => 회원_여부__확인
	//=======================================================


	//=======================================================
	// 시작 => 최고_관리자__아니면
	IF ($is_admin != 'super')
	{
			//===================================================
			// 시작 => 자기_정보__공개하지_않았으면
			IF (!$member['mb_open'])
			{
					//===============================================
					// 시작 => 내가_아닌__다른_회원__이면
					IF ($member['mb_id'] != $mb_id)
					{

							//===========================================
							// 개인정보_보기__에러_건수
							$info_view_error_t++;


							//===========================================
							// 개인정보__안보이면_메세지
							$info_view_msg_arr[] = '자신의 정보를 공개하지 않으면 다른분의 정보를 조회할 수 없습니다.\\n\\n정보공개 설정은 회원정보수정에서 하실 수 있습니다.';

					}
					// 끝 => 내가_아닌__다른_회원__이면
					//===============================================
			}
			// 끝 => 자기_정보__공개하지_않았으면
			//===================================================
	}
	// 끝 => 최고_관리자__아니면
	//=======================================================

	#########################################################
	# 끝 => 검증하기
	#########################################################



	#########################################################
	# 시작 => QUERY_STRING
	#########################################################
	IF ($info_view_error_t == 0)
	{

			//===================================================
			// SUERY_STRING
			$myp_mb_id	= trim($_GET["myp_mb_id"]);

	}
	#########################################################
	# 끝 => QUERY_STRING
	#########################################################



	#########################################################
	# 시작 => 기본값
	#########################################################
	IF ($info_view_error_t == 0)
	{

			//===================================================
			// 시작 => 대상_회원_아이디__없으면
			IF (!$myp_mb_id)
			{
					//===============================================
					// 시작 => 회원_손님__여부
					IF (!$member['mb_id'])
					{
							alert ('선택된 회원 아이디가 없습니다.', G5_DOMAIN.'/');
							EXIT;
					}
					ELSE
					{

							//===========================================
							// 대상_회원_아이디__나야
							$myp_mb_id = $member['mb_id'];

					}
					// 끝 => 회원_손님__여부
					//===============================================
			}
			// 끝 => 대상_회원_아이디__없으면
			//===================================================

	}
	#########################################################
	# 끝 => 기본값
	#########################################################



	#########################################################
	# 시작 => 피리_마이_페이지__설정_정보_화일__첨부
	#########################################################

	//=======================================================
	// 피리_메뉴__번호
	$piree_menu_n = 760007;


	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	$is_get__piree_config = 0;


	//=======================================================
	// 피리_마이_페이지__설정_정보__가져오기
	$is_get__my_page_config = 1;


	//=======================================================
	// 피리_마이_페이지__설정_정보_화일__경로
	$piree_dir_path = "../_config/p__".$piree_menu_n."/pi__config.php";


	//=======================================================
	// 피리_마이_페이지__설정_정보_화일__경로
	include_once ($piree_dir_path);

	#########################################################
	# 끝 => 피리_마이_페이지__설정_정보_화일__첨부
	#########################################################



	#########################################################
	# 시작 => 회원_정보__불러오기
	#########################################################
	IF ($info_view_error_t == 0)
	{

			//===================================================
			// 시작 => 대상_회원_아이디__유무
			IF ($myp_mb_id)
			{

					#################################################
					# 시작 => 대상_회원_아이디__있으면
					#################################################

					//===============================================
					// 회원_정보__불러오기
					$myp_member = get_member($myp_mb_id);

			}
			ELSE
			{

					#################################################
					# 시작 => 대상_회원_아이디__없으면
					#################################################

					//===============================================
					// 시작 => 회원_손님__여부
					IF (!$member['mb_id'])
					{
							alert ("선택된 회원 아이디가 없습니다.", G5_DOMAIN."/");
							EXIT;
					}
					ELSE
					{

							//===========================================
							// 대상_회원_아이디__나야
							$myp_mb_id = $member['mb_id'];

					}
					// 끝 => 회원_손님__여부
					//===============================================


					//===============================================
					// 회원_정보__복사
					$myp_member = $member;

			}
			// 끝 => 대상_회원_아이디__유무
			//===================================================


			//===================================================
			// 시작 => 대상_회원_아이디__없으면
			IF (!$myp_member['mb_id'])
			{
					alert ('회원정보가 존재하지 않습니다.\\n\\n탈퇴하였을 수 있습니다.');
			}
			// 끝 => 대상_회원_아이디__없으면
			//===================================================

	}
	#########################################################
	# 끝 => 회원_정보__불러오기
	#########################################################



	#########################################################
	# 시작 => 선택한__회원__정보
	#########################################################

	//=======================================================
	// 회원_닉네임
	$top_info_member_nick = get_text($myp_member['mb_nick']);


	//=======================================================
	// 회원_레벨
	$top_info_member_level = $myp_member['mb_level'];


	//=======================================================
	// 시작 => 회원_가입일__유무
	IF ($myp_member['mb_datetime'])
	{
			$top_info_member_join_date = date("Y년 m월 d일", strtotime($myp_member['mb_datetime']));
	}
	ELSE
	{
			$top_info_member_join_date = "";
	}
	// 끝 => 회원_가입일__유무
	//=======================================================


	//=======================================================
	// 회원_아이콘__PATH
	$member_icon_path = G5_DATA_PATH.'/member/'.substr($myp_mb_id, 0, 2).'/'.$myp_mb_id.'.gif';


	//=======================================================
	// 회원_아이콘__URL
	$member_icon_url	= G5_DATA_URL.'/member/'.substr($myp_mb_id, 0, 2).'/'.$myp_mb_id.'.gif';

	#########################################################
	# 끝 => 선택한__회원__정보
	#########################################################



	#########################################################
	# 시작 => 회원_정보__검증하기__다듬기
	#########################################################
	IF ($info_view_error_t == 0)
	{

			//===================================================
			// 시작 => 대상_회원_아이디__없으면
			IF (!$myp_member['mb_id'])
			{
					alert ('회원정보가 존재하지 않습니다.\\n\\n탈퇴하였을 수 있습니다.');
			}
			// 끝 => 대상_회원_아이디__없으면
			//===================================================


			//===================================================
			// 시작 => 최고_관리자__아니면
			IF ($is_admin != 'super')
			{
					//===============================================
					// 시작 => 자기_정보__공개하지_않았으면
					IF (!$myp_member['mb_open'])
					{
							//===========================================
							// 시작 => 내가_아닌__다른_회원__이면
							IF ($myp_member['mb_id'] != $mb_id)
							{

									//=======================================
									// 개인정보_보기__에러_건수
									$info_view_error_t++;


									//=======================================
									// 개인정보__안보이면_메세지
									$info_view_msg_arr[] = '정보공개를 하지 않았습니다.';

							}
							// 끝 => 내가_아닌__다른_회원__이면
							//===========================================
					}
					// 끝 => 자기_정보__공개하지_않았으면
					//===============================================
			}
			// 끝 => 최고_관리자__아니면
			//===================================================


			//===================================================
			// 회원의__사이드뷰
			$member_nick = get_sideview($myp_member['mb_id'], $myp_member['mb_nick'], $myp_member['mb_email'], $myp_member['mb_homepage'], $myp_member['mb_open']);


			//===================================================
			// 시작 => 가입일__있으면
			IF ($myp_member['mb_datetime'])
			{

					//===============================================
					// 가입일_시각
					$join_time_n = strtotime($myp_member['mb_datetime']);


					//===============================================
					// 가입일
					$member_join_date = date("Y년 m월 d일 H시 i분", $join_time_n);


					//===============================================
					// 가입_후__경과__날짜_수
					$day_t = ceil((G5_SERVER_TIME-$join_time_n)/86400);

			}
			// 끝 => 가입일__있으면
			//===================================================


			//===================================================
			// 시작 => 홈페이지__있으면
			IF ($myp_member['mb_datetime'])
			{

					//===============================================
					// 홈페이지
					$mb_homepage = set_http(clean_xss_tags($myp_member['mb_homepage']));

			}
			// 끝 => 홈페이지__있으면
			//===================================================


			//===================================================
			// 시작 => 소개_내용__있으면
			IF ($myp_member['mb_profile'])
			{

					//===============================================
					// 소개_내용
					$mb_profile = conv_content($myp_member['mb_profile'], 0);

			}
			// 끝 => 소개_내용__있으면
			//===================================================


			//===================================================
			// 최종_접속일__시각
			$member_today_login_time_n = 0;


			//===================================================
			// 시작 => 최종_접속일__있으면
			IF ($myp_member['mb_today_login'])
			{
					//===============================================
					// 시작 => 내_레벨__더__높거나_같으면
					IF ($member['mb_level'] >= $myp_member['mb_level'])
					{

							//===========================================
							// 최종_접속일__시각
							$member_today_login_time_n = strtotime($myp_member['mb_today_login']);


							//===========================================
							// 최종_접속일__날짜_시간
							$member_today_login_date = date("Y년 m월 d일 H시 i분", $member_today_login_time_n);

					}
					// 끝 => 내_레벨__더__높거나_같으면
					//===============================================
			}
			// 끝 => 최종_접속일__있으면
			//===================================================

	}
	#########################################################
	# 끝 => 회원_정보__검증하기__다듬기
	#########################################################



	#########################################################
	# 시작 => 상수__변수
	#########################################################

	//=======================================================
	// 페이지_타이틀
	$g5['title'] = '"'.$myp_member['mb_nick'].'" 님 알아보기';


	//=======================================================
	// 피리_마이_페이지_메뉴
	$piree_my_page_menu_c = 'your_info';


	//=======================================================
	// 피리_마이_페이지_메뉴__권한__배열
	$myp_info_arr = get__array_value($piree_my_page_gnu_menu_arr, 'code_all', $piree_my_page_menu_c);


	//=======================================================
	// 피리_마이_페이지_메뉴__권한__배열
	$myp_auth = $myp_info_arr['view_auth'];

	#########################################################
	# 끝 => 상수__변수
	#########################################################



	#########################################################
	# 시작 => 마무리__페이지_ECHO_관련
	#########################################################

	//=======================================================
	// HEAD_첨부
	include_once ("./_head.php");


	//=======================================================
	// 시작 => DEVIDE__구분
	IF (G5_IS_MOBILE == 1)
	{

		#######################################################
		# 시작 => DEVIDE__모바일__이름

		//=====================================================
		// 스킨__PATH
		$menu_path_s = $my_page_gnu_config["skin_mobile_p"]."/top_menu.skin.php";


		//=====================================================
		// 스킨__PATH
		$skin_path_s = $my_page_gnu_config["skin_mobile_p"]."/your_info.skin.php";

	}
	ELSE
	{

		#######################################################
		# 시작 => DEVIDE__PC__이면

		//=====================================================
		// 스킨__PATH
		$menu_path_s = $my_page_gnu_config["skin_pc_p"]."/top_menu.skin.php";


		//=====================================================
		// 스킨__PATH
		$skin_path_s = $my_page_gnu_config["skin_pc_p"]."/your_info.skin.php";

	}
	// 끝 => DEVIDE__구분
	//=======================================================


	//=======================================================
	// 탑_메뉴_스킨_화일__첨부
	include_once ($menu_path_s);


	//=======================================================
	// 주_스킨_화일__첨부
	include_once ($skin_path_s);


	//=======================================================
	// BOTTOM_첨부
	include_once ("./_tail.php");

	#########################################################
	# 끝 => 마무리__페이지_ECHO_관련
	#########################################################


?>