<?php

/*
===========================================================

	프로젝트 이름 : 피리 그누보드5 엑셀 다운로드

	만든사람 : 피리 PIREE

	홈페이지 : www.piree.kr

	작업날짜 : 2018년 09월 23일 일요일 오후 19시 32분

	저 작 권 : Copyright ⓒ 2014-2018 피리 (PIREE) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.kr 에 문의해 주세요.

===========================================================
 피리 > 관리자 > 피리 그누보드5 엑셀 다운로드 PLUS G5 > 처음
===========================================================


*/


	#########################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	#########################################################

	//=======================================================
	// 메뉴_번호__지정____피리_그누보드5_엑셀_다운로드
	$sub_menu = "770061";


	//=======================================================
	// 기본처리_파일__첨부
	include_once('./_common.php');


	//=======================================================
	// 시작 => 회원_아니면
	IF ( !$is_member )
	{
			alert('회원만 이용하실 수 있습니다.', G5_URL);
	}
	// 끝 => 회원_아니면
	//=======================================================


	//=======================================================
	// 시작 => 관리자_아니면
	IF ( !$is_admin )
	{
			alert('접근할 권한이 없습니다.', G5_URL);
	}
	// 끝 => 관리자_아니면
	//=======================================================


	//=======================================================
	// 관리자_확인
	auth_check($auth[PIREE_PLUS_G5_EXCEL_DOWNLOAD_N], 'r');

	#########################################################
	# 끝 => 선_처리
	#########################################################



	#########################################################
	# 시작 => 피리_그누보드5_엑셀_다운로드__설정_정보_파일__첨부
	#########################################################

	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$get__piree_config = 1;


	//=======================================================
	// 설정_정보__가져오기
	$is_get__p770061 = 1;


	//=======================================================
	// 피리_그누보드5_엑셀_다운로드__설정_정보_파일__첨부
	include_once( get__sam_file(PIREE_PLUS_G5_EXCEL_DOWNLOAD_N, 'config', 'path') );

	#########################################################
	# 끝 => 피리_그누보드5_엑셀_다운로드__설정_정보_파일__첨부
	#########################################################



	#########################################################
	# 시작 => 카테고리__관리__상수__변수__배열
	#########################################################

	//=======================================================
	// 


	//=======================================================
	// 

	#########################################################
	# 끝 => 카테고리__관리__상수__변수__배열
	#########################################################



	#########################################################
	# 시작 => 상수__변수__배열
	#########################################################

	//=======================================================
	// 게시판__수
	$board_t = 0;


	//=======================================================
	// 게시판___배열
	$board_arr = array();

	#########################################################
	# 끝 => 상수__변수__배열
	#########################################################



	#########################################################
	# 시작 => 게시판__목록__불러오기
	#########################################################

			#####################################################
			# 시작 => 게시판__수__파악하기
			#####################################################

			//===================================================
			// 게시판__수__파악하는__쿼리문
			$sql	= "SELECT COUNT(*) FROM `". $g5['board_table'] ."`";
			$board_t = sql_efv($sql);
			$board_t = (int)$board_t;

			#####################################################
			# 끝 => 게시판__수__파악하기
			#####################################################



			#####################################################
			# 시작 => 게시판__목록__불러오기
			#####################################################
			IF ( $board_t > 0)
			{

					#################################################
					# 시작 => 게시판__목록__불러오기
					#################################################

					//===============================================
					// 게시판__불러오기
					$sql = "SELECT * FROM `". $g5['board_table'] ."` ORDER BY bo_table ASC";
					$result = sql_query($sql);


					//===============================================
					// 끝 => 반복문
					FOR($i=0; $row=sql_fetch_array($result); $i++ )
					{

							//===========================================
							// 게시판_PC_이름
							$bo_subject = view__str_gt($row["bo_subject"]);


							//===========================================
							// 게시판_모바일_이름__따옴표_제거
							$bo_mobile_subject = $row["bo_mobile_subject"] ? view__str_gt($row["bo_mobile_subject"]) : $bo_subject;


							//===========================================
							// 게시판___배열
							$board_arr[] = array(
																	 'bo_table'						=> $row['bo_table'],
																	 'gr_id'							=> $row['gr_id'],
																	 'bo_subject'					=> $bo_subject,
																	 'bo_mobile_subject'	=> $bo_mobile_subject,
																	 'bo_skin'						=> $row['bo_skin'],
																	 'bo_mobile_skin'			=> $row['bo_mobile_skin']
																	);


							//===========================================
							// 게시판__수
							$board_t++;

					}
					// 끝 => 반복문
					//===============================================

					#################################################
					# 끝 => 게시판__목록__불러오기
					#################################################

			}
			#####################################################
			# 끝 => 게시판__불러오기
			#####################################################

	#########################################################
	# 끝 => 게시판__목록__불러오기
	#########################################################



	#########################################################
	# 시작 => 화면_ECHO
	#########################################################

	//=======================================================
	// 타이틀
	$g5['title'] = "게시판 관리";


	//=======================================================
	// HEAD__첨부
	include_once("../admin.head.php");


	//=======================================================
	// 상단__메뉴_코드
	$top_menu = 'board_manage';


	//=======================================================
	// 상단__메뉴_파일
	include_once("./top_menu.inc.php");

	#########################################################
	# 끝 => 화면_ECHO
	#########################################################


?>

	<section>
			<h2>피리 그누보드5 엑셀 다운로드 PLUS G5 > 게시판 관리</h2>

			<div class="tbl_head01 tbl_wrap">
					<table>
					<caption>게시판 관리</caption>
					<thead>
					<tr>
							<th scope="col">테이블</th>
							<th scope="col">PC 이름</th>
							<th scope="col">모바일 이름</th>
							<th scope="col">EXCEL 다운로드</th>
					</tr>
					</thead>
					<tbody>

<?php

	//=======================================================
	// 시작 => 게시판__유무
	IF ( $board_t > 0)
	{

			#####################################################
			# 시작 => 게시판__있으면
			#####################################################

			//===================================================
			// 순서
			$i = 0;


			//===================================================
			// 시작 => 반복문
			WHILE (list($key, $val) = each($board_arr))
			{

					//===============================================
					// 바탕
	        $bg = 'bg'.($i%2);


					//===============================================
					// 게시판_코드
					$bo_table = $val['bo_table'];

?>
					<tr class="<?php echo $bg; ?>">
							<td><?php echo $bo_table ?></td>
							<td><?php echo $val["bo_subject"] ?></td>
							<td><?php echo $val["bo_mobile_subject"] ?></td>
							<td><a href="excel.download.php?bo_table=<?php echo $bo_table ?>" class="str_37b44a">EXCEL 다운로드</a></td>
					</tr>

<?php

					//===============================================
					// 순서__증가
					$i++;

			}
			// 끝 => 반복문
			//===================================================

			#####################################################
			# 끝 => 게시판__있으면
			#####################################################

	}
	ELSE
	{

			#####################################################
			# 시작 => 게시판__없으면
			#####################################################

?>
					<tr>
							<td colspan="4" align="center"><strong>게시판이 없습니다.</strong></td>
					</tr>

<?php

			#####################################################
			# 끝 => 게시판__없으면
			#####################################################

	}
	// 끝 => 게시판__유무
	//=======================================================

?>

					</tbody>
					</table>
			</div>

	</section>




	<script>

<?php

	//=======================================================
	// 시작 => 게시판__유무
	IF ( $board_t > 0 )
	{

			//===================================================
			// 시작 => 반복문
			WHILE (list($key, $val) = each($board_temp_arr))
			{
?>
						click__minigeul_use(document.getElementById("bo_migl_use_n[<?php echo $bo_table ?>]"), '<?php echo $val['bo_table'] ?>');
<?php

			}
			// 끝 => 반복문
			//===================================================

	}
	// 끝 => 게시판__유무
	//=======================================================

?>


	//#######################################################
	// 시작 => 사용__체크
	function click__minigeul_use(obj, bo_table )
	{

			//===================================================
			// 시작 => 사용__체크_여부
			if (obj.checked)
			{

					//###############################################
					//## 시작 => 사용__체크_되었으면

					// 사용함
					document.getElementById("bo_migl_row_n["+bo_table+"]").disabled        = '';
					document.getElementById("bo_migl_left_menu_c["+bo_table+"]").disabled  = '';
					document.getElementById("bo_migl_left_time_c["+bo_table+"]").disabled  = '';
					document.getElementById("bo_migl_right_menu_c["+bo_table+"]").disabled = '';
					document.getElementById("bo_migl_right_time_c["+bo_table+"]").disabled = '';

			}
			else
			{

					//###############################################
					//## 시작 => 사용__체크_해제_이면

					// 사용한함
					document.getElementById("bo_migl_row_n["+bo_table+"]").disabled        = "disabled";
					document.getElementById("bo_migl_left_menu_c["+bo_table+"]").disabled  = "disabled";
					document.getElementById("bo_migl_left_time_c["+bo_table+"]").disabled  = "disabled";
					document.getElementById("bo_migl_right_menu_c["+bo_table+"]").disabled = "disabled";
					document.getElementById("bo_migl_right_time_c["+bo_table+"]").disabled = "disabled";

			}
			// 끝 => 사용__체크_여부
			//===================================================

	}
	// 끝 => 사용__체크
	//#######################################################



	//#######################################################
	// 시작 => 오른쪽_메뉴__선택
	function click__minigeul_right_menu(obj, bo_table )
	{

			//===================================================
			// 시작 => 오른쪽_메뉴__선택__여부
			if (obj.options[obj.selectedIndex].value)
			{

					// 끝 => 오른쪽_메뉴__선택_되었으면

					// 사용함
					document.getElementById("bo_migl_right_time_c["+bo_table+"]").disabled = '';


					//===================================================
					// 끝 => 오른쪽_메뉴__선택__여부
					if (obj.options[obj.selectedIndex].value == document.getElementById("bo_migl_left_menu_c["+bo_table+"]").options[document.getElementById("bo_migl_left_menu_c["+bo_table+"]").selectedIndex].value)
					{
						alert ("왼쪽 메뉴와는 다른걸 선택해 주세요.");
						obj.options[0].selected = true;
						return false;
					}

			}
			else
			{

					// 끝 => 오른쪽_메뉴__선택_안되었으면

					// 사용한함
					document.getElementById("bo_migl_right_time_c["+bo_table+"]").disabled = "disabled";

			}
			// 끝 => 오른쪽_메뉴__선택__여부
			//===================================================

	}
	// 끝 => 오른쪽_메뉴__선택
	//#######################################################



	//#######################################################
	// 시작 => FORM__SUBMIT
	function submit__minigeul_board(f )
	{

			if (!is_checked("chk[]")) {
					alert("[ 선택 수정 ] 하실 항목을 하나 이상 선택하세요.");
					return false;
			}

			return true;

	}
	// 끝 => FORM__SUBMIT
	//#######################################################

	</script>


<?php

	//=======================================================
	// ADMIN_TAIL__첨부
	include_once("../admin.tail.php");

?>