<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 11월 20일 목요일 오전 0시 33분, 날씨 맑았다

	저 작 권 : Copyright ⓒ 2014 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 관리자 > 피리 > 피리 끌어올림 FREE G5 > 설정하기
===========================================================


*/


	#########################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	#########################################################

	//=======================================================
	// 메뉴_번호__지정____끌어올림
	$sub_menu = "760004";


	//=======================================================
	// 기본처리_화일__첨부
	include_once ("./_common.php");


	//=======================================================
	// 시작 => 회원_아니면
	IF (!$is_member)
	{
		// 경고창
		alert('회원만 이용하실 수 있습니다.', G5_URL);
	}
	// 끝 => 회원_아니면
	//=======================================================


	//=======================================================
	// 관리자_확인
	auth_check($auth[$sub_menu], "r");

	#########################################################
	# 끝 => 선_처리
	#########################################################



	#########################################################
	# 시작 => 끌어올림__설정_정보_화일__첨부
	#########################################################

	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$is_get__piree_config = 1;


	//=======================================================
	// 끌어올림__설정_정보__가져오기
	$is_get__uphill_config = 1;


	//=======================================================
	// 설정_화면__여부
	$is_piree_program_config = 1;


	//=======================================================
	// 끌어올림__설정_정보_화일__경로
	$piree_dir_path = PIREE_CONFIG_PATH ."/p__".$sub_menu."/pi__config.php";


	//=======================================================
	// 끌어올림__설정_정보_화일__경로
	include_once ($piree_dir_path);

	#########################################################
	# 끝 => 끌어올림__설정_정보_화일__첨부
	#########################################################



	#########################################################
	# 시작 => 상수__변수__기타
	#########################################################

	//=======================================================
	// 끌어올림__회원_권한
	$use_level_n = $uphill_config["use_level_n"] > 0 ? $uphill_config["use_level_n"] : "";


	//=======================================================
	// 끌어올림__시간_간격
	$interval_H_n = $uphill_config["interval_time_n"] > 3599 ? floor($uphill_config["interval_time_n"]/3600) : "";


	//=======================================================
	//** UPHILL__LATEST
	// 메인_그룹__최신글__반영_여부
	$reload_latest_n = $uphill_config["reload_latest_n"];

	#########################################################
	# 끝 => 상수__변수__기타
	#########################################################



	#########################################################
	# 시작 => 마무리__페이지_ECHO_관련
	#########################################################

	//=======================================================
	// 타이틀
	$g5["title"] = "피리 끌어올림 FREE G5";


	//=======================================================
	// HEAD_첨부
	include_once ("../admin.head.php");

	#########################################################
	# 끝 => 마무리__페이지_ECHO_관련
	#########################################################


?>

<section>
		<h2>끌어올림 설정하기</h2>

		<form name="uphill_config_form" id="uphill_config_form" action="./pi__config.update.php" method="post">

		<div class="tbl_frm01 tbl_wrap">
				<table>
				<tbody>

				<tr>
					<th scope="row"><label for="use_level_n_label">끌어올림 회원 권한 (끌어올림)<strong class="sound_only">선택입력</strong></label></th>
					<td style="line-height:2.4em;">
						<input type="text" name="use_level_n" id="use_level_n_label" value="<?php echo $use_level_n; ?>" class="frm_input" size="">
						<br />
						끌어올림 할수 있는 회원 끌어올림의 숫자를 입력해 주세요.
						<br />
						입력하신 숫자의 끌어올림 회원부터 끌어올림 할수 있습니다.
						<br />
						입략하지 않으면 모든 회원이 끌어올림 할수 있습니다.
					</td>
				</tr>

				<tr>
					<th scope="row"><label for="interval_H_n_label">끌어올림 시간 간격<strong class="sound_only">선택입력</strong></label></th>
					<td style="line-height:2.4em;">
						<input type="text" name="interval_H_n" id="interval_H_n_label" value="<?php echo $interval_H_n; ?>" class="frm_input" size=""> 시간
						<br />
						글 작성하거나 끌어올림후 몇시간이 지나야 다시 끌어올림 할수 있는지 입력해 주세요.
						<br />
						12를 입력하면 12시간 지난후에 끌어올림 할수 있습니다.
						<br />
						0을 입력하면 10분 간격으로 새로고침 할수 있습니다.
						<br />
						참고) 1일 24시간, 2일 48시간, 3일 72시간, 4일 96시간, 5일 120시간, 6일 144시간, 7일 168시간, 10일 240시간
					</td>
				</tr>

<?php
//** UPHILL__LATEST
?>
				<tr>
					<th scope="row"><label for="reload_latest_n_label">메인, 그룹 최신글 반영<strong class="sound_only">선택입력</strong></label></th>
					<td style="line-height:2.4em;">
						<input type="checkbox" name="reload_latest_n" id="reload_latest_n_label" value="1"<?php	IF ($reload_latest_n == 1) { echo " checked"; }	?>> 반영하기
						<br />
						끌어올림을 하면 메인이나 그룹 화면에 반영합니다.
						<br />
						끌어올림 하면 최신글 상단에 노출됩니다.
					</td>
				</tr>

				</tbody>
				</table>
		</div>


		<br />


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>

		</form>

</section>


<?php

	//=======================================================
	// ADMIN_TAIL__첨부
	include_once ('../admin.tail.php');

?>