<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

if(!$config['cf_cert_use'] || $config['cf_cert_ipin'] != 'nice')
    alert('기본환경설정에서 NICE 아이핀 본인확인 서비스로 설정해 주십시오.');

// 실행모듈
if(PHP_INT_MAX == 2147483647) // 32-bit
    $sModulePath = G5_NICE_PATH.'/bin/IPINClient';
else
    $sModulePath = G5_NICE_PATH.'/bin/IPINClient_x64';

if($config['cf_cert_use'] == 2) {
    // 실서비스일 경우
    $sSiteCode				= "";			// IPIN 서비스 사이트 코드		(NICE평가정보에서 발급한 사이트코드)
	  $sSitePw					= "";			// IPIN 서비스 사이트 패스워드	(NICE평가정보에서 발급한 사이트패스워드)
    
    $niceForm_action  = "https://cert.vno.co.kr/ipin.cb";
} else {
    // 테스트일 경우
    $sSiteCode				= "";			// IPIN 서비스 사이트 코드		(NICE평가정보에서 발급한 사이트코드)
	  $sSitePw		      = "";			// IPIN 서비스 사이트 패스워드	(NICE평가정보에서 발급한 사이트패스워드)
    
    $niceForm_action  = "https://cert.vno.co.kr/ipin.cb";
}
$sReturnURL					= G5_NICE_URL."/ipin2.php";			// 하단내용 참조
$sCPRequest					= G5_NICE_URL."/ipin_result.php";			// 하단내용 참조

/*
┌ sModulePath 변수에 대한 설명  ─────────────────────────────────────────────────────
	모듈 경로설정은, '/절대경로/모듈명' 으로 정의해 주셔야 합니다.
	
	+ FTP 로 모듈 업로드시 전송형태를 'binary' 로 지정해 주시고, 권한은 755 로 설정해 주세요.
	
	+ 절대경로 확인방법
	  1. Telnet 또는 SSH 접속 후, cd 명령어를 이용하여 모듈이 존재하는 곳까지 이동합니다.
	  2. pwd 명령어을 이용하면 절대경로를 확인하실 수 있습니다.
	  3. 확인된 절대경로에 '/모듈명'을 추가로 정의해 주세요.
└────────────────────────────────────────────────────────────────────

┌ sReturnURL 변수에 대한 설명  ─────────────────────────────────────────────────────
	NICE평가정보 팝업에서 인증받은 사용자 정보를 암호화하여 귀사로 리턴합니다.
	따라서 암호화된 결과 데이타를 리턴받으실 URL 정의해 주세요.
	
	* URL 은 http 부터 입력해 주셔야하며, 외부에서도 접속이 유효한 정보여야 합니다.
	* 당사에서 배포해드린 샘플페이지 중, ipin_process.jsp 페이지가 사용자 정보를 리턴받는 예제 페이지입니다.
	
	아래는 URL 예제이며, 귀사의 서비스 도메인과 서버에 업로드 된 샘플페이지 위치에 따라 경로를 설정하시기 바랍니다.
	예 - http://www.test.co.kr/ipin_process.jsp, https://www.test.co.kr/ipin_process.jsp, https://test.co.kr/ipin_process.jsp
└────────────────────────────────────────────────────────────────────

┌ sCPRequest 변수에 대한 설명  ─────────────────────────────────────────────────────
	[CP 요청번호]로 귀사에서 데이타를 임의로 정의하거나, 당사에서 배포된 모듈로 데이타를 생성할 수 있습니다. (최대 30byte 까지만 가능)
	
	CP 요청번호는 인증 완료 후, 암호화된 결과 데이타에 함께 제공되며
	데이타 위변조 방지 및 특정 사용자가 요청한 것임을 확인하기 위한 목적으로 이용하실 수 있습니다.
	
	따라서 귀사의 프로세스에 응용하여 이용할 수 있는 데이타이기에, 필수값은 아닙니다.
└────────────────────────────────────────────────────────────────────
*/
?>