<?php

/**
 * 주의 사항 : curl 이 반드시 설치되어 php에서 사용 가능해야 합니다.
 * 봇과 첫번째 대화는 1:1 채팅이어야 합니다.(private chat)
 * 그 이후에 그룹방을 생성하여야 그룹방 chat_id 를 조회할수 있습니다.
 * 그룹방은 계속 생성할수 있음으로, 그 이전에 잘못 생성된 그룹방은 삭제하셔도 됩니다.
 *
 * Class Telegram
 *
 */
class Telegram {

    private $baseUrl = 'https://api.telegram.org/bot';

    //tokenKey는 텔레그램 봇의 키값입니다.
    private $tokenKey = 'bot father 를 통해 생성한 token key를 입력하세요.';

    //채팅방의 chat_id 입니다.
    //봇을 초대하여 참여한 방의 chat_id 입니다. 봇 초대후 메세지를 보내면 chat_id를 조회할수 있습니다.
    //chat_id 는 방마다 생성됨으로, 방을 용도별로 여러개 생성하고(각 방별로 봇을 초대함), 각기 다른 용도의
    //메세지를 발송할수 있습니다.
    private $default_chat_id = '-123456789';  //기본 chat_id, chat_id 를 하나만 사용하는 경우 이 값을 입력하세요. 그룹방은 보통 -로 시작합니다. 9자리 숫자로 구성됩니다.

    public function __construct() {
        $this->baseUrl = $this->baseUrl.$this->tokenKey;
    }

    private function postCurl($url, $data=array()) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($curl);
        curl_close($curl);

        return json_decode($result, true);
    }

    /**
     * 최근 텔레그램 봇과 관련된 변경 내역 조회
     * @param $offsetId
     * @return array
     */
    public function getUpdateData($offsetId) {
        $url =  $this->baseUrl.'/getUpdates?limit=100&offset='.$offsetId; //?limit=1

        $response = $this->postCurl($url);

        $result = array();

        if(!$response['ok']) return $result;

        foreach($response['result'] as $key => $value) {
            $result[$key]['text']           = $value['message']['text'];
            $result[$key]['date']           = $value['message']['date'];
            $result[$key]['from_id']        = $value['message']['from']['id'];
            $result[$key]['username']       = $value['message']['from']['username'];
            $result[$key]['chat_id']        = $value['message']['chat']['id'];
            $result[$key]['chat_type']      = $value['message']['chat']['type'];

            if($result[$key]['chat_type']  == 'group') {  //그룹방인 경우
                $result[$key]['title'] = $value['message']['chat']['title'];
            } else {
                $result[$key]['title'] = $value['message']['chat']['username'];
            }
        }
        return $result;
    }

    /**
     * @param string $msg 텔레그램으로 보낼 메세지
     * @param string $chatId 챗아이디, 지정하지 않으면, 기본 chat_id로 설정.
     * @return bool 발송 성공 여부
     */
    public function sendMessage($msg='', $chatId='') {
        $result = false;

        if(!$chatId) {
            $chatId = $this->default_chat_id;
        }

        if($msg && $chatId) {

            $url = '';
            $url .= $this->baseUrl.'/sendMessage?chat_id=';
            $url .= $chatId;
            $url .= '&text='.urlencode($msg);

            $response = $this->postCurl($url);
            $result = $response['ok'];
        }

        return $result;
    }

}

?>

