<?php
include_once("./_common.php");
set_time_limit(120); //최대 실행시간은 2분으로
ini_set('display_errors', 'On');
error_reporting(E_ALL & ~E_NOTICE);


if($is_admin != "super") {
    die("전체 관리자만 텔레그램 조회 기능을 사용할수 있습니다.");
}
include_once(G5_LIB_PATH.'/Telegram.php');
$tg = new Telegram();
$list = $tg->getUpdateData(0);


echo "<h3>텔레그램 chat_id 조회</h3>";

if(count($list) == 0) {
    echo "<ul>";
    echo "<li>아직 텔레그램 봇을 생성하지 않았거나, 텔레그램 봇과 1:1 채팅을 진행하지 않았습니다.</li>";
    echo "<li>봇생성 방법은 <a href='http://jamonggram.com/how' target='_blank'>링크를 클릭</a> 하세요.</li>";
    echo "<li>봇생성후 tokenKey를 받았다면, Telegram.php 에 설정하세요.</li>";
    echo "<li>tokenKey를 설정후  생성한 봇과 1:1 채팅(private chat) 연결후 메세지를 한번 입력하세요.</li>";
    echo "<li>위의 과정이 끝나면 아래 봇의 chat_id 리스트가 출력됩니다.</li>";
    echo "</ul>";
} else {
    echo "<ul>";
    echo "<li>private 방이 만들어졌다면, 그 이후엔 그룹방을 만들어서 봇을 초대하세요. 초대후 메세지를 한번 입력하면, 아래 목록에 표시됩니다.</li>";
    echo "<li>아래 목록의 chat_id를 Telegram.php 에 default_chat_id에 입력하세요.(대표 chat_id 하나만 입력)</li>";
    echo "<li>그룹방을 여러개 생성하여, 용도별로 메세지를 보낼경우, sendMessage 함수에 chat_id를 명시하여 호출 합니다.</li>";
    echo "</ul>";
}
?>

<style>
    table, td, th {
        border: 1px solid #ddd;
        text-align: left;
    }

    table {
        border-collapse: collapse;
        width: 100%;
    }

    th, td {
        padding: 15px;
    }
</style>


<table width="800px">
    <thead>
        <tr>
            <th>일자</th>
            <th>type</th>
            <th>chat_id</th>
            <th>그룹방명(title)</th>
            <th>메세지 발송 테스트</th>
        </tr>
    </thead>
    <tbody>
    <?php
    foreach($list as $row) {
        $row['disp_date'] = date("Y-m-d H:i:s", $row['date']);
    ?>
        <tr>
            <td><?=$row['disp_date']?></td>
            <td><?=$row['chat_type']?></td>
            <td><?=$row['chat_id']?></td>
            <td><?=$row['title']?></td>
            <td>
                <input type="" data-chat-id="<?=$row['chat_id']?>" size=50 value="" ><input type="button" class="btn_send" data-chat-id="<?=$row['chat_id']?>" value="메세지발송"/>
            </td>
        </tr>
    <?php } ?>
    </tbody>
</table>

<script src="//code.jquery.com/jquery-1.12.4.min.js"></script>
<script>
$(function() {
    $(".btn_send").click(function() {
        var chat_id = $(this).data("chat-id");
        var msg = $("input[data-chat-id='" + chat_id + "']").val();
        if(msg == "") {
            alert("텔레그램으로 전송할 메세지를 입력하세요.");
            return;
        }

        $.ajax({
            type: "POST",
            url: "./ajax.test_telegram.php",
            data: {
                "chat_id": chat_id,
                "msg": msg
            },
            cache: false,
            async: false,
            success: function(data) {
                alert("메세지를 전송했습니다.");
                result = data;
            }
        });
    });
});
</script>