<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
$CROP_PATH   = $CROP_PATH ? $CROP_PATH : '';
$CROP_URL    = $CROP_URL ? $CROP_URL : '';
$CROP_WIDTH  = is_numeric($CROP_WIDTH) && intval($CROP_WIDTH) > 0 ? $CROP_WIDTH : 200;
$CROP_HEIGHT = is_numeric($CROP_HEIGHT) && intval($CROP_HEIGHT) > 0 ? $CROP_HEIGHT : 200;
$CROP_JAVASCRIPT_ACTION = $CROP_JAVASCRIPT_ACTION ? $CROP_JAVASCRIPT_ACTION : "$('#crop_img').attr('src',image);
    $('.btn-show-crop-ctl').hide();
    $('#crop_img').show();
    canvas_bpopup.close();";
add_javascript('<script src="'.G5_PLUGIN_URL.'/tl_img_crop/js/jquery.bpopup.min.js"></script>');
add_stylesheet('<link rel="stylesheet" href="'.G5_PLUGIN_URL.'/tl_img_crop/css/style.css">');
?>
<span class="crop_img_wrap"> 
    <img src="<?php echo $CROP_URL;?>" id="crop_img" alt="회원이미지" class="btn-show-crop-ctl" style="display:<?php echo ($CROP_PATH && file_exists($CROP_PATH) ? 'block' : 'none')?>">
    <div style="margin:0;width:<?=$CROP_WIDTH?>px;text-align:center;display:<?=($CROP_PATH && file_exists($CROP_PATH) ? 'none' : 'inline-block')?>"  class="btn-show-crop-ctl"><i class="fa fa-user" style="font-size:<?=round($CROP_WIDTH * 0.8)?>px; line-height:<?=$CROP_HEIGHT?>px; color:#ccc;"></i> </div>
</span>

<div id="canvas-box" class="clearfix">
    <div id="canvas-container">
        <canvas id="canvas" width="<?php echo $CROP_WIDTH?>" height="<?php echo $CROP_HEIGHT?>" style="border:1px solid #ccc;"></canvas>
    </div>
    <div id="control-box-wrap">
        <div id="control-box">
            <div class="item image active" data-idx="0">
                <label class="file-input-wrap">
                    <i class="fa fa-image"></i> 파일선택<input type="file" class="file-input" accept="image/*">
                </label>
                <div> 
                    <button type="button" class="btn btn-ratio-up"><i class="fa fa-search-plus"></i></button>
                    <button type="button" class="btn btn-ratio-down"><i class="fa fa-search-minus"></i></button>
                    <button type="button" class="btn-fit btn"><i class="fa fa-arrows"></i></button>
                    <button type="button" class="btn-fit-max btn"><i class="fa fa-arrows-alt"></i></button>
                    <button type="button" class="btn-rotate btn"><i class="fa fa-repeat"></i></button>
                </div>
                <div> 
                	<button type="button" class="btn btn-left"><i class="move fa fa-arrow-left"></i></button> 
                    <button type="button" class="btn btn-right"><i class="move fa fa-arrow-right"></i></button>
                    <button type="button" class="btn btn-up"><i class="move fa fa-arrow-up"></i></button>
                    <button type="button" class="btn btn-down"><i class="move fa fa-arrow-down"></i></button>
                </div>
            </div>
            <div style="padding:5px;text-align:center;">
                <button type="button" id="btn-save" class="btn"><i class="fa fa-save"></i> 저장</button>
                <button type="button" id="btn-close" class="btn"><i class="fa fa-times"></i> 닫기</button>
            </div>
        </div>
    </div>
</div>
<script>
$(function() {
    var layers = [
        {type:'image', img:null, dx:0, dy:0, dw:0, dh:0, ratio:1, deg:0, show:true},
    ];
    var $canvas = $('#canvas');
    var canvas = $canvas[0];
    var context = canvas.getContext('2d');
    var cw = <?=$CROP_WIDTH?>;
    var ch = <?=$CROP_HEIGHT?>;
    
    var canvas_bpopup;
    
    $('.btn-show-crop-ctl').click(function(e) {
        canvas_bpopup = $('#canvas-box').bPopup();
    });
    
    $('#control-box').on('change', '.file-input', function(e) {
        var l_idx = $(this).parent().parent().data('idx');
        var file = e.target.files[0];
        var imageType = /image.*/;
        
        if (!file.type.match(imageType)) return;
        
        var reader = new FileReader();
        reader.onload = function(e) {
            layers[l_idx]['img'] = $('<img>', { src: e.target.result });
            layers[l_idx]['dx'] = 0;
            layers[l_idx]['dy'] = 0;
            layers[l_idx]['dw'] = 0;
            layers[l_idx]['dh'] = 0;
            layers[l_idx]['img'].load(function() {
                draw_canvas();
            });
        }
        reader.readAsDataURL(file);        
    });
        
    CanvasRenderingContext2D.prototype.rotateCenter = function (deg, x, y) { 
        context.translate(x, y);
        context.rotate(deg * Math.PI / 180);
        context.translate(-x, -y);
    }

    function draw_img(l_idx) {
        var $img = layers[l_idx]['img'];
        var ratio = layers[l_idx]['ratio'];
        if($img) {
            var nw =$img[0].naturalWidth;
            var nh = $img[0].naturalHeight;
            var dx = layers[l_idx]['dx'];
            var dy = layers[l_idx]['dy'];
            var deg = layers[l_idx]['deg'];
            if(!dx) dx = 0;
            if(!dy) dy = 0;
            
            switch(deg) {            
            case 90:
                if(deg) context.rotateCenter(deg, cw/2, ch/2);
                context.drawImage($img[0], 0, 0, nw, nh, dx, dy, nw*ratio, nh*ratio);
                if(deg) context.rotateCenter((-1 * deg), cw/2, ch/2);
                break;
            case 180:
                if(deg) context.rotateCenter(deg, cw/2, ch/2);
                context.drawImage($img[0], 0, 0, nw, nh, dx, dy, nw*ratio, nh*ratio);
                if(deg) context.rotateCenter((-1 * deg), cw/2, ch/2);
                break;                
            case 270:
                if(deg) context.rotateCenter(deg, cw/2, ch/2);
                context.drawImage($img[0], 0, 0,nw, nh, dx, dy, nw*ratio, nh*ratio);
                if(deg) context.rotateCenter((-1 * deg), cw/2, ch/2);
                break;
            default:
                context.drawImage($img[0], 0, 0, nw, nh, dx, dy, nw*ratio, nh*ratio);    
            }
        }
    }


    function draw_canvas() {
        context.clearRect(0, 0, cw, ch);
		for(var i=0; i<layers.length; i++) {
        	if(layers[i]['show']) {
				if(layers[i]['type'] == 'image') draw_img(i);
			}
		}
    }
    
    //---------------------------------------------------------
    //마우스 드레그
    var m_idx = 0;
    var e_sx = 0;
    var e_sy = 0;
    var e_flag = false; 
    var e_rad = 0;
    $canvas.mousedown(function(e) {
		m_idx = $('.item.active').data('idx');
        e_sx = e.offsetX
        e_sy = e.offsetY
        e_flag = true;
        e_rad = layers[m_idx]['deg'] * Math.PI / 180;
    });
    
    $canvas.mousemove(function(e) {
        var e_x = e.offsetX
        var e_y = e.offsetY
        if(e_flag == true) {
            var vx = e_x - e_sx;
            var vy = e_y - e_sy;
            layers[m_idx]['dx'] = layers[m_idx]['dx'] + Math.cos(e_rad) * vx + Math.sin(e_rad) * vy;
            layers[m_idx]['dy'] = layers[m_idx]['dy'] - Math.sin(e_rad) * vx + Math.cos(e_rad) * vy;
            e_sx = e_x;
            e_sy = e_y;
            draw_canvas();
        }
    });
    
    $canvas.mouseleave(function(e) {
        e_flag = false
    });
    
    $canvas.mouseup(function(e) {
        e_flag = false;
        var e_sx = 0;
        var e_sy = 0;
    });
    //---------------------------------------------------------
    
    $('#control-box').on('click','.btn-left',function() {
		var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
		
		var e_rad = layers[l_idx]['deg'] * Math.PI / 180;
		layers[l_idx]['dx'] = layers[l_idx]['dx'] + Math.cos(e_rad) * (-5);
		layers[l_idx]['dy'] = layers[l_idx]['dy'] - Math.sin(e_rad) * (-5);
        draw_canvas();
    });

    $('#control-box').on('click','.btn-right',function() {
		var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
		
        var e_rad = layers[l_idx]['deg'] * Math.PI / 180;
		layers[l_idx]['dx'] = layers[l_idx]['dx'] + Math.cos(e_rad) * (5);
		layers[l_idx]['dy'] = layers[l_idx]['dy'] - Math.sin(e_rad) * (5);
        draw_canvas();
    });
    
    $('#control-box').on('click','.btn-down',function() {
		var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
		
        var e_rad = layers[l_idx]['deg'] * Math.PI / 180;
		layers[l_idx]['dx'] = layers[l_idx]['dx'] + Math.sin(e_rad) * (5);
		layers[l_idx]['dy'] = layers[l_idx]['dy'] + Math.cos(e_rad) * (5);
        draw_canvas();
    });
    
    $('#control-box').on('click','.btn-up',function() {
		var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
		
        var e_rad = layers[l_idx]['deg'] * Math.PI / 180;
		layers[l_idx]['dx'] = layers[l_idx]['dx'] + Math.sin(e_rad) * (-5);
		layers[l_idx]['dy'] = layers[l_idx]['dy'] + Math.cos(e_rad) * (-5);
        draw_canvas();
    });

    $('#control-box').on('click','.btn-rotate',function() {
		var l_idx = $(this).parent().parent().data('idx');
        layers[l_idx]['deg']  = (layers[l_idx]['deg'] + 90) % 360;
        draw_canvas();
    });

    $('#control-box').on('click', '.btn-fit', function() {
        var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
        var nw = layers[l_idx]['img'][0].naturalWidth;
        var nh = layers[l_idx]['img'][0].naturalHeight;
        var ratio = 1;
        var dx = 0;
        var dy = 0;
        if((nw / cw) > (nh / ch)) {
            dw = cw;
            dh = ch * ((nh / ch) / (nw / cw));
            ratio = cw / nw
            dy = Math.round((dh-ch) / 2) * -1;
        }
        else {
            dh = ch;
            dw = cw * ((nw / cw) / (nh / ch) );
            ratio = ch / nh
            dx = Math.round((dw-cw) / 2 ) * -1;
        }
        layers[l_idx]['dx'] = dx;
		layers[l_idx]['dy'] = dy;
		layers[l_idx]['ratio'] = ratio;
        draw_canvas();
    });

    $('#control-box').on('click', '.btn-fit-max', function() {
        var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
        var nw = layers[l_idx]['img'][0].naturalWidth;
        var nh = layers[l_idx]['img'][0].naturalHeight;
        var ratio = 1;
        var dx = 0;
        var dy = 0;
        if((nw / cw) > (nh / ch)) {
            dw = nw * ch / nh;
            dh = ch;
            ratio = ch / nh
            dx = Math.round((dw-cw) / 2 ) * -1;
            dy = 0;
        }
        else {
            dw = cw;
            dh = nh * cw / nw;
            ratio = cw / nw
            dx = 0;
            dy = Math.round((dh-ch) / 2) * -1;
        }
        layers[l_idx]['dx'] = dx;
		layers[l_idx]['dy'] = dy;
		layers[l_idx]['ratio'] = ratio;
        draw_canvas();
    });
    
    $('#control-box').on('click','.btn-ratio-up',function(e) {
        var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
		
        var ratio = layers[l_idx]['ratio'];
        if(!ratio) {
            ratio = 1;
        }
        else {
            ratio = ratio * 1.1;
			layers[l_idx]['dx'] = layers[l_idx]['dx'] + layers[l_idx]['img'][0].naturalWidth * (layers[l_idx]['ratio'] - ratio) / 2;
			layers[l_idx]['dy'] = layers[l_idx]['dy'] + layers[l_idx]['img'][0].naturalHeight * (layers[l_idx]['ratio'] - ratio) / 2;
        }
        layers[l_idx]['ratio'] = ratio;
        draw_canvas();
    });

    $('#control-box').on('click','.btn-ratio-down',function(e) {
        var l_idx = $(this).parent().parent().data('idx');
		if (!layers[l_idx]) return;
		if (!layers[l_idx]['img']) return;
		
        var ratio = layers[l_idx]['ratio'];
        if(!ratio) {
            ratio = 1;
        }
        else {
            ratio = ratio * 0.9;
			layers[l_idx]['dx'] = layers[l_idx]['dx'] + layers[l_idx]['img'][0].naturalWidth * (layers[l_idx]['ratio'] - ratio) / 2;
			layers[l_idx]['dy'] = layers[l_idx]['dy'] + layers[l_idx]['img'][0].naturalHeight * (layers[l_idx]['ratio'] - ratio) / 2;
        }
        layers[l_idx]['ratio'] = ratio;
        draw_canvas();
    });
    
    $('#btn-save').click(function(e) {
        var image = canvas.toDataURL();
        save(image);
    });
    $('#btn-close').click(function(e) {
        canvas_bpopup.close();
    });
    
	// 구현{{{=====================================================
	function save(image) {
		<?php echo $CROP_JAVASCRIPT_ACTION;?>;
	}
	// 구현}}}=====================================================
});
</script>