/* 
*  PHPROCKS.COM chat version 0.3 
*  Copyright (C) 2015년 LEE, YONGGYO / yonggyo00@naver.com
* 이 프로그램은 자유 소프트웨어입니다. 소프트웨어 피이용허락자는 자유 소프트웨어 재단이 공표한 GNU GPL 2판 또는 그 이후 판을 임의로 선택해, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다.
*
* 이 프로그램은 유용하게 사용되리라는 희망으로 배포되지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있다는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항은 GNU GPL을 참고하시기 바랍니다.
*
* GNU GPL은 이 프로그램과 함께 제공됩니다. 만약 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다(자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA).
*/

var express = require('express');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');

var routes = require('./routes/index');
var users = require('./routes/users');

var app = express();

// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'jade');

// uncomment after placing your favicon in /public
//app.use(favicon(__dirname + '/public/favicon.ico'));
app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', routes);
app.use('/users', users);


// catch 404 and forward to error handler
app.use(function(req, res, next) {
    var err = new Error('Not Found');
    err.status = 404;
    next(err);
});

// error handlers

// development error handler
// will print stacktrace
if (app.get('env') === 'development') {
    app.use(function(err, req, res, next) {
        res.status(err.status || 500);
        res.render('error', {
            message: err.message,
            error: err
        });
    });
}

// production error handler
// no stacktraces leaked to user
app.use(function(err, req, res, next) {
    res.status(err.status || 500);
    res.render('error', {
        message: err.message,
        error: {}
    });
});


app.set('port', process.env.PORT || 3000);

/*
* error 1 : 참여할려는 방에 중복 사용자가 있음.
*
*/

var server = app.listen(app.get('port'), function() {
  console.log('Express server listening on port ' + server.address().port);
});

var io = require('socket.io').listen(server);

var chat = io.of('/chat'); // 대화방 대화

var rooms_info = []; // 방에 있는 사용자 id, username 및 roomname을 저장한다.
var room_owners = []; // 방 소유자(방장)의 목록을 저장합니다.

var reminders = []; // 공지 사항

var roomname;
chat.on('connection', function(socket) {     
    socket.on('join_room', function(data) {
        socket.join(data.room);
        roomname = data.room;
        username = data.username;
        
        // 새로운 회원이 유입 되었을 경우 참여하는 방에 중복되는 이름의 회원인지 아닌지를 확인 한 후 
        var is_username_exists = 0;
        var user_check_list = user_list(rooms_info);
        for ( key in user_check_list ) {
            if ( user_check_list[key].username == username ) { 
                    is_username_exists = 1;
                    break;
            }
        }
        if ( is_username_exists == 0 ) { // 중복되는 회원이 없는 경우 사용자 정보를 추가 하고 갱신한다.
            rooms_info.push({id : socket.id, username : username, room : roomname}); // socket.id로 구분된 회원 정보
            
            
            
            var current_users_in_current_room = user_list(rooms_info);
            chat.in(roomname).emit("users", current_users_in_current_room); // 사용자 정보 갱신
            
            var rooms = room_list(chat); // 생성된 방 목록을 가져옴
            
            // 중복이 없다면 참여한 username과 방 정보를 보내 갱신 시킨다.
            chat.in(roomname).emit('new_user', { username : username });
       
            // 방 참여자가 1인 경우는 처음 방을 개설한 경우이거나 생성된 방에서 방 참여자가 1명만 남은 상황이다.
            // 이런 경우 방의 소유자가 되며 다른 사용자의 통제 권한을 가지게 된다.
            if ( current_users_in_current_room.length == 1 ) { 
                 room_owners.push({roomname : roomname, id: socket.id});
            }
                
            for ( key in room_owners ) {
                if ( room_owners[key].roomname == roomname ) {
                     chat.in(roomname).emit('owner', room_owners[key].id);
                }
            }
            
            // 처음 접속한 경우는 기존 방에 있던 공지 사항을 보여준다.
            chat.in(roomname).emit('reminders', reminder_list(reminders)); // 공지사항을 전달 한다.
            
        } else {
            chat.in(roomname).emit('error', 1); //중복된 사용자인 경우 사용자 목록에서 삭제한다
        }
    });
    
    // 일반 대화
    socket.on('chat', function(data) {
        chat.in(roomname).emit("chat", {username : data.username, message : data.message });
    });
    
    // 귀속말
    socket.on('secret_chat', function( data ) {
        chat.in(roomname).emit('secret_chat', { secret_username : data.secret_username, username : data.username, message : data.message });  
    });
    
    // 공지
    socket.on('reminder', function(data) {
        chat.in(roomname).emit('reminder', { id : data.id, reminder : data.reminder });
        reminders.push({ id: data.id, reminder : data.reminder, room : roomname });
    });
    
    // 공지 삭제
    socket.on('remove_reminder', function(data) {
        chat.in(roomname).emit('remove_reminder', { id : data.id });
        
        // reminders 배열에 담겨 있는 공지 사항 역시 삭제 한다.
        for ( key in reminders ) { 
            if ( reminders[key].id == data.id ) {
                reminders.splice(key, 1);
            }
        }
    });
    
    // 모두 내쫒기
    socket.on('expel_all', function(data) {
        chat.in(roomname).emit('expel_all');
    });
    
    socket.on('rooms', function(data) {
       var rooms = room_list(chat); // 방 정보를 가져옴
       chat.emit('rooms', rooms);
    });
    
    // 특정 사용자 내쫒기
    socket.on('expel_user', function(data) {
        chat.in(roomname).emit('expel_user', data);
    });
    
    // 모든 사용자 정보 요청이 있는 경우
    socket.on('all_users', function(data) {
        chat.in(roomname).emit("all_users", rooms_info); // 모든 대화방의 사용자 목록을 전송합니다.
    });
    
    // 이미지 전송
    socket.on('image', function(data) {
        chat.in(roomname).emit('image', data);
    });
    
    socket.on('disconnect', function(data) {
       for ( key in rooms_info ) {
           if ( rooms_info[key].id == socket.id ) {
                rooms_info.splice(key, 1);
           }
       }
       
       var users = user_list(rooms_info);
       chat.in(roomname).emit("users", users); // 사용자 정보 갱신
       chat.in(roomname).emit('all_users', rooms_info); // 모든 대화방의 사용자 목록 전송
       
       var rooms = room_list(chat); // 방 정보 갱신
       chat.emit('rooms', rooms);
       
        // 방 참여 인원이 0인 경우는 해당 방의 공지 사항을 모두 비운다.
        if ( users.length == 0 ) {
            for ( key in reminders ) {
                if ( reminders[key].room == roomname ) {
                    reminders.splice(key, 1);
                }
            }
        }
       
       
       for ( key in room_owners ) { // 방장인 경우 역시 방을 떠난 경우는 삭제 처리 합니다. 
        if ( room_owners[key].id == socket.id ) {
            room_owners.splice(key, 1);
            
            for ( k in rooms_info ) {
                if ( rooms_info[k].room == roomname ) {
                    chat.in(roomname).emit("owner", rooms_info[k].id);
                    room_owners.push({roomname : rooms_info[k].room, id : rooms_info[k].id}); 
                    break;
                }
            }
          } else { // 방장이 방에 남아 있는 경우는 owner를 업데이트 한다.
             if ( room_owners[key].roomname == roomname ) {
                 chat.in(roomname).emit("owner", room_owners[key].id);  // 방장 업데이트
             }
          }
       }
    });
    
    
});


// 방에 해당 하는 공지 사항을 가져오기
function reminder_list ( rs ) {
    var reminders = [];
    for ( key in rs ) {
        if ( rs[key].room == roomname ) {
            reminders.push(rs[key]);
        }
    }
    
    return reminders;
}

function user_list ( room_info ) {
    var current_users_in_current_room = [];
    for ( key in room_info ) {
        if ( room_info[key].room == roomname ) {
            current_users_in_current_room.push( room_info[key] );
        }
    }
    return current_users_in_current_room;
}


// 방 목록을 가져옴
function room_list ( chat ) {
    var rooms_tmp = chat.adapter.rooms;
    var rooms = [];
       for ( key in rooms_tmp ) { // 키 값에 할당된 JSON 값이 1이상이면 방 이름과 방에 있는 사용자 socket.id가 된다.
            if ( key.length == 20 ) continue; // 글자 수가 20개인 경우는 socket.id가 되므로 20개가 아닌 key를 가져오면 되지만 방 이름의 문자열이 20개 이상인 경우 문제가 발생할 수 있어 잠재적인 오류 가능성이 있음.
            else {
                 var rs = rooms_tmp[key];
                 
                 var i = 0;
                for ( k in rs ) {
                   i++;
                }
                rooms.push({ roomname : key, users : i });
            }
       }
       return rooms;
}

// 현재 참여하고 있는 방 정보를 가져오며
function get_room_info ( room ) {
    var rooms = chat.adapter.rooms;
    for ( key in rooms ) {
        if ( key == room ) return rooms[key];
    }
}

// 전자 칠판
var wb = io.of('/whiteboard'); // 각각의 기능들은 네임스페이스로 구분되므로 독립적인 채널이다.
wb.on("connection", function(socket) {
   var wb_room;
   socket.on('join_room', function(data) {
        wb_room = data;
        socket.join(data); // 같은 방에 참여 하고
   });
   
   socket.on('sending_data', function(data) {
        wb.in(wb_room).emit("receving_data", data);
   });
});


var oneonone = io.of('/oneonone'); // 1:1 대화

var oneonone_room; 
oneonone.on("connection", function(socket) {
   socket.on("request_chat", function(data) { // 1:1 대화 요청이 들어온 경우
        socket.join(data.room);
        oneonone_room = data.room;
        oneonone.in(oneonone_room).emit('message', { username : "no_user" ,message : data.requested_user + "님에게 1:1대화를 요청 중 입니다."});
        oneonone.emit("request_chat", data);
   });
   
   socket.on("join_oneonone_room", function(room) {
        socket.join(room);
        oneonone.in(room).emit('message', { username : "no_user", message : "1:1 대화를 시작합니다."});
   });
   
   // 채팅 대화 목록
   socket.on('message', function(data) {
       oneonone.in(oneonone_room).emit('message', data);
   });
   
   socket.on('user_leave', function ( data ) {
        oneonone.in(oneonone_room).emit('message', { username : "no_user", message  : "1:1 채팅이 종료 되었습니다."});
   });
   
   socket.on("disconnect", function(data) {
       
   });
});