/* 
*  PHPROCKS.COM chat version 0.3 
*  Copyright (C) 2015년 LEE, YONGGYO / yonggyo00@naver.com
* 이 프로그램은 자유 소프트웨어입니다. 소프트웨어 피이용허락자는 자유 소프트웨어 재단이 공표한 GNU GPL 2판 또는 그 이후 판을 임의로 선택해, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다.
*
* 이 프로그램은 유용하게 사용되리라는 희망으로 배포되지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있다는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항은 GNU GPL을 참고하시기 바랍니다.
*
* GNU GPL은 이 프로그램과 함께 제공됩니다. 만약 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다(자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA).
*/

var imageupload = {
                    send_image : function ( data ) { // 이미지 데이터 전송
                        socket.emit('image', { username : chat.username, src : data } );
                    }
};
$(function() {
    $("#chat #control-panel > #imageupload-btn").click(function() {
        if ( $("#reminder").children().hasClass('ImageUpload') == false ) {
            if ( window.File && window.FileReader && window.FileList && window.Blob ) {
                var ImageUploadArea = "<div class='ImageUpload'>" + 
                                      "<div class='alert alert-info'>1MB 이하 크기의 이미지를 아래의 박스에 끌어 놓으세요.</div>\n" +
                                      "<div id='ImageDropArea'></div>" + 
                                      "</div>";
                                      
                                      
                $("#reminder").html(ImageUploadArea);
            } else alert("Drag and Drop 파일 업로드를 지원하지 않는 브라우저 입니다.");
        } else $("#reminder > .ImageUpload").remove();
    });
    
    $ImageDropArea = $("#reminder > .ImageUpload > #ImageDropArea");
    $("body").on("dragover", $ImageDropArea, function(e) {
        e.stopPropagation();
        e.preventDefault();
    });
    
    $("body").on("dragleave", $ImageDropArea, function(e) {
        e.stopPropagation();
        e.preventDefault();
    });
    
    $("body").on("drop", $ImageDropArea, function(e) {
        e.stopPropagation();
        e.preventDefault();
        
        var files = e.originalEvent.target.files || e.originalEvent.dataTransfer.files;
        
        for ( var i = 0; i < files.length; i++ ) {
        
            if ( !files[i].type.match('image.*') ) continue; // 이미지가 아닌 경우는 건너 뛴다.
    
            var reader = new FileReader();
            reader.onload = (function(file) {
                return function(evt) {
                    if ( evt.total > 1048576 ) alert("이미지 크기는 1MB 이하로 조정해 주세요.");
                    else {
                        var image = new Image();
                        image.src = evt.target.result;
                        image.style.width = '40px';
                        image.style.height = '40px';
                        image.id = "uploaded-image" + i;
                        image.onload = function() {
                            $("#ImageDropArea").append(image);
                            $("#ImageDropArea").children("#uploaded-image"+i).animate({
                                                                                   width: "80px",
                                                                                   height: "80px",
                                                                         }, "slow", function() {
                                                                            $("#ImageDropArea").scrollTop($("#ImageDropArea")[0].scrollHeight);
                                                                         });
                                                                         
                                                                            
                        }
                        
                     
                        imageupload.send_image ( evt.target.result );
                    }
                }
            })(files[i]);
            
            reader.readAsDataURL(files[i]);
        }
    });
    
    // 누군가가 이미지를 공유한 경우
    socket.on('image', function(data) {
       $("#message-box").append(
                                "<div class='well well-sm' style='border: 0; margin-top: 20px; padding: 10px; color: #ae66a8;'><b>" + data.username + "</b>님께서 사진을 공유하였습니다.</div>" + 
                                "<div style='max-width:300px;'><img src='"+data.src + "' style='width:100%;' /></div>"
       );
       $("#message-box").scrollTop($("#message-box")[0].scrollHeight);
    });
});