/* 
*  PHPROCKS.COM chat version 0.3 
*  Copyright (C) 2015년 LEE, YONGGYO / yonggyo00@naver.com
* 이 프로그램은 자유 소프트웨어입니다. 소프트웨어 피이용허락자는 자유 소프트웨어 재단이 공표한 GNU GPL 2판 또는 그 이후 판을 임의로 선택해, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다.
*
* 이 프로그램은 유용하게 사용되리라는 희망으로 배포되지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있다는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항은 GNU GPL을 참고하시기 바랍니다.
*
* GNU GPL은 이 프로그램과 함께 제공됩니다. 만약 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다(자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA).
*/

var socket = io("http://localhost:3000/chat");

var chat = {
            id : "",
            username : "",
            is_owner : 0,
            mode : 0,  // 0 - 일반 대화, 1 - 귓속말 
            new_user : 0,
            secret_chat_username : "",
            join_room : function(roomname, username){
                socket.emit('join_room', { room : roomname, username : username} );
            },
            send_message : function ( message, username ) {
                socket.emit('chat', { message : message, username : username } );
            },
            request_room_list : function() {
                socket.emit('rooms');
            },
            update_room_list : function ( rooms ) {
               var room_list = "";
               for ( key in rooms ) {
                    room_list += "<span class='label label-primary roomname'><a href='?room="+rooms[key].roomname + "&username="+chat.username+ "'>" + rooms[key].roomname + "("+rooms[key].users+")</a></span>\n";
               }
               $("#room-list").html(room_list);
            },
            request_user_list_all : function() { // 모든 사용자 호출
                socket.emit('all_users');
            },
            send_secret_message : function ( message ) { // 귓속말 
                socket.emit('secret_chat', { secret_username  : chat.secret_chat_username, username : chat.username,  message : message});
            },
            send_reminder : function ( message ) { // 공지 메세지 전달
                socket.emit('reminder', { id : Math.floor(new Date().getTime() / 1000), reminder : message }); 
            },
            remove_reminder : function ( id ) { // 공지 메세지 삭제
                socket.emit('remove_reminder', { id : id });
            },
            expel_all : function() { // 모두 내보내기 
                socket.emit('expel_all');        
            },
            expel_user : function ( user ) { // 내보내기
                socket.emit('expel_user', user );
            }
            
}

$(function() {
    var room = $("#chat").attr('room');
    var username = $("#chat").attr('username');
    chat.username = username;
    chat.join_room ( room, username );
    
    // 방이 대기실 이라면 채팅 박스를 보여주면 가리고, 대화 참여중인 사용자를 보여준다.
    if ( room == '대기실' ) {
        $(".chat-box, #control-panel").hide();
        $("#room-list").show();
        
        $("#show-room-list").html("&nbsp;방목록 닫기");
        $("#lobby-title").show();
        
        $("#show-user-list").html("&nbsp;접속자목록 닫기");
        $("#user-list-all").show();
        
        // 방 생성
        if ( $("#chat .panel-body").children().hasClass('room-create-form') == false ) {
            var room_create = "<form class='room-create-form' method='post' autocomplete='off'>" +
                              "<table class='table'>" + 
                              "<tr><td colspan=2><div class='glyphicon glyphicon-plus' style='word-spacing: -4px;'>&nbsp;대화방 만들기</div></td></tr>" + 
                              "<tr>" + 
                              "<td width='50%'><input placeholder='대화명 입력' class='form-control' type='text' name='username' value='"+username+"' /></td>" +
                              "<td width='50%'><input placeholder='방이름 입력' class='form-control' type='text' name='room' /></td>" +
                              "</tr><tr><td colspan=2>"+
                              "<input class='form-control btn btn-primary' type='submit' value='생성하기' />" +
                              "</td></tr>" +
                              "</table>" + 
                              "</form>";
            $("#chat .panel-body").append(room_create);
        }
     }
    
    // 방 정보 요청 
    chat.request_room_list();
    
    // 일반 대화 내용 
    socket.on('chat', function(data) {
       $("#message-box").append("<div>[" + data.username + "] " + data.message + "</div>");
       $("#message-box").scrollTop($("#message-box")[0].scrollHeight);
    });
    
    // 귓속말이 있는 경우
    socket.on('secret_chat', function( data ) {
        if ( data.secret_username == username || data.username == username ) { // 귓속말 대상인 경우 
            $("#message-box").append("<div>[<b>귓속말</b> " + data.username + "] " + data.message + "</div>");
            $("#message-box").scrollTop($("#message-box")[0].scrollHeight);
        }
    });
    
    // 접속자 정보 
    socket.on('users', function(data) {
       var users = "";
       for ( key in data ) {
            if ( data[key].username == username ) { // 본인 이라면 
                chat.id = data[key].id;
            }
           users += "<div class='users' id='"+data[key].id+"'>" + data[key].username + "</div>\n";
       }
       $("#user-list").html(users);
    });
    
    // 방 정보
    socket.on('rooms', function(data) { // 현재 개설된 방 정보
        chat.update_room_list(data);
    });
    
    socket.on('owner', function(data) {
       if ( data == chat.id ) { // 반약 방장이라면 
           chat.is_owner = 1;
       }
       else chat.is_owner = 0; // 방장 권한이 없다면 0으로 변경한다.
       
       if ( chat.is_owner == 1 ) { // 방장 이라면 사용자 통제(강제 퇴장, 방장 넘기기)를 추가 한다.
          if ( $("#control-panel").children().hasClass('admin-panel') == false ) {
            
            $("#control-panel").append("<div class='btn btn-default glyphicon glyphicon-cog admin-panel'> 방관리</div>"); 
          }
       }
       
       $("#"+data).addClass("room-owner");
    });
    
    // 새로운 사용자
    socket.on('new_user', function(data) { // 새로운 회원이 대화에 참여 했을 때, 인사말을 출력하고 방 정보를 갱신한다.
        $("#message-box").append("<div><b>"+ data.username + "</b>님이 대화에 참여 하였습니다.</div>");
        $("#message-box").scrollTop($("#message-box")[0].scrollHeight);
        chat.request_room_list(); // 새로운 참여자가 있는 경우 방 정보 업데이트
        
        // new_user로 유입이 된 경우는 중복이 안 된 경우이다.  그러므로 chat.new_user 를 1로 변경한다.
        chat.new_user = 1;
        
    });
    
    
    // 에러 메세지 처리
    socket.on('error', function(code) {
        switch ( code ) {
           case 1 : {
                      if ( room != '대기실' && chat.new_user == 0 ) {
                           alert("참여 하실려는 방에 동일한 대화명이 존재 합니다.\n 다른 대화명을 사용하세요"); 
                           window.location.href='?username=' + username;
                       }
                       break;
                     }
        }
    });
    
    chat.request_user_list_all(); // 대기실 이므로 모든 사용자를 요청하고
    
    // 모든 사용자 목록 - 사용자 id, username, 방이름이 표시가 된다.
    socket.on('all_users', function(data) {
        var all_users = "<ul class='list-group' style='margin-top: 5px;'>\n" + 
                        "<li class='list-group-item glyphicon glyphicon-list'> 접속자수 <span class='badge'>" + data.length + "</span></li>";
        
        for ( key in data ) {
            if ( data[key].username == username ) continue;
            
            all_users += "<li class='list-group-item'>" + 
                          "<div style='float:left;'>["+data[key].room+"]"+data[key].username+"</div>" + 
                          "<div style='float:right;' popup-user='"+data[key].username+"' id='"+data[key].id+"'>" +
                          "<div style='font-size: 8.7pt; margin-bottom: 3px; word-spacing: -5px;' class='one-one-chat btn btn-default btn-sm glyphicon glyphicon-user'> 1:1대화 신청</div>" + 
                          "<span>" + 
                          "<form method='post'>" + 
                          "<input type='hidden' name='username' value='"+username+"' />" + 
                          "<input type='hidden' name='room' value='"+data[key].room+"' />" + 
                          "<input style='word-spacing: -5px;' type='submit' value='같은방으로 이동'  class='btn btn-default btn-sm' />" + 
                          "</form>" + 
                          "</span>" + 
                          "</div>"+
                          "<div style='clear:both;'></div>" + 
                         "</li>";
        }
        
        all_users + "</ul>\n";
        
        $("#user-list-all").html(all_users);
    });
    
    $(".input-message").keyup(function(e) {
       if ( e.keyCode == 13 ) { // 엔터를 눌렀을 경우 
            switch ( chat.mode ) {
                case 0 : chat.send_message( $(this).val(), username ); break; // 일반 대화
                case 1 :  chat.send_secret_message ( $(this).val() ); break; // 귀속말 대화인 경우
            }
           
           $(this).val('');
       }
    });
    
    
    // 소켓 통신을 제외한 이벤트
    // 방목록 보기를 클릭한 경우
    $("#show-room-list").click(function() {
       if ( $("#room-list").css("display") == "none" ) {
        $("#room-list").slideDown();
        $(this).html("&nbsp;방목록 닫기");
       }
       else {
        $("#room-list").slideUp();
        $(this).html("&nbsp;방목록 보기");
       }
    });
    
    // 접속자 목록 보기를 클릭한 경우 
    $("#show-user-list").click(function() {
        if ( $("#user-list-all").css("display") == "none" ) {
            $("#user-list-all").slideDown();
            $(this).html("&nbsp;접속자목록 닫기");
        } else {
            $("#user-list-all").slideUp();
            $(this).html("&nbsp;접속자목록 보기");
        }
    });
    
    // 사용자를 클릭할 경우
    $("body").on("click", "#user-list > .users", function() {
        var user = $(this).text();
        // 위치
        $pos = $(this).position();
        var xpos = Math.round($pos.left);
        var ypos = Math.round($pos.top) + 20;
        
        // 클릭한 사용자의 팝업이 이미 떠 있는 경우는 팝업을 제거 하고 그렇지 않다면 팝업을 새로 띄운다.
        if ( $(".user-popup").attr('popup-user') == user ) $(".user-popup").remove();
        else {
        
            // 미리 떠 있는 팝업은 제거 하고 
            $(".user-popup").remove();
            if ( user != username )  { // 팝업을 보려는 사용자가 자기 자신이 아닌 경우만 팝업을 보여준다.
          
                var popup = "<div class='user-popup' popup-user='"+user+"'  style='position:absolute; top: " + ypos + "px; left: " + xpos + "px;'>" +
                               "<div class='secret-chat'>" + user + "에게 귓속말</div>" + 
                               "<div class='one-one-chat'>1:1대화 신청</div>" + 
                               "</div>";
                
                $(this).parent().prepend(popup);
            }
         }
    });
    
    // 귓속말 클릭 했을 때
    $("body").on("click", ".secret-chat", function() {
        var secretchatmode = " / <b>" + $(this).parent().attr('popup-user') + "</b>님에게 귓속말" +
                                        " <span class='btn btn-default btn-sm glyphicon glyphicon-refresh' id='cancel-secret-chat'> 귓속말 취소</span>"; 
        $("#mode-message").html(secretchatmode);
        
        chat.mode = 1; // 귓속말 모드로 변경 한다.
        chat.secret_chat_username = $(this).parent().attr('popup-user');
    });
    
    // 귓속말 취소
    $("body").on("click", "#cancel-secret-chat", function() {
        chat.mode = 0; // 일발 대화 모드로 변경 
        chat.secret_chat_username = ""; // 귓속말 상대방
        $("#mode-message").html("");
    });
    
    $("#control-panel > #room-leave").click(function() { // 방나가기
        window.location.href='?room=대기실&username='+username;
    });
    
    // 방관리
    $("body").on("click", "#control-panel > .admin-panel", function() {
        if ( $("#chat").children().hasClass('admin-menu') == false ) {
            var admin_menu = "<div class='admin-menu'>" +
                             "<div id='admin-menu-reminder'>공지 메세지</div>" +
                             "<div id='admin-menu-expel-user'>내보내기</div>" + 
                             "<div id='admin-menu-expel-all'>모두 내보내기</div>" +
                             "<br style='clear:both;' />" +
                             "</div>";         
            $("#chat").append(admin_menu);
        } else $(".admin-menu").remove();
    });
    
    // 방관리 - 공지사항
    $("body").on("click", "#admin-menu-reminder", function() {
        if ( $("#reminder").children().hasClass('input-reminder') == false ) {
            $("#reminder").prepend("<input type='text' style='position: absolute; top: 0; left: 0; z-index:10000;' class='input-reminder form-control' placeholder='공지내용을 입력하세요...'/>");
        } else $("#reminder > .input-reminder").remove();
        
        $(".admin-menu").remove();
    });
    
    // 공지사항을 입력 했을 때
    $("body").on("keyup", "#reminder > .input-reminder", function(e) {
       
        if ( e.keyCode == 13 ) { // 엔터 키를 눌렀을 경우
            // 입력된 글자가 있는 경우 글을 전송 한다. 관리를 위해 각각의 공지는 uniqid를 하나씩 가지게 되며 이 id로 공지글 삭제가 가능하다.
            if ( $(this).val().length > 0 ) { 
                chat.send_reminder( $(this).val() ); 
            }
            $("#reminder > .input-reminder").remove();
        }
    });
    
    
    // 공지사항 데이터를 수신한 경우
    socket.on('reminder', function(data) {
        var reminder = "<div class='reminder-rows' id='"+ data.id +"'><span class='label label-danger' style='font-size: 10pt;'>공지</span> " + data.reminder;
        
        if ( chat.is_owner == 1 ) { // 방장이라면 공지 사항을 삭제할 수 있는 버튼이 생성이 된다.
            reminder += "<span class='remove-reminder btn btn-default btn-sm glyphicon glyphicon-trash' style='margin-left: 50px;'> 삭제</span>";
        }
        
        reminder += "</div>";
        $("#reminder").prepend(reminder);
    });
    
    // 공지 삭제
    $("body").on("click", "#reminder > .reminder-rows > .remove-reminder", function() {
        var reminder_id = $(this).parent().attr('id');
        
        chat.remove_reminder ( reminder_id );
    });
    
    // 공지 사항 삭제를 수신한 경우
    socket.on('remove_reminder', function(data) {
        $("#reminder > #"+data.id).remove();
    });
    
    
    // 처음 접속하였을 때 방에 있던 공지 사항 출력
    socket.on('reminders', function(data) {
        var reminder  = "";
        for ( key in data ) {
           reminder += "<div class='reminder-rows' id='"+ data[key].id +"'><span class='label label-danger' style='font-size: 10pt;'>공지</span> " + data[key].reminder;
        
            if ( chat.is_owner == 1 ) { // 방장이라면 공지 사항을 삭제할 수 있는 버튼이 생성이 된다.
                reminder += "<span class='remove-reminder btn btn-default btn-sm glyphicon glyphicon-trash' style='margin-left: 50px;'> 삭제</span>";
            }
        
            reminder += "</div>";
        }
        $("#reminder").html(reminder); 
    });
    
    // 방관리 - 내보내기
    $("body").on("click", "#admin-menu-expel-user", function() {
        if ( $("#reminder").children().hasClass('expel-user-input-box') == false ) {
            var expel_user =
                            "<div class='alert alert-info'>내보낼 사용자명을 아래의 박스에 입력하세요.</div>" + 
                            "<table class='expel-user-input-box' cellpadding=0 cellspacing=0 width='100%'>" + 
                             "<tr>" + 
                             "<td><input type='text' class='form-control' placeholder='내보낼 사용자명을 입력하세요.' /></td><td width=5></td>" +
                             "<td width=50><button class='btn btn-default btn-sm' id='expel-cancel'><span class='glyphicon glyphicon-repeat'></span> 취소</button></td>" + 
                             "<td width=5></td>" + 
                             "<td width=50><button class='btn btn-default btn-sm' id='expel-btn'><span class='glyphicon glyphicon-ok'></span> 내보내기</button></td>" + 
                             "</tr>" + 
                             "</table>";
            $("#reminder").html(expel_user);
            
        } else $("#reminder > .expel-user-input-box").remove();
        
        $(".admin-menu").remove();
    });
    
    $("body").on("keyup", ".expel-user-input-box input[type='text']", function(e) {
        if ( e.keyCode == 13 ) { // 엔터를 눌렀을 경우
            if ( $(this).val().length > 0 ) { // 입력된 문자가 있는 경우는 사용자를 기입한 것으로 본다.
                chat.expel_user ( $(this).val() );
            }
            
            $("#reminder > .expel-user-input-box").remove();
        }
    });
    
    $("body").on("click", ".expel-user-input-box #expel-btn", function() {
        if ( $(".expel-user-input-box input[type='text']").val().length > 0  ) { // 입력된 문자가 있는 경우는 사용자를 기입한 것임 
            chat.expel_user ( $(".expel-user-input-box input[type='text']").val() );
        }
        
         $("#reminder > .expel-user-input-box").remove();
    });
    
    socket.on('expel_user', function(data) {
        if ( chat.is_owner == 0 && username == data ) { // 방장이 아니면서 내보낼 대화명과 동일한 경우
            alert("방에서 쫒겨 나셨습니다.");
            window.location.href='?username='+username;
        }
    });
    
    // 방관리 - 모두 내보내기
    $("body").on("click", "#admin-menu-expel-all", function() {
        chat.expel_all();
        
        $(".admin-menu").remove();
    });
     
    // 모두 내보내기를 수신 하였을 경우      
    socket.on('expel_all', function(data) { 
        if ( chat.is_owner == 0 ) {   // 방장이 아닌 경우만 내보낼 수 있다.
            alert("방에서 쫒겨 나셨습니다.");
            window.location.href='?username='+username;
        }
    });
});

