/* 
*  PHPROCKS.COM chat version 0.3 
*  Copyright (C) 2015년 LEE, YONGGYO / yonggyo00@naver.com
* 이 프로그램은 자유 소프트웨어입니다. 소프트웨어 피이용허락자는 자유 소프트웨어 재단이 공표한 GNU GPL 2판 또는 그 이후 판을 임의로 선택해, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다.
*
* 이 프로그램은 유용하게 사용되리라는 희망으로 배포되지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있다는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항은 GNU GPL을 참고하시기 바랍니다.
*
* GNU GPL은 이 프로그램과 함께 제공됩니다. 만약 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다(자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA).
*/

var socket_oneonone = io("http://localhost:3000/oneonone");
var oneonone = {
                requested_user : "",
                roomname : "",
                chat_started : 0,
                request_chat : function () {
                    socket_oneonone.emit('request_chat', { 'request_user' : chat.username, 'requested_user': oneonone.requested_user, 'room' : oneonone.roomname});
                },
                join_oneonone_room : function() {
                    socket_oneonone.emit('join_oneonone_room', oneonone.roomname);
                }
}

$(function() {
    $("body").on("click", ".one-one-chat", function() {
            oneonone.chat_started = 1;  // 1:1 채팅 시작으로 변경하고

            show_layer_popup(); // 팝업을 보여주고,
             
            // 대화 요청을 보낸다.
            oneonone.requested_user = $(this).parent().attr('popup-user');
            oneonone.roomname = chat.username + "_" + oneonone.requested_user;
            oneonone.request_chat();
            
            
    });
    
    socket_oneonone.on('request_chat', function(data) {
       if ( data.requested_user == chat.username ) {
           if ( confirm(data.request_user + "님께서 1:1대화를 신청하셨습니다.\n대화에 참여하시겠습니까?") ) {
               oneonone.roomname = data.room;
               oneonone.join_oneonone_room(); // 1:1 방에 참여 합니다.   
               oneonone.chat_started = 1; // 1:1 채팅을 시작 합니다.
               show_layer_popup();
           }
       }
    });
    
    // 메세지 처리
    socket_oneonone.on('message', function(data) {
           if ( oneonone.chat_started == 1 ) {
                var message = "";
                 if ( data.username != 'no_user' ) {
                     message += "[" + data.username + "]";
                } 
                message += data.message;
                $("#oneonone-message-box").append("<div>" + message + "</div>").scrollTop($("#oneonone-message-box")[0].scrollHeight);
           }
    });
    
    // 1:1 채팅 종료
    socket_oneonone.on('user_leave', function() {
            close_layer_popup();
    });
    
    $("body").on("keyup", "#oneonone-input-box", function(e) {
        if ( e.keyCode == 13 ) { // 엔터를 누른 경우 메세지 전달
           socket_oneonone.emit('message', { username : chat.username, message : $(this).val() });
           $(this).val('');
        }
    });
    
    // 레이어 팝업 닫기
    $("body").on("click", ".layer-popup-wrapper, #close-oneonone", function() {
            socket_oneonone.emit('user_leave');
            oneonone.chat_started = 0;
            close_layer_popup();
     });
});

function show_layer_popup() {
    if ( $("body").children().hasClass('layer-popup-wrapper') == false ) {
        $("body").prepend(
                                "<div class='layer-popup-wrapper'></div>" + 
                                "<div class='layer-popup'></div>"
                                
        );
            
        var popup_width = 400;
        var popup_height = 500;
        if ( $(window).height() < 400 ) var window_height = popup_height + 200;
        else window_height = $(window).height();
        var popup_xpos = ($(window).width() / 2) - (popup_width / 2);
        var popup_ypos = (window_height / 2) - (popup_height / 2);
            
        $(".layer-popup-wrapper").css({
                                           position : "fixed",
                                           backgroundColor : "#222222",
                                           opacity : "0.8",
                                           width: "100%",
                                           height: window_height,
                                           top: 0,
                                           left: 0,
                                           zIndex: "100000"
        });
                     
        $(".layer-popup").css({
                                  position : "fixed",
                                  backgroundColor : "#FFFFFF",
                                  width: popup_width,
                                  height: popup_height,
                                  top: popup_ypos,
                                  left: popup_xpos,
                                  zIndex: "200000",
                                  padding: "10px"
        }).html(
                 "<div id='oneonone-message-box'></div>\n" + 
                 "<div><input type='text' class='form-control' id='oneonone-input-box'  placeholder='메세지 입력...' /></div>" + 
                 "<div style='margin-top: 10px;'><div style='float:left;' class='btn btn-default glyphicon glyphicon-th-large btn-sm'> 화상요청</div><div style='float:right;' class='btn btn-default glyphicon glyphicon-remove btn-sm' id='close-oneonone'> 채팅종료</div><div style='clear:both;'></div></div>"
        );
    }
}

function close_layer_popup() {
    $(".layer-popup-wrapper, .layer-popup").remove();
}