/* 
*  PHPROCKS.COM chat version 0.3 
*  Copyright (C) 2015년 LEE, YONGGYO / yonggyo00@naver.com
* 이 프로그램은 자유 소프트웨어입니다. 소프트웨어 피이용허락자는 자유 소프트웨어 재단이 공표한 GNU GPL 2판 또는 그 이후 판을 임의로 선택해, 그 규정에 따라 프로그램을 개작하거나 재배포할 수 있습니다.
*
* 이 프로그램은 유용하게 사용되리라는 희망으로 배포되지만, 특정한 목적에 맞는 적합성 여부나 판매용으로 사용할 수 있다는 묵시적인 보증을 포함한 어떠한 형태의 보증도 제공하지 않습니다. 보다 자세한 사항은 GNU GPL을 참고하시기 바랍니다.
*
* GNU GPL은 이 프로그램과 함께 제공됩니다. 만약 이 문서가 누락되어 있다면 자유 소프트웨어 재단으로 문의하시기 바랍니다(자유 소프트웨어 재단: Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA).
*/

var socket_wb = io("http://localhost:3000/whiteboard");

var ctx;
var wb_colors = ["#000000","#646464","#e2e2e2","#ff0000","#ff8585","#000cff","#5159fb","#9a9fff","#00ff30","#4bfb6c","#8effa3","#fede04","#ffe641", "#fef5b8"]; // 색상
var wb_fontsizes = ["9pt", "11pt", "15pt", "20pt", "30pt", "40pt"]; // 글자 크기 

var wb_style = {
    strokeStyle : "#646464",
    lineWidth : 4,
    fontSize : "11pt",
    font : "dotum"
};
var wb = {
            is_drawing : false,
            is_eraser : false,
            is_eraser_start : false,
            is_text : false,
            is_sended : false,
            xpos : function (e) {
                $pos = $("#white-board > canvas").position();
                return e.pageX - $pos.left;
            },
            ypos : function (e) {
                $pos = $("#white-board > canvas").position();
                return e.pageY - $pos.top;
            },
            start : function(e) {
                if ( wb.is_eraser ) {
                    this.is_eraser_start = true;
                    
                } else if ( wb.is_text ) { // 글씨 쓰기 인 경우 
                    $("#white-board .wb-control-panel > #wb-text-input").css({top: wb.ypos(e) + 20 + "px", left: wb.xpos(e) - 10 + "px"}).show();
                    
                    
                } else { // 그리기 모드 인 경우 
                    ctx.beginPath();
                    ctx.moveTo(wb.xpos(e),wb.ypos(e));
                    this.is_drawing = true;
                  
                    // 소켓으로 데이터 전송
                    var data = {
                                is_drawing : this.is_drawing, 
                                mode : 'start',
                                xpos : wb.xpos(e), 
                                ypos : wb.ypos(e),
                                style : wb_style
                    };
                    
                    wb.sending_data(data);
                } 
            },
            move : function(e) {
                if ( this.is_eraser_start ) { // 지우기가 시작 된 경우
                    ctx.clearRect(wb.xpos(e) - 6, wb.ypos(e) - 6, 12, 12); 

                    var data = {
                                    mode : 'eraser',
                                    xpos : wb.xpos(e),
                                    ypos : wb.ypos(e),
                    };
                    
                    wb.sending_data(data);
                    
                } else { // 그리기 인 경우 
                    if ( this.is_drawing ) { 
                        ctx.lineTo(wb.xpos(e), wb.ypos(e));
                        ctx.stroke();
                        
                        // 소켓으로 데이터 전송
                        var data = {
                                    is_drawing : this.is_drawing, 
                                    mode : 'move',
                                    xpos : wb.xpos(e), 
                                    ypos : wb.ypos(e),
                                    style : wb_style
                        }
                        wb.sending_data(data);        
                    } 
                }
                
            },
            stop : function() {
                if ( wb.is_eraser ) {
                    this.is_eraser_start = false;
                } else {
                    this.is_drawing = false;
                
                    wb.sending_data({is_drawing : this.is_drawing, mode : 'stop' });
                }
                
            },
            clear : function() { // 모두 지우기
                $cv = $("#white-board > canvas");
                ctx.clearRect(0,0, $cv.width(), $cv.height());
                wb.sending_data({ mode : 'clear' });
            },
            text : function ( text, xpos, ypos ) { // 글자 쓰기 
                ctx.font= wb_style.fontSize + " " + wb_style.font;
                ctx.fillStyle = wb_style.strokeStyle;
                ctx.fillText(text, xpos, ypos - 20);
                
                wb.sending_data({ mode : 'text', text : text, xpos : xpos, ypos : ypos - 20, style : wb_style});
            },
            drawimage : function ( image_url ) {
                var image = new Image();
                image.src = image_url;
                image.height = 300;
                image.onload = function() {
                    ctx.drawImage(image, 10, 10);
                    wb.sending_data({ mode : 'image', image : image_url});
                }
            },
            join_room : function ( room ) {
                socket_wb.emit('join_room', room);
            },
            sending_data : function ( data ) {
                socket_wb.emit('sending_data', data);
                this.is_sended = true;
            },
            receiving_data : function ( data ) { // 전송받은 데이터를 그대로 그려준다.
                if ( this.is_sended == false ) {
                    if ( data.mode == 'start' ) {
                        ctx.beginPath();
                        ctx.moveTo(data.xpos, data.ypos);
                        this.is_drawing = data.is_drawing;
                        
                        ctx.strokeStyle = data.style.strokeStyle;
                        ctx.lineWidth = data.style.lineWidth;
                    } else if ( data.mode == 'move' ) {
                        this.is_drawing  = data.is_drawing;
                        ctx.lineTo(data.xpos, data.ypos);
                        ctx.stroke();
                        
                    } else if ( data.mode == 'stop' ) {
                        this.is_drawing = data.is_drawing;
                        
                        // 스타일의 경우 그리기가 끝나면 원래 사용하고 있는 생상으로 돌아간다.
                        ctx.strokeStyle = wb_style.strokeStyle;
                        ctx.lineWidth = wb_style.lineWidth;
                    }
                    else if ( data.mode == 'clear' ) { // 모두 지우기 인 경우
                        $cv = $("#white-board > canvas");
                        ctx.clearRect(0,0, $cv.width(), $cv.height());
                    }
                    else if ( data.mode == 'eraser' ) { // 지우개 모드 인 경우 
                        ctx.clearRect(data.xpos - 6, data.ypos - 6, 12, 12);
                    }
                    else if ( data.mode == 'text' ) { // 글쓰기 모드 인 경우 
                         ctx.font= data.style.fontSize + " " + data.style.font;
                         ctx.fillStyle = data.style.strokeStyle;
                         ctx.fillText(data.text, data.xpos, data.ypos); // 글쓰기가 완료 되면 원래의 글자 스타일로 변경 한다.
                         
                         ctx.font = wb_style.fontSize + " " + wb_style.font;
                         ctx.fillStyle = wb_style.strokeStyle;
                    }
                    else if ( data.mode == 'image' ) { // 이미지 모드
                        var image = new Image();
                        image.src = data.image;
                        image.height = 300;
                        image.onload = function() {
                            ctx.drawImage(image, 10, 10);
                        };
                        
                    }
                }
                this.is_sended = false;
            }
};
$(function() {
    $cv = $("#white-board > canvas");
    ctx = $cv.get(0).getContext('2d');
    ctx.strokeStyle = wb_style.strokeStyle;
    ctx.lineWidth = wb_style.lineWidth;
    
    $cv.on("mousedown", wb.start);
    $cv.on("mousemove" ,wb.move);
    $cv.on("mouseup", wb.stop);
    
    var wb_room = $("#chat").attr('room'); // 방이름
    wb.join_room(wb_room);
    
    // 전자 칠판 패널 생성
    $("#white-board").prepend("<div class='btn-group wb-control-panel'></div>");
    var wb_buttons = "<button type='button' class='btn btn-default glyphicon glyphicon-trash btn-sm' id='wb-clear-all'></button>\n" + 
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-pencil' id='wb-pencil'></button>\n" + 
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-unchecked' id='wb-eraser'></button>\n" + 
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-text-size' id='wb-text'>가</button>" +
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-text-size' id='wb-fontsize'>PT</button>" + 
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-picture' id='wb-image'></button>" +
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-minus' id='wb-linewidth'></button>" + 
                     "<button type='button' class='btn btn-default btn-sm glyphicon glyphicon-tint' id='wb-color'></button>" + 
                     "<div id='wb-color-panel'></div>";
    $("#white-board .wb-control-panel").html(wb_buttons);
    
    var wb_color_panel = ""
          
    for ( key in wb_colors ) {
         wb_color_panel += "<div class='wb-color-sel' color='"+ wb_colors[key] +"' style='margin-top: 2px; background-color: " + wb_colors[key] + "; width:28px; height:28px; float:left; cursor:pointer;'>&nbsp;</div>";
    }
    wb_color_panel += "<div stlyle='clear:left;'></div>";
    
     $("#wb-color-panel").hide().html(wb_color_panel);
    
    
    // 선 굵기
    var wb_linewidth = "";
    $("#white-board .wb-control-panel").append("<div id='wb-linewidth-sel'></div>");
    for ( var i = 1; i <= 20; i+= 3 ) {
       wb_linewidth += "<div linewidth="+ i + " class='wb-linewidth-sels' style='width: 30px; border-top: "+i+"px solid #000000; margin: 7px 0; cursor:pointer;'></div>";
    }
    $("#white-board .wb-control-panel #wb-linewidth-sel").html(wb_linewidth);
    
    
    // 글씨 쓰기
    $("#white-board .wb-control-panel").append("<input type='text' id='wb-text-input' placeholder='글 입력..'/>");
    
    
    // 글씨 크기  
    $("#white-board .wb-control-panel").append("<div id='wb_fontsize_sel'></div>");
    
    var wb_fontSize_sels = "";
    for ( key in wb_fontsizes ) {
        wb_fontSize_sels += "<div class='wb_fontsize_sels'>" + wb_fontsizes[key] + "</div>";
    }
    $("#white-board .wb-control-panel #wb_fontsize_sel").html(wb_fontSize_sels);
    
    // 이미지 그리기
    $("#white-board .wb-control-panel").append( "<input type='text' id='wb-image-address' class='form-control' placeholder='이미지 URL 입력..' />");
    
    
    // 전자 칠판 패널 끝
    
    
    
    socket_wb.on('receving_data', function(data) {
        wb.receiving_data(data); // 전송 받은 데이터를 그대로 그려줌.
    });
    
    
    $("#show-white-board").click(function() {
          if ( $("#white-board").css("display") == "none" ) $("#white-board").slideDown();
          else $("#white-board").slideUp();
            
    });
    
    $("body").on("click", "#white-board #wb-clear-all", function() {
       $("#white-board #wb-text-input").hide();
       $("#white-board #wb-image-address").hide();
       
       wb.clear(); // 모두 지우기
    });
    
    $("body").on("click", "#white-board #wb-eraser",  function() {
        $("#white-board #wb-text-input").hide();
        $("#white-board #wb-image-address").hide();
        
        wb.is_eraser = true; // 지우개 모드로 변경
        wb.is_text = false; // 글쓰기 모드 취소
    });
    
    $("body").on("click", "#white-board #wb-pencil", function() {
        $("#white-board #wb-image-address").hide();
        
        $("#white-board #wb-text-input").hide();
        wb.is_eraser = false; // 지우개 모드 취소
        wb.is_eraser_start = false;
        wb.is_text = false; // 글쓰기 모드 취소
    });
    
    $("body").on("click", "#white-board #wb-color", function() { // 색상 패널 보이거나 닫기
         $("#white-board #wb-image-address").hide();
         
         if ( $("#wb-color-panel").css("display") == "none" ) $("#wb-color-panel").show();
         else $("#wb-color-panel").hide();
    });
    
    // 색상 선택
    $("body").on("click", "#white-board #wb-color-panel > .wb-color-sel", function() {
        $("#white-board #wb-image-address").hide();
        $("#white-board #wb-text-input").hide();
        
        $("#white-board #wb-color-panel > .wb-color-sel").removeClass('selected');
        $(this).addClass('selected');
        wb_style.strokeStyle = ctx.strokeStyle = $(this).attr('color');
    });
    
    // 선 굵기 패널 보이기 
    $("body").on("click", "#white-board #wb-linewidth", function() {    
       $("#white-board #wb-image-address").hide();
       $("#white-board #wb-text-input").hide();
       
       var pos = $(this).position();
      $("#wb-linewidth-sel").css({top: pos.top + 30 + "px", left: pos.left - 1 + "px"});
      if ( $("#wb-linewidth-sel").css("display") == "none" )$("#wb-linewidth-sel").slideDown();
      else $("#wb-linewidth-sel").slideUp();
    });
    
    
    // 선 굵기 선택
    $("body").on("click", "#white-board .wb-linewidth-sels", function() {
       $("#white-board #wb-text-input").hide();
       wb_style.lineWidth = ctx.lineWidth = $(this).attr('linewidth');
       $("#wb-linewidth-sel").slideUp();
    });
    
    // 글쓰기 버튼 클릭 시
    $("body").on("click", "#white-board #wb-text", function() { 
        $("#white-board #wb-image-address").hide();
        
        wb.is_text = true;  // 글쓰가 모드로 변경하고 
        wb.is_eraser = false; // 지우개 모드 취소 
        wb.is_eraser_start = false;
    });
    
    // 글을 썼을 때
    $("body").on("keyup", "#white-board #wb-text-input", function(e) {
        if ( e.keyCode == 13 ) {
            if ( $(this).val().length > 0 ) { // 실제로 글이 입력 된 경우
                var pos = $(this).position(); // 현재의 좌표를 구하고 
                wb.text ( $(this).val(), pos.left, pos.top ); // 글을 현재 좌표에 입력 한다.
            }
            
            $(this).val('').hide();
        }
    });
    
    // 글자 사이즈 변경 패널 보이거나 닫기
    $("body").on("click", "#white-board #wb-fontsize", function() {
        $("#white-board #wb-image-address").hide();
        
        var pos = $(this).position();
        $fontsize_sel = $("#white-board .wb-control-panel #wb_fontsize_sel")
        $fontsize_sel.css({top: pos.top + 30 + "px", left : pos.left + "px"});
        
        if ( $fontsize_sel.css("display") == "none" ) $fontsize_sel.slideDown();
        else $fontsize_sel.slideUp();
    });
    
    // 글자 사이즈 변경
    $("body").on("click", "#white-board .wb-control-panel .wb_fontsize_sels", function() {
        
        wb_style.fontSize = $(this).text();
        ctx.font = $(this).text() + " " + wb_style.font;
        $("#white-board .wb-control-panel #wb_fontsize_sel").slideUp();
    });
    
    // 이미지 그리기 버튼 클릭
    $("body").on("click", "#white-board #wb-image", function() {
        $wb_image_address = $("#white-board .wb-control-panel > #wb-image-address");
        if ( $wb_image_address.css("display") == "none" ) $wb_image_address.show();
        else $wb_image_address.hide();
    });
    
    // 이미지 전자 칠판에 그려주기
    $("body").on("keyup", "#white-board #wb-image-address", function(e) {
        if ( e.keyCode == 13 ) {
            if ( $(this).val().length > 0 ) {
             wb.drawimage($(this).val());
            }
            $(this).val('').hide();
        }
    });
});