var express = require('express');
var router = express.Router();

// GET 방식으로 값이 넘어온 경우
router.get('/', function(req, res) {
  var room; // 방이름 
  if ( typeof req.query.room == 'undefined' || req.query.room == "" ) room = "대기실";
  else room = req.query.room;
  
  //아이디
  var username;
  if ( typeof req.query.username == 'undefined' || req.query.username == "" ) username = "GUEST" + Math.floor(Date.now() / 1000);
  else username = req.query.username;
  
  res.render('index', { 
                        "room" : room,
                        "username" : username
                       });
});

/*
* Post로 값이 넘어 온 경우 중복 되는 코드지만 현재로서는 대안이 없다. 
*  다른 좋은 방법이 나타난다면 대체할 예정이다.
*/
router.post('/', function(req, res) {
  var room; // 방이름 
  if ( typeof req.body.room == 'undefined' || req.body.room == "" ) room = "대기실";
  else room = req.body.room;
  
  
  //아이디
  var username;
  if ( typeof req.body.username == 'undefined' || req.body.username == "" ) username = "GUEST" + Math.floor(Date.now() / 1000);
  else username = req.body.username;
  
  res.render('index', { 
                        "room" : room,
                        "username" : username
                       });
  
});

module.exports = router;
