class App{
    static BASE_HTML = `
    <div id="header">
        <div class="title_area">실시간 채팅</div>
    </div>
    <div id="body">
        <div class="messages"></div>
        <div class="bottom-line"></div>
        <div class="box">
            <div class="frame_msg">
                <textarea id="msg_input" placeholder="메시지를 입력하세요." autofocus></textarea>
                <a href="#" class="send_button" id="send_button"><i class="fa fa-paper-plane"></i></a>
            </div>
        </div>
    </div>
    `;
    constructor(wrapper,mb_id,proto,hostname = location.hostname,port = 1121){
        this.wrapper = document.querySelector(wrapper);
        this.wrapperSelector = `.chatapp${wrapper}`;
        this.history = [];
        this.historyNow = -1;
        this.mb_id = mb_id;
        this.addr = `${proto}://${hostname}:${port}/index.goza?mb_id=${this.mb_id}`;
        this.socket = io.connect(this.addr);

        $(this.wrapper).addClass('chatapp');
        $(this.wrapper).html(App.BASE_HTML);

        console.log(this);
        
        this.socket.on('connect_error',(function(e){
            alert('채팅서버 연결에 실패했습니다.\n다시 시도해보세요.');
            this.socket.close();
        }).bind(this));
        
        this.socket.on('connected_users',function(){
            //
        });
        
        this.socket.on('messages',(function(data){
            this.addMessageEl(data.data);
        }).bind(this));

        this.socket.on('cmd',function(data){
            switch(data.cmd){
                case 'alert':
                    alert(data.data.msg);
                    if(data.data.console_log) console.log(data.data.console_log);
                break;
                case 'alert_close':
                    alert(data.data.msg);
                    if(data.data.console_log) console.log(data.data.console_log);
                    window.close();
                break;
            }
        });

        $(`${this.wrapperSelector} #msg_input`).keydown((function(e){
            if(e.keyCode == 13 && !e.shiftKey){
                this.sendTrigger(e);
            }else if(e.keyCode == 38){
                if(this.historyNow < this.history.length - 1){
                    this.historyNow++;
                    var v = this.history[this.historyNow] ? this.history[this.historyNow] : '';
                    $(`${this.wrapperSelector} #msg_input`).val(v);
                }
            }else if(e.keyCode == 40){
                if(this.historyNow != -1){
                    this.historyNow--;
                    var v = this.history[this.historyNow] ? this.history[this.historyNow] : '';
                    $(`${this.wrapperSelector} #msg_input`).val(v);
                }
            }
        }).bind(this));

        $(`${this.wrapperSelector} .send_button`).click(this.sendTrigger.bind(this));

        this.socket.emit('all_messages');
    }

    sendTrigger(e){
        var val = $(`${this.wrapperSelector} #msg_input`).val();
        if(val){
            e.preventDefault(); // 기존 엔터키 이벤트 제거
            this.saveMessage({ msg:val }); // 메시지를 서버로 전송
            this.history.unshift(val);
            this.history = [...new Set(this.history)];
            this.historyNow = -1;
            $(`${this.wrapperSelector} #msg_input`).val(''); // ... 했으니 input area의 값 제거
        }
    }

    scrollToBottom(){
        var d = document.querySelector(`${this.wrapperSelector} .messages`);
        var sh = d.scrollHeight;
        var ch = d.clientHeight;
        d.scrollTop = sh - ch;
    }

    addMessageEl(data){
        for(var i in data){
            var me = data[i].ch_mb_id == this.mb_id ? ' me' : '';
            var date = new Date(data[i].ch_date);
            var html = '';
            html += `<div class="message${me}" data-id="${data[i].ch_id}">`;
            html += `<span class="writer">${data[i].ch_mb_nick}</span>`;
            html += `<span class="mb_id">${data[i].ch_mb_id}</span>`;
            html += `<span class="datetime">${date.getFullYear()}년 ${date.getMonth()+1}월 ${date.getDate()}일 ${date.toTimeString().substr(0,8)}</span>`;
            html += `<div class="content">${data[i].ch_msg}</div>`;
            html += `</div>`;
            $(`${this.wrapperSelector} .messages`).append(html);
        }
        this.scrollToBottom();
    }

    deleteMessageEl(ids){
        for(var i in ids){
            $(`${this.wrapperSelector} .message[data-id=${ids[i]}]`).each(function(){
                this.remove();
            });
        }
        this.scrollToBottom();
    }
    
    saveMessage(data){
        this.socket.emit('save_message',data);
    }
}