const cfg = require('../config');
const db = require('knex')({
    client:'mysql2',
    connection:cfg.db
});

var mysql_interval = setInterval(() => {
    db.raw('select 1 as a');
}, 1800000);

module.exports = class Database{
    static async find_account(mb_id){
        let result = await db(cfg.tables.member).where('mb_id','=',mb_id).select();
        return result[0];
    }

    static async search_banlist(mb_id){
        let result = await db(cfg.tables.banlist).where('ba_mb_id','=',mb_id).select();
        return result[0];
    }

    static async ban_user(mb_id,reason){
        await db(cfg.tables.banlist).insert({ ba_mb_id:mb_id,ba_reason:reason }).onConflict().merge({ ba_reason:reason });
    }

    static async unban_user(mb_id){
        await db(cfg.tables.banlist).where('ba_mb_id',mb_id).del();
    }
    
    static async banlist(mb_id,reason){
        return await db(cfg.tables.banlist).select();
    }

    static async all_messages(){
        let result = await db(cfg.tables.messages).select().innerJoin(cfg.tables.member, 'ch_mb_id', 'mb_id');
        let final_result = [];
        for(let row of result){
            final_result.push({
                ch_id:row.ch_id,
                ch_mb_id:row.ch_mb_id,
                ch_mb_nick:row.mb_nick,
                ch_msg:row.ch_msg,
                ch_date:row.ch_date,
                ch_last_modified:row.ch_last_modified
            });
        }
        return final_result;
    }

    // msg_row에 날짜를 추가해 db에 넣고 그대로 리턴
    static async save_message(data){
        let date = new Date();
        data.ch_date = date;
        data.ch_last_modified = date;
        await db(cfg.tables.messages).insert(data).onConflict().merge({ ch_msg:data.ch_msg,ch_last_modified:date });
        return data;
    }
}