const Database = require('./Database');
const Commands = require('./Commands');
const Util = require('./Util');

// 현재접속자 리스트
module.exports = class G5ChatListener{
    constructor(io){
        this.connected_users = [];
        this.io = io;
        io.on('connection',this.onconnection.bind(this));
    }

    async onconnection(socket){
        let qs = socket.handshake.query;
        if(!qs.mb_id) return socket.emit('cmd',{
            cmd:'alert_close',
            data:{
                // base64 문자열
                msg:'오류 발생: 7IKs7Jqp7J6Q66qFIOuNsOydtO2EsOqwgCDsoITri6zrkJjsp4Ag7JWK7J2M'
            }
        });

        // 계정 확인
        let account = await Database.find_account(qs.mb_id);
        if(!account) return socket.emit('cmd',{
            cmd:'alert_close',
            data:{
                msg:'존재하지 않는 사용자입니다.'
            }
        });
        
        // 밴 확인
        let ban_data;
        if(ban_data = await Database.search_banlist(account.mb_id)){
            return socket.emit('cmd',{
                cmd:'alert_close',
                data:{
                    msg:`당신은 관리자에 의해 차단되었습니다. 사유: ${ban_data.ba_reason}`
                }
            });
        }

        // 현재접속자 리스트에 저장
        this.connected_users.push(account.mb_id);
        this.io.emit('connected_users',{
            list:[...new Set(this.connected_users)]
        });

        socket.on('all_messages',async () => {
            socket.emit('messages',{
                data:(await Database.all_messages()).map((el) => {
                    el.ch_msg = Util.parse_format(el.ch_msg);
                    return el;
                })
            })
        });

        socket.on('save_message',async (data) => {
            if(!data.msg.trim()) return socket.emit('cmd',{
                cmd:'alert',
                data:{
                    msg:'정상적이지 않은 값이 내용으로 입력되었습니다.'
                }
            });
            let cmd;
            if(!data.dont_use_command && account.mb_level >= 10 && (cmd = Commands.parseCommand(data.msg))){
                switch(cmd.name){
                    case 'ban':{
                        let mb_id = cmd.args.shift();
                        let reason = cmd.args.join(' ');
                        if(!mb_id){
                            socket.emit('cmd',{
                                cmd:'alert',
                                data:{
                                    msg:`사용자명을 입력하세요.`
                                }
                            });
                        }else if(!reason){
                            socket.emit('cmd',{
                                cmd:'alert',
                                data:{
                                    msg:`밴 사유를 입력하세요.`
                                }
                            });
                        }else{
                            await Database.ban_user(mb_id,reason);
                            socket.emit('cmd',{
                                cmd:'alert',
                                data:{
                                    msg:`${mb_id} 계정에 대한 밴 처리가 완료되었습니다. 사유: ${reason}`
                                }
                            });
                        }
                    }break;
                    case 'unban':{
                        let mb_id = cmd.args.shift();
                        if(!mb_id){
                            socket.emit('cmd',{
                                cmd:'alert',
                                data:{
                                    msg:`사용자명을 입력하세요.`
                                }
                            });
                        }else{
                            await Database.unban_user(mb_id);
                            socket.emit('cmd',{
                                cmd:'alert',
                                data:{
                                    msg:`${mb_id} 계정에 대한 밴 해제 처리가 완료되었습니다.`
                                }
                            });
                        }
                    }break;
                    case 'banlist':{
                        let listString = (await Database.banlist())
                        .map(a => `${a.ba_mb_id} - ${a.ba_reason || '(사유 없음)'}`).join('\n');
                        socket.emit('cmd',{
                            cmd:'alert',
                            data:{
                                msg:`밴 목록:\n${listString}`
                            }
                        });
                    }break;
                }
                return;
            }
            let msg_row = {
                ch_id:data.id,
                ch_mb_id:account.mb_id,
                ch_msg:data.msg
            };
            let row = await Database.save_message(msg_row);
            row.ch_mb_nick = account.mb_nick;
            this.io.emit('messages',{
                data:[row].map((el) => {
                    el.ch_msg = Util.parse_format(el.ch_msg);
                    return el;
                })
            });
        });
        socket.on('connected_users',() => {
            socket.emit('connected_users',{
                list:[...new Set(this.connected_users)]
            });
        });

        socket.on('disconnect',() => {
            for(let i = 0;i < this.connected_users.length;i++){
                if(this.connected_users[i] === account.mb_id){
                    this.connected_users.splice(i, 1);
                    break;
                }
            }
            socket.broadcast.emit('connected_users',{
                list:[...new Set(this.connected_users)]
            });
        });
    }
}