module.exports = class Util{
    static parse_format(str){
        return str
        // 쓸데없는 html 태그 제거
        .replace(/</g,'&lt;')
        .replace(/>/g,'&gt;')

        // 강조 서식 추가(마크다운 style)
        .replace(/\*\*(.+?)\*\*/g,'<b>$1</b>')
        .replace(/__(.+?)__/g,'<b>$1</b>')
        .replace(/\*([^\*]+)\*/g,'<b>$1</b>')
        .replace(/_([^_]+)_/g,'<i>$1</i>')
        .replace(/\=\=(.+?)\=\=/g,'<u>$1</u>')
        .replace(/\-\-(.+?)\-\-/g,'<del>$1</del>')

        // 닉네임 강조/링크 추가
        .replace(/@([^ ]+)/g,'<span class="user_tag">@$1</span>')
        .replace(/\[(.+?)\]\((blank|self|parent|top):(.+?)\)/g,'<a href="$3" target="_$2" class="target_link">$1</a>')
        .replace(/\[(blank|self|parent|top):(.+?)\]/g,'<a href="$2" target="_$1" class="target_link">$2</a>')
        .replace(/\[(.+?)\]\((.+?)\)/g,'<a href="$2" class="link">$1</a>')
        .replace(/\[(.+?)\]/g,'<a href="$1" class="link">$1</a>')
        .trim();
    }
}