const cfg = require('./config'); // 설정파일

// 모듈
const app = require('express');
const fs = require('fs');
const G5ChatListener = require('./controllers/G5ChatListener');
const http = cfg.main.useHttps ? require('https').createServer({
    cert:fs.readFileSync(cfg.main.httpsCredentials.cert),
    key:fs.readFileSync(cfg.main.httpsCredentials.key)
},app) : require('http').createServer(app);
const io = require('socket.io')(http,{
    cors:{
        origin:'*'
    }
});

const main = io.of('/index.goza');
new G5ChatListener(main);

http.listen(cfg.main.port,function(){
    console.log(`${cfg.main.useHttps ? 'HTTPS' : 'HTTP'} Server is running. port: ${cfg.main.port}`);
});