<?php


namespace mc;


class CategorySelectboxAdmin extends CategorySelectbox
{
    public $placeholder = '선택';

    public function renderAsButton(){
        $category = $this->category;
        $data_column = $this->data_column;
        $value = $this->value;
        $selected = Category::get($value);
        ?>
        <div class="mc-group">
            <button type="button"
                    onclick="mc_handle_btn(this)"
                    data-input-name="<?=$this->input_name;?>"
                    data-root="<?=$this->root->mc;?>"
                    data-name="<?=$data_column;?>"
                    data-value="<?=$value;?>"><?=$selected->title;?></button>
        </div>
        <?php
    }

    public function render()
    {
        $category = $this->category;
        $value = $this->value;
        $max_depth = $category->getMaxDepth();
        $items = array($category->getChild());

        $data_column = $this->data_column === 'mc'? 'mc':'path';

        ?>
        <div class="mc-group" data-name="<?= $this->input_name; ?>" data-type="<?=Column::DATASET_CATEGORY;?>" data-root="<?=$category->mc;?>" data-category-column="<?=$data_column;?>">
            <input type="hidden" name="<?= $this->input_name; ?>" value="<?= $value; ?>">
            <?php for ($i = 0; $i < $max_depth; $i++):
                $disabled = $items[$i]? '':' disabled';
                ?>
                <select data-name="<?= $this->input_name; ?>" onchange="mc_handle(this)"<?=$disabled;?>>
                    <?php printf('<option value="">%s</option>', $this->placeholder);?>
                    <?php if ($items[$i]) {

                        foreach ($items[$i] as $item): $selected = $value === $item->$data_column ? ' selected' : ''; ?>
                            <?php if ($selected) {
                                $items[$i + 1] = $item->getChild();
                            }
                            $total = count($item);
                            $disabled = $total ===0? ' disabled':'';
                            ?>
                            <option value="<?= $item->$data_column; ?>" <?= $selected; ?><?=$disabled;?>><?= $item->title; ?>(<?=$total;?>)</option>
                        <?php endforeach;
                    } ?>
                </select>
            <?php

            endfor; ?>
        </div>
        <?php
    }
}