(function ($, window) {
    var api = {};

    var parser = function (data) {
        if (data) {
            if (data.alert) {
                alert(data.alert);
            }
            if (data.reload) {
                location.reload();
            }
        }
    };

    var exec = function (mode, data) {
        data.mode = mode;
        $.ajax({
            url: 'ajax.php',
            type: 'post',
            data: data,
            dataType: 'json',
            success: function (data) {
                parser(data);
            }
        })
    };

    api.remove = function (mc) {
        if (confirm("삭제하시겠습니까?")) exec('remove', {mc: mc});
    };
    api.moveUp = function (mc) {
        if (mc > 1) exec('moveUp', {mc: mc});
    };
    api.moveDown = function (mc) {
        if (mc > 1) exec('moveDown', {mc: mc});
    };
    api.removeConfigColumn = function (bo_table, column) {
        if (confirm("삭제하시겠습니까?")) {
            exec('removeConfigColumn', {bo_table: bo_table, column: column});
        }
    }

    api.handleSubmit = function (evt) {
        evt.preventDefault();
        if (evt.target.tagName !== 'FORM') {
            alert('올바른 요청이 아닙니다.');
            return;
        }
        var form = $(evt.target);
        form.find("button[type=submit]").prop('disabled', true);
        var data = form.serialize();
        console.log(data);
        $.ajax({
            url: 'ajax.php',
            type: 'post',
            data: data,
            dataType: 'json',
            success: function (data) {
                parser(data);
                if (data) {
                    if (!data.reload) {
                        form.find("button[type=submit]").prop('disabled', false);
                    }
                }
            }
        });
    };
    $(function () {
        $("form.mc-ajax-form").on("submit", api.handleSubmit);
    });
    if (window.mcApi) {
        $.extend(window.mcApi, api);
    } else {
        window.mcApi = api;
    }
})(jQuery, window);